/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology.element;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.topology.GroupElement;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class HostGroupElement
extends GroupElement {
    private static final Log LOGGER = LogFactory.getInstance(HostGroupElement.class);

    public HostGroupElement() {
    }

    public HostGroupElement(DrHostGroup hostGroup) {
        this.setName(TopoServiceUtil.getNodeShowName((String)hostGroup.getName()));
        this.setImage("/theme/recoverydirector/images/topo/hostgroup.png");
        this.setToolTip(this.getHostGroupTooltip(hostGroup));
        this.setStyle("label.bold", false);
        this.setStyle("label.font", this.getTopoResourceManager().getText("ism.drm.topo.label.font"));
        this.setStyle("group.outline.color", "0xb8d6e5");
        this.setStyle("group.outline.width", 0);
        this.setStyle("group.fill.color", "0xedf6fa");
        this.setStyle("group.shape", "circle");
        this.setStyle("select.alpha", 1.0);
        this.setStyle("select.style", "none");
        this.setClient("imageWidth", 48.0);
        this.setClient("imageHeight", 60.0);
        this.setExpanded(true);
    }

    protected String getHostGroupTooltip(DrHostGroup hostGroupInfo) {
        StringBuilder builder = new StringBuilder();
        this.appendTooltip(builder, "ism.drm.topo.host.ip", hostGroupInfo.getIpAddress());
        this.appendTooltip(builder, "ism.drm.topo.hostgroup.name", StringEscapeUtil.escape((String)hostGroupInfo.getName()));
        ITopoResourceManager resourceManager = this.getTopoResourceManager();
        String os = hostGroupInfo.getOsType();
        if (!TopoServiceUtil.isNullStr((String)os)) {
            int osType;
            try {
                osType = NumberUtil.convertToInteger((Object)os);
            }
            catch (Exception e) {
                osType = Integer.MIN_VALUE;
                LOGGER.error((Object)("parse os type failed,os:" + os + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
            os = osType >= 1 && osType <= 8 ? resourceManager.getText("ism.drm.topo.host.os." + osType) : null;
        }
        this.appendTooltip(builder, "ism.drm.topo.host.os", os);
        return builder.toString();
    }
}

