/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology.model;

import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.topology.element.HostElement;
import com.huawei.ism.drm.topo.model.IMultiView;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.topology.Node;

public class HostNode
implements IMultiView {
    private static final String TOPO_MODEL = "HOST";
    private static final String ICON_PATH = "/theme/recoverydirector/images/topo/hostIcon.png";
    private static final double GROUP_LOCAL_OUTLINE_CORLOR = 1.2113637E7;
    private static final double GROUP_LOCAL_OUTLINE_WIDTH = 2.0;
    private static final double GROUP_LOCAL_FILL_COLOR = 1.5595258E7;
    private static final double GROUP_REMOTE_OUTLINE_CORLOR = 1.2113637E7;
    private static final double GROUP_REMOTE_OUTLINE_WIDTH = 2.0;
    private static final double GROUP_REMOTE_FILL_COLOR = 1.5595258E7;
    private static final String GROUP_SHAPE = "roundrect";
    private static final String GROUP_LAYOUT = "leftright";
    private static final double INNER_TOP_GAP = 7.0;
    private static final double INNER_LEFT_GAP = 7.0;
    private static final double INNER_SONS_GAP = 7.0;
    private final ITopoResourceManager resourceManager;
    private String label;
    private Node group = null;
    private DrHost host = null;

    public HostNode(DrHost host, ITopoResourceManager resourceManager) {
        this.label = host.getName();
        this.setHost(host);
        this.resourceManager = resourceManager;
        this.initNode();
    }

    private void initNode() {
        this.group = new Node((Object)this.host.getDeviceSn());
        this.group.setIcon(ICON_PATH);
        this.group.setImage("/theme/recoverydirector/images/topo/host.png");
        this.group.setClient("iconFlag", true);
        this.group.setStyle("icons.names", (Object)ICON_PATH);
        this.group.setStyle("label.bold", false);
        this.group.setStyle("label.font", (Object)this.resourceManager.getText("ism.drm.topo.label.font"));
        this.group.setStyle("icons.position", (Object)"topleft.topright");
        this.group.setClient("imageWidth", 48.0);
        this.group.setClient("imageHeight", 60.0);
        this.group.setClient("iconWidth", 48.0);
        this.group.setClient("iconHeight", 48.0);
        this.group.setName(TopoServiceUtil.getNodeShowName((String)this.label));
        this.group.setToolTip(this.createHostToolTip(this.host));
        this.group.setStyle("vector.roundrect.radius", 7);
        this.group.setStyle("label.position", (Object)"topleft.topright");
        this.group.setStyle("label.xoffset", 48.0);
        this.group.setStyle("label.yoffset", -4.0);
        this.group.setClient("layout", (Object)GROUP_LAYOUT);
        this.group.setClient("TopoModel", (Object)TOPO_MODEL);
        this.group.setClient("leftGap", 7.0);
        this.group.setClient("topGap", 7.0);
        this.group.setClient("sonsGap", 7.0);
        this.group.setStyle("content.type", (Object)"vector");
        this.group.setStyle("vector.shape", (Object)GROUP_SHAPE);
        this.group.setStyle("select.alpha", 1.0);
        this.group.setStyle("select.style", (Object)"none");
    }

    public Node getNode() {
        return this.group;
    }

    public void setNode(Node node) {
        this.group = node;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Node getLocalView() {
        this.group.setStyle("vector.fill.color", 1.5595258E7);
        this.group.setStyle("vector.outline.width", 2.0);
        this.group.setStyle("vector.outline.color", 1.2113637E7);
        return this.group;
    }

    public Node getRemoteView() {
        this.group.setStyle("vector.fill.color", 1.5595258E7);
        this.group.setStyle("group.outline.width", 2.0);
        this.group.setStyle("group.outline.color", 1.2113637E7);
        return this.group;
    }

    public DrHost getHost() {
        return this.host;
    }

    public void setHost(DrHost host) {
        this.host = host;
    }

    public String createHostToolTip(DrHost hostData) {
        return HostElement.createHostToolTip(hostData);
    }
}

