/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.ClusterInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.ClusterInfo;
import com.huawei.ism.drm.app.sdk.model.VolumeGroup;
import com.huawei.ism.drm.application.sdk.model.DB2DatabaseInstance;
import com.huawei.ism.drm.application.sdk.model.ExchangeInstance;
import com.huawei.ism.drm.application.sdk.model.SAPHANADatabaseInstance;
import com.huawei.ism.drm.application.sdk.model.SqlServerDatabaseInstance;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.agent.action.ClusterAction;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostGroupService;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.ism.host.sdk.model.HostFileSystem;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;

public final class DrHostUtil {
    private static Log logger = LogFactory.getInstance(DrHostUtil.class);

    private DrHostUtil() {
    }

    public static List<DrHost> getDrHostsRegisteredBySn(List<String> siteIds, String[] resSns) {
        if (VerifyUtil.isEmpty(siteIds) || VerifyUtil.isEmpty((Object[])resSns)) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sb.append("from DrHost where siteId in(");
        for (String siteId : siteIds) {
            sb.append("?,");
            params.add(siteId);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") and deviceSn in(");
        for (String resSn : resSns) {
            sb.append("?,");
            params.add(resSn);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        return template.find(sb.toString(), params.toArray());
    }

    public static DrHostGroup getDrHostGroupByGroupID(String hostGroupId) {
        if (VerifyUtil.isEmpty((String)hostGroupId)) {
            logger.error((Object)"hostGroupId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        DrHostGroup drHostGroup = null;
        try {
            List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrHostGroup where dbId=?", new Object[]{hostGroupId});
            if (!VerifyUtil.isEmpty((Collection)results)) {
                drHostGroup = (DrHostGroup)results.get(0);
            }
        }
        catch (Exception ex) {
            String errorMsg = "failed to get DrHostGroup of dbId:" + hostGroupId;
            ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
        return drHostGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DrHost> getDrHostBySNs(String[] hostSns) {
        List hostResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(DrHost.class);
            criteria.add(Restrictions.in((String)"deviceSn", (Object[])hostSns));
            hostResult = criteria.list();
        }
        catch (Exception ex) {
            try {
                String errorMsg = "failed to get DrHost of sns:" + hostSns[0];
                ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)-1L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return hostResult;
    }

    public static Host getExistHost(NeMgrProtocolExtend extend) {
        Host existHost = null;
        String hostSN = (String)extend.getExtendParams().get("mac_address");
        if (!VerifyUtil.isEmpty((String)hostSN)) {
            existHost = (Host)CommonDAOLocator.getMoDao().getMo(Host.class, "hostSN", (Object)hostSN);
        }
        return existHost;
    }

    public static Set<ManagedObject> getHostAppInfo(String hostSn) {
        HashSet<ManagedObject> appSet = new HashSet<ManagedObject>();
        HashMap<String, String> dbProps = new HashMap<String, String>();
        dbProps.put("hostSN", hostSn);
        List dbInstances = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, "name", false, dbProps);
        if (!VerifyUtil.isEmpty((Collection)dbInstances)) {
            appSet.addAll(dbInstances);
        }
        HashMap<String, String> fsProps = new HashMap<String, String>();
        fsProps.put("hostSN", hostSn);
        List allFSIns = CommonDAOLocator.getMoDao().findMoBy(HostFileSystem.class, "name", true, fsProps);
        if (!VerifyUtil.isEmpty((Collection)allFSIns)) {
            appSet.addAll(allFSIns);
        }
        HashMap<String, String> opcProps = new HashMap<String, String>();
        opcProps.put("hostSN", hostSn);
        List clusters = CommonDAOLocator.getMoDao().findMoBy(ClusterInstance.class, "name", true, opcProps);
        if (!VerifyUtil.isEmpty((Collection)clusters)) {
            appSet.addAll(clusters);
        }
        return appSet;
    }

    public static void updateAppInfo(Host host, Map<Integer, List<ManagedObject>> resultInfo) {
        HashSet<ManagedObject> appMos = new HashSet<ManagedObject>();
        Set<Map.Entry<Integer, List<ManagedObject>>> moSet = resultInfo.entrySet();
        for (Map.Entry<Integer, List<ManagedObject>> entry : moSet) {
            appMos.addAll((Collection)entry.getValue());
        }
        HashMap<String, Integer> moMap = new HashMap<String, Integer>();
        moMap.put(DB2DatabaseInstance.class.getName(), 3);
        moMap.put(ExchangeInstance.class.getName(), 8);
        moMap.put(HostFileSystem.class.getName(), 9);
        moMap.put(DatabaseInstance.class.getName(), 15);
        moMap.put(OracleInstance.class.getName(), 1);
        moMap.put(SqlServerDatabaseInstance.class.getName(), 2);
        moMap.put(SAPHANADatabaseInstance.class.getName(), 16);
        moMap.put(OpenGaussCluster.class.getName(), 19);
        Set<ManagedObject> existApps = DrHostUtil.getHostAppInfo(host.getSn());
        if (!VerifyUtil.isEmpty(existApps)) {
            for (ManagedObject managedObject : existApps) {
                Integer appType = (Integer)moMap.get(managedObject.getType());
                logger.debug((Object)("get app sucess,appType:" + appType + ",moType:" + managedObject.getType() + ",moName:" + managedObject.getName() + ",hostIP:" + host.getIpAddress()), 90160758786988L);
                if (resultInfo.containsKey(appType)) continue;
                logger.info((Object)("get app exception,appType:" + appType + ",moType:" + managedObject.getType() + ",moName:" + managedObject.getName() + ",hostIP:" + host.getIpAddress()), 90160758786989L);
                appMos.add(managedObject);
            }
        }
        for (ManagedObject o : appMos) {
            logger.debug((Object)("get app ,moType:" + o.getType() + ",moName:" + o.getName() + ",IP:" + host.getIpAddress()), 90160758786988L);
            o.setParentMo((ManagedObject)host);
            host.addChildMo(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHostDiscoveryHost(String ip) {
        List result = null;
        String selectSQL = "select distinct PARAMVAL from ti_ne_user_properties where NAME=:iname";
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(selectSQL);
            query.setString("iname", ip);
            session.beginTransaction();
            result = query.list();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("get HostDiscoveryParams failed. ip:" + ip + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786874L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    public static boolean checkHostGroupUsed(String hostGroupID) {
        boolean result = false;
        ServiceLocator locator = ServiceLocator.getInstance();
        IProtectGroupService protectGroupService = (IProtectGroupService)locator.getService(IProtectGroupService.class);
        IRecoveryPlanService recoveryService = (IRecoveryPlanService)locator.getService(IRecoveryPlanService.class);
        boolean isUsedByProtectGroup = protectGroupService.isHostGroupUsedByProtectGroup(hostGroupID);
        boolean isUsedByRecoveryPlan = recoveryService.isUsedHostGroupByRp(hostGroupID);
        if (isUsedByProtectGroup || isUsedByRecoveryPlan) {
            result = true;
        }
        return result;
    }

    public static NeMgrProtocolExtend getNeMgrProtocolExtend(INeMgrProtocolExtendService neMgr, String hostSN) {
        Host host = (Host)CommonDAOLocator.getMoDao().getMo(Host.class, "hostSN", (Object)hostSN);
        if (null == host) {
            logger.error((Object)("host(" + hostSN + ") not exists."), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        NeMgrProtocolExtend ne = neMgr.findByMoId(host.getMoId());
        if (null == ne) {
            logger.error((Object)("host(" + hostSN + ")'s NeMgrProtocolExtend(" + host.getMoId() + ") not exists."), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return ne;
    }

    public static void sendMsg(ManagedObject mo, Long optType, String className) {
        if (VerifyUtil.isEmpty((Object)optType)) {
            logger.debug((Object)"opttype is null,not send message.");
            return;
        }
        ManagedObject parentMo = mo.getParentMo();
        Set childMos = mo.getChildMos();
        mo.setParentMo(null);
        mo.setChildMos(null);
        try {
            logger.debug((Object)("Will send " + optType + " , mo name is : " + mo.getName()), 90160777658372L);
            HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
            messageMap.put(mo.getMoId(), mo);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(optType.longValue());
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(className);
            ((IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class)).sendMessage(mu);
            logger.debug((Object)("Send  " + optType + " , mo name is : " + mo.getName()), 90160777658372L);
        }
        catch (Exception e) {
            logger.error((Object)("Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
        mo.setParentMo(parentMo);
        mo.setChildMos(childMos);
    }

    public static String getCurrentDisasterHost(RecoveryPlan recoveryPlan, int procType) {
        String hostOrGroupId = null;
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947394L);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == procType) {
            ProtectGroup pg = (ProtectGroup)pgIter.next();
            if (null != pg) {
                hostOrGroupId = pg.getPoProviderSN();
            }
        } else {
            String pgUUID = ((ProtectGroup)pgIter.next()).getUuid();
            RecoverySetting curDisasterHostSetting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)pgUUID, (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            hostOrGroupId = null == curDisasterHostSetting ? (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST") : curDisasterHostSetting.getValue();
        }
        if (VerifyUtil.isEmpty((String)hostOrGroupId)) {
            logger.error((Object)"hostOrGroupId is empty.");
            throw new LegoCheckedException(-1L, "The setting of disaster host does not exist.planId:" + recoveryPlan.getPlanId());
        }
        return hostOrGroupId;
    }

    public static void generateOfflineAlarm(Host host) {
        ManagedObject mo = CommonDAOLocator.getMoDao().getMoByUuid(host.getUuid(), Boolean.valueOf(true));
        if (null == mo) {
            logger.error((Object)("host does not exist in database, uuid:" + host.getUuid() + ", ip:" + host.getManagedIpAddress()), 90160777658373L);
            return;
        }
        String ip = host.getManagedIpAddress();
        String[] alramParams = new String[]{host.getName(), ip, host.getUuid(), host.getMainType()};
        AlarmReporter.sendAlarm((String)"0x000803220005", (String)host.getUuid(), (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alramParams);
    }

    public static void generateOfflineRestoreAlarm(Host host) {
        AlarmReporter.restoreAlarm((String)"0x000803220005", (String[])new String[]{host.getUuid()});
    }

    public static void startCluster(DrHostGroup hostGroup, ProtectObject protectobject) {
        String clusterType = (String)protectobject.getProps().get("CLUSTER_TYPE");
        String resourceGroup = (String)protectobject.getProps().get("RESOURCEGROUP_NAME");
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        LegoCheckedException legoEx = null;
        boolean isStartSuccess = false;
        for (DrResource childDrResource : hostGroup.getChildResources()) {
            try {
                NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend(neMgr, childDrResource.getDeviceSn());
                logger.info((Object)("start cluster into" + extend.getNetworkIpAddress() + ",CluserType is " + (String)protectobject.getProps().get("CLUSTER_TYPE")), 90160758786988L);
                ClusterAction action = new ClusterAction(extend, (String)extend.getExtendParams().get("mac_address"));
                action.startCluster(clusterType, resourceGroup);
                isStartSuccess = true;
                logger.info((Object)("start cluster success in " + childDrResource.getIpAddress()), 90160758786988L);
            }
            catch (LegoCheckedException le) {
                logger.error((Object)("start cluster error in " + childDrResource.getIpAddress()), (Throwable)le, 90160758786989L);
                legoEx = le;
            }
            catch (Exception e) {
                logger.error((Object)("start cluster error in " + childDrResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                legoEx = new LegoCheckedException(1073948170L, protectobject.getName());
            }
        }
        if (!isStartSuccess && null != legoEx) {
            throw legoEx;
        }
    }

    public static ClusterInfo queryClusterInfo(ProtectObject po, NeMgrProtocolExtend ne) {
        logger.info((Object)("start query Cluster Info in " + ne.getNetworkIpAddress()), 90160758786988L);
        String macAddress = (String)ne.getExtendParams().get("mac_address");
        ClusterAction action = new ClusterAction(ne, macAddress);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("INSTANCENAME", (String)po.getProps().get("INSTANCENAME"));
        params.put("DATABASES", (String)po.getProps().get("DATABASES"));
        params.put("CLUSTER_TYPE", (String)po.getProps().get("CLUSTER_TYPE"));
        params.put("DB_TYPE", String.valueOf(po.getPoType()));
        String authType = (String)po.getProps().get("AUTH_TYPE");
        if (authType != null && "1".equals(authType)) {
            params.put("USERNAME", "");
            params.put("PASSWD", "");
        } else {
            params.put("USERNAME", (String)po.getProps().get("USERNAME"));
            params.put("PASSWD", (String)po.getProps().get("PASSWD"));
        }
        List<ClusterInfo> resultMapList = action.queryClusterServices(params);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return null;
        }
        return resultMapList.get(0);
    }

    public static ClusterInfo queryClusterInfo(ProtectObject po, DrResource hostGroup) {
        LegoCheckedException legoEx = null;
        ClusterInfo clusterInfo = null;
        po.getProps().put("CLUSTER_TYPE", String.valueOf(((DrHostGroup)hostGroup).getClusterType()));
        for (DrResource host : hostGroup.getChildResources()) {
            DatabaseInstance dbInstance = DrHostUtil.getDbInstanceByHostSnAndDbName(host.getDeviceSn(), po.getName(), po.getPoType());
            if (null == dbInstance) {
                logger.error((Object)("dbInstance is empty, po name: " + po.getName()), 90160758784001L);
                continue;
            }
            ProtectObject tempPo = DrHostUtil.clone(po);
            tempPo.getProps().put("INSTANCENAME", dbInstance.getInstanceName());
            NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class), host.getDeviceSn());
            try {
                clusterInfo = DrHostUtil.queryClusterInfo(tempPo, ne);
                if (null == clusterInfo) continue;
                if (DrHostUtil.validateResourcesNamesforSQLServer(clusterInfo, tempPo)) {
                    logger.warn((Object)("queryClusterInfo result failed for MSFC in " + tempPo.getName() + host.getIpAddress()), 90160758786988L);
                    continue;
                }
                logger.info((Object)("queryClusterInfo result success in " + host.getIpAddress()), 90160758786988L);
                legoEx = null;
                break;
            }
            catch (LegoCheckedException le) {
                logger.error((Object)("queryClusterInfo result is empty in " + ne.getNetworkIpAddress()), (Throwable)le, 90160758786989L);
                legoEx = le;
            }
        }
        if (null != legoEx) {
            throw new LegoCheckedException(1073949142L);
        }
        return clusterInfo;
    }

    private static boolean validateResourcesNamesforSQLServer(ClusterInfo clusterInfo, ProtectObject tempPo) {
        if (tempPo.getPoType() != 2) {
            return false;
        }
        String resourceNames = clusterInfo.getResourceNames();
        logger.info((Object)("resourceNames for " + tempPo.getName() + " is " + resourceNames), 90160758786988L);
        return resourceNames.isEmpty() || resourceNames.equals("--") || resourceNames.equals("null");
    }

    public static DrHost buildDrHostByMo(Host hostMO, Integer port) {
        DrHost host = new DrHost();
        host.setDeviceSn(hostMO.getHostSN());
        host.setName(hostMO.getHostName());
        host.setIpAddress(hostMO.getIpAddress());
        host.setStatus(String.valueOf(hostMO.getHostStatus()));
        host.setPort(port);
        host.setDbId(UUIDGenerator.getUUID());
        host.setOsType(hostMO.getOs());
        host.setVersion(hostMO.getVersion());
        JSONObject instanceHostAlisaJsonObject = new JSONObject();
        for (ManagedObject o : hostMO.getChildMos()) {
            if (!(o instanceof SAPHANADatabaseInstance)) continue;
            String hostAlias = ((SAPHANADatabaseInstance)o).getHostAlias();
            instanceHostAlisaJsonObject.put((Object)((SAPHANADatabaseInstance)o).getInstanceName(), (Object)hostAlias);
        }
        host.setHostAlias(instanceHostAlisaJsonObject.toString());
        DrHostUtil.parseAndSetAgentVersionInfo(host, hostMO.getAgentVersion());
        return host;
    }

    public static void parseAndSetAgentVersionInfo(DrHost drHost, String agentVersion) {
        if (null == agentVersion) {
            drHost.setAgentVersion(null);
            drHost.setAgentBuildNum(null);
        } else {
            String[] versions = agentVersion.split(Pattern.quote("|"));
            drHost.setAgentVersion(versions[0]);
            if (versions.length > 1) {
                drHost.setAgentBuildNum(versions[1]);
            }
        }
    }

    public static Map<String, ResourceVO> getHostInitiators(Set<String> hostOrGroupIds) {
        if (VerifyUtil.isEmpty(hostOrGroupIds)) {
            return new HashMap<String, ResourceVO>();
        }
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        HashMap<String, ResourceVO> resourceVOs = new HashMap<String, ResourceVO>();
        for (String hostOrGroupId : hostOrGroupIds) {
            DrResource drResource = resourceService.getDrResourceBySn(hostOrGroupId);
            if (null == drResource) {
                logger.error((Object)("hostOrGroupId:" + hostOrGroupId), 90160758784000L);
                throw new LegoCheckedException(1073947394L);
            }
            ResourceVO resourceVO = DrHostUtil.constructResourceVO(drResource);
            resourceVOs.put(resourceVO.getId(), resourceVO);
        }
        return resourceVOs;
    }

    private static List<Initiator> getHostInitiators(DrHost drHost) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Host host = recoveryService.getHostByUuid(drHost.getDeviceSn());
        VerifyUtil.checkObject((Object)host);
        INeMgrProtocolExtendService neMgrService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend neMgrProtocolExtend = neMgrService.findByMoId(host.getMoId());
        VerifyUtil.checkObject((Object)neMgrProtocolExtend);
        List<Object> initiators = new ArrayList<Initiator>();
        try {
            logger.info((Object)("Begin to Querying initiators from host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
            initiators = ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).queryHostInitiators(neMgrProtocolExtend);
            StringBuffer buffer = new StringBuffer();
            int count = 0;
            for (Initiator initiator : initiators) {
                buffer.append(initiator.getIdentity() + "=" + initiator.getHbaType());
                if (count >= initiators.size()) continue;
                buffer.append(";");
            }
            logger.info((Object)("End querying intiators from host " + neMgrProtocolExtend.getNetworkIpAddress() + ",Result size:" + initiators.size() + ", Content:" + buffer.toString()), 90160758784000L);
        }
        catch (Exception e) {
            logger.error((Object)("Getting host initiator failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return initiators;
    }

    private static ResourceVO constructResourceVO(DrResource drResource) {
        HostVO resourceVO;
        if (drResource instanceof DrHost) {
            resourceVO = DrHostUtil.constructHostVO((DrHost)drResource);
        } else if (drResource instanceof DrHostGroup) {
            resourceVO = DrHostUtil.constructHostGroupVO((DrHostGroup)drResource);
        } else {
            logger.error((Object)("Invalid parameter. id:" + drResource.getDeviceSn()), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return resourceVO;
    }

    private static HostVO constructHostVO(DrHost drHost) {
        HostVO hostVO = new HostVO();
        hostVO.setId(drHost.getDeviceSn());
        hostVO.setName(drHost.getName());
        hostVO.setIpAddress(drHost.getIpAddress());
        hostVO.setExtProperty(drHost.getExtProperty());
        Integer osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        DrmAppEnumDefine.OS_TYPE_E eOsType = DrmAppEnumDefine.OS_TYPE_E.getType((int)osType);
        XveEnumDefinePParent.OS_TYPE_E arrayOsType = DrmAppEnumDefine.OS_TYPE_E.mapToArrayOsType((DrmAppEnumDefine.OS_TYPE_E)eOsType);
        hostVO.setOsType(XveEnumDefinePParent.OS_TYPE_E.Linux.getValue());
        if (null != arrayOsType) {
            hostVO.setOsType(arrayOsType.getValue());
        }
        List<Initiator> initiators = DrHostUtil.getHostInitiators(drHost);
        hostVO.setInitiators(initiators);
        return hostVO;
    }

    private static HostGroupVO constructHostGroupVO(DrHostGroup drHostGroup) {
        HostGroupVO hostGroupVO = new HostGroupVO();
        hostGroupVO.setId(drHostGroup.getDeviceSn());
        hostGroupVO.setName(drHostGroup.getName());
        hostGroupVO.setHostVOs(new ArrayList());
        Set childResources = drHostGroup.getChildResources();
        for (DrResource childResource : childResources) {
            HostVO hostVO = DrHostUtil.constructHostVO((DrHost)childResource);
            hostGroupVO.getHostVOs().add(hostVO);
        }
        return hostGroupVO;
    }

    public static List<String> execThirdScript(String hostSn, String scriptName, String isUserDefined, String scriptParams) {
        ArrayList<String> hostSNList = new ArrayList<String>();
        ArrayList<String> results = new ArrayList<String>();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
        if (drResource == null) {
            results.add("lego.err.1073947394");
            return results;
        }
        if (drResource instanceof DrHost) {
            logger.info((Object)("execThirdScript in drhost " + drResource.getName()), 90160758786988L);
            String devSn = drResource.getDeviceSn();
            hostSNList.add(devSn);
        } else if (drResource instanceof DrHostGroup) {
            logger.info((Object)("execThirdScript in DrHostGroup " + drResource.getName()), 90160758786988L);
            for (DrResource host : drResource.getChildResources()) {
                hostSNList.add(host.getDeviceSn());
            }
        }
        JSONObject scriptJsonParams = new JSONObject();
        if (!VerifyUtil.isEmpty((String)scriptParams)) {
            scriptJsonParams = JSONObject.fromObject((Object)scriptParams);
        }
        if (VerifyUtil.isEmpty((String)isUserDefined)) {
            scriptJsonParams.put((Object)"isUserDefined", (Object)"1");
        }
        for (String devSn : hostSNList) {
            Host host = (Host)CommonDAOLocator.getMoDao().getMo(Host.class, "hostSN", (Object)devSn);
            INeMgrProtocolExtendService neMgrService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend neMgrProtocolExtend = neMgrService.findByMoId(host.getMoId());
            logger.info((Object)("Begin to execThirdScript in host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
            List tmpResults = ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).executeThirdPartScript(neMgrProtocolExtend, scriptName, scriptJsonParams.toString());
            if (tmpResults.isEmpty()) {
                logger.info((Object)("ExecThirdScript success in host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
                return tmpResults;
            }
            logger.info((Object)("ExecThirdScript failed in host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
            results.addAll(tmpResults);
        }
        return results;
    }

    public static List<String> execThirdScript(String hostSn, String url, Map<String, String> scriptNames, Map<String, String> scriptParams) {
        ArrayList<String> hostSNList = new ArrayList<String>();
        ArrayList<String> results = new ArrayList<String>();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
        if (drResource == null) {
            results.add("lego.err.1073947394");
            return results;
        }
        if (drResource instanceof DrHost) {
            logger.info((Object)("execThirdScript in drhost " + drResource.getName()), 90160758786988L);
            String devSn = drResource.getDeviceSn();
            hostSNList.add(devSn);
        } else if (drResource instanceof DrHostGroup) {
            logger.info((Object)("execThirdScript in DrHostGroup " + drResource.getName()), 90160758786988L);
            for (DrResource host : drResource.getChildResources()) {
                hostSNList.add(host.getDeviceSn());
            }
        }
        for (String devSn : hostSNList) {
            Host host = (Host)CommonDAOLocator.getMoDao().getMo(Host.class, "hostSN", (Object)devSn);
            INeMgrProtocolExtendService neMgrService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend neMgrProtocolExtend = neMgrService.findByMoId(host.getMoId());
            logger.info((Object)("Begin to execThirdScript in host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
            List tmpResults = ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).executeThirdPartScript(neMgrProtocolExtend, url, scriptNames, scriptParams);
            if (tmpResults.isEmpty()) {
                logger.info((Object)("ExecThirdScript success in host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
                return tmpResults;
            }
            logger.info((Object)("ExecThirdScript failed in host " + neMgrProtocolExtend.getNetworkIpAddress()), 90160758784000L);
            results.addAll(tmpResults);
        }
        return results;
    }

    public static Set<DrResource> getDrHostsByHostOrGroupId(String hostOrGroupId) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(hostOrGroupId);
        HashSet<DrResource> hosts = new HashSet();
        if (drResource instanceof DrHostGroup) {
            hosts = drResource.getChildResources();
        } else if (drResource instanceof DrHost) {
            hosts.add(drResource);
        }
        return hosts;
    }

    public static void queryAndUpdateClusterInfo(ProtectObject po) {
        String providerSn = po.getProviderSN();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSn);
        if (!(drResource instanceof DrHostGroup)) {
            return;
        }
        DrHostGroup hostGroup = (DrHostGroup)drResource;
        int clusterType = hostGroup.getClusterType();
        if (clusterType == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) {
            return;
        }
        ClusterInfo clusterInfo = DrHostUtil.queryClusterInfo(po, drResource);
        if (null == clusterInfo || VerifyUtil.isEmpty((Collection)clusterInfo.getResourceGroups())) {
            logger.error((Object)("query cluster info is null, po name:" + po.getName() + "hostGroup name:" + drResource.getName()), 90160758784001L);
            return;
        }
        DrHostUtil.updatePoClusterInfo(po, hostGroup, clusterType, clusterInfo);
    }

    private static void updatePoClusterInfo(ProtectObject po, DrHostGroup hostGroup, int clusterType, ClusterInfo clusterInfo) {
        String clusterName = clusterInfo.getCluserName();
        Iterator rgIter = clusterInfo.getResourceGroups().iterator();
        if (!rgIter.hasNext()) {
            logger.error((Object)"clusterInfo.getResourceGroups().iterator() is null");
            throw new LegoCheckedException(1073947393L);
        }
        String resourceGroup = (String)rgIter.next();
        String resourceName = clusterInfo.getResourceNames();
        logger.info((Object)("query clusterinfo success, poName:" + po.getName() + ",clusterName:" + clusterName + ",networkname:" + clusterInfo.getNetworkName() + ", resourceGroupName:" + resourceGroup + ",resourceName:" + resourceName), 90160758784001L);
        Map props = po.getProps();
        props.put("IS_CLUSTER", String.valueOf(1));
        props.put("RESOURCEGROUP_NAME", resourceGroup);
        props.put("RESOURCE_NAME", resourceName);
        props.put("CLUSTER_TYPE", String.valueOf(clusterType));
        props.put("CLUSTER_VG_ACTIVE_MODE", clusterInfo.getVgActiveMode());
        props.put("NETWORK_NAME", clusterInfo.getNetworkName());
        props.put("DEVICE_GROUP", clusterInfo.getDeviceGroup());
        for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
            info.setResourceGroupName(resourceGroup);
            info.setResourceName(clusterName);
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (DrResource childDrRes : hostGroup.getChildResources()) {
            DatabaseInstance dbInstance = DrHostUtil.getDbInstanceByHostSnAndDbName(childDrRes.getDeviceSn(), po.getName(), po.getPoType());
            if (null == dbInstance) {
                logger.error((Object)("dbInstance is empty, po name: " + po.getName()), 90160758784001L);
                continue;
            }
            dbInstance.setCluster(Boolean.TRUE);
            dbInstance.setClusterName(clusterName);
            dbInstance.setResourceGroupName(resourceGroup);
            moDao.onlyUpdate((ManagedObject)dbInstance);
        }
    }

    private static DatabaseInstance getDbInstanceByHostSnAndDbName(String hostSn, String databaseName, int dbType) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", hostSn);
        props.put("name", databaseName);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List databases = moDao.findMoBy(Database.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)databases)) {
            logger.error((Object)("databases is empty, po name:" + databaseName + ", hostsn:" + hostSn), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        DatabaseInstance resultDbInstance = null;
        for (Database database : databases) {
            DatabaseInstance dbInstance = (DatabaseInstance)database.getParentMo();
            if (dbType != dbInstance.getDbType()) continue;
            resultDbInstance = dbInstance;
            break;
        }
        return resultDbInstance;
    }

    public static ProtectObject clone(ProtectObject po) {
        ProtectObject obj = new ProtectObject();
        obj.setUuid(po.getUuid());
        obj.setMoUuid(po.getMoUuid());
        obj.setName(po.getName());
        obj.getProps().putAll(po.getProps());
        obj.getUsedStorageResourceSet().addAll(po.getUsedStorageResourceSet());
        obj.setProviderSN(po.getProviderSN());
        obj.setPoType(po.getPoType());
        return obj;
    }

    public static void updateVolumeGroupInfo(Set<ProtectObjectStorageInfo> storageSet, NeMgrProtocolExtend extend) {
        if (VerifyUtil.isEmpty(storageSet)) {
            logger.debug((Object)"storageset is null,not update VolumeGroupInfo.");
            return;
        }
        HashMap<String, ArrayList<ProtectObjectStorageInfo>> vgNameMap = new HashMap<String, ArrayList<ProtectObjectStorageInfo>>();
        for (ProtectObjectStorageInfo storageInfo : storageSet) {
            if (VerifyUtil.isEmpty((String)storageInfo.getVolumeGroupName())) continue;
            ArrayList<ProtectObjectStorageInfo> storageInfos = (ArrayList<ProtectObjectStorageInfo>)vgNameMap.get(storageInfo.getVolumeGroupName());
            if (null == storageInfos) {
                storageInfos = new ArrayList<ProtectObjectStorageInfo>();
                vgNameMap.put(storageInfo.getVolumeGroupName(), storageInfos);
            }
            storageInfos.add(storageInfo);
        }
        if (VerifyUtil.isEmpty(vgNameMap)) {
            logger.info((Object)("vg Name map is empty, ip: " + extend.getNetworkIpAddress()), 90160758786988L);
            return;
        }
        DeviceAction deviceAction = new DeviceAction(extend, (String)extend.getExtendParams().get("mac_address"));
        for (Map.Entry entry : vgNameMap.entrySet()) {
            Integer volType;
            List storageInfos = (List)entry.getValue();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            String vgName = (String)entry.getKey();
            VolumeGroup vg = deviceAction.queryVGInfos(vgName, volType = ((ProtectObjectStorageInfo)storageInfos.get(0)).getStorageSubType());
            if (null == vg) {
                logger.warn((Object)("vg info is empty, ip: " + extend.getNetworkIpAddress() + ", vg Name: " + vgName), 90160758786988L);
                continue;
            }
            for (ProtectObjectStorageInfo storageInfo : storageInfos) {
                storageInfo.setVgMapInfo(vg.getMapInfo());
            }
        }
    }

    public static void setHostDisks(Host host, NeMgrProtocolExtend extend) {
        try {
            IHostRetrieveProxy hostRetrieveProxy = (IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class);
            extend.getExtendParams().put("mac_address", host.getUuid());
            List disks = hostRetrieveProxy.queryHostDiskInfo(extend);
            if (VerifyUtil.isEmpty((Collection)disks)) {
                logger.warn((Object)("Get host(" + extend.getNetworkIpAddress() + ") disks info is empty."), 90160758786989L);
                return;
            }
            for (Disk disk : disks) {
                disk.setParentMo((ManagedObject)host);
                host.addChildMo((ManagedObject)disk);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Get host(" + extend.getNetworkIpAddress() + ") disks info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public static List<String> getHostGroupListByDeviceSN(String hostGrpSn) {
        ArrayList<String> hostSNList = new ArrayList<String>();
        String hostServiceName = "DRM_Host/" + IHostGroupService.class.getName();
        IHostGroupService hostGroupService = (IHostGroupService)ServiceContext.getInstance().lookup(hostServiceName);
        if (VerifyUtil.isEmpty((Object)hostGroupService)) {
            logger.error((Object)"can't get hostGroupService: serviceName=%s", new Object[]{hostServiceName});
            throw new LegoCheckedException(102410L, hostServiceName);
        }
        List drGroups = hostGroupService.getHostGroupListByDeviceSN(hostGrpSn);
        for (DrHostGroup group : drGroups) {
            for (DrResource host : group.getChildResources()) {
                hostSNList.add(host.getDeviceSn());
            }
        }
        return hostSNList;
    }

    public static List<Integer> getPgTemplateType(RecoveryPlan recoveryPlan) {
        ArrayList<Integer> templateTypeList = new ArrayList<Integer>();
        if (null == recoveryPlan) {
            return templateTypeList;
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            return templateTypeList;
        }
        for (ProtectGroup group : protectGroups) {
            templateTypeList.add(group.getTemplate().getType());
        }
        return templateTypeList;
    }

    public static Lun getSrcLun(String siteId, String devSn, String lunId) {
        return ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getTargetLunById(devSn, lunId);
    }

    public static List<String> queryThirdScript(NeMgrProtocolExtend extend) {
        IHostRetrieveProxy hostRetrieveProxy = (IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class);
        List thirdPartScriptNames = hostRetrieveProxy.queryThirdPartScriptInfo(extend);
        return thirdPartScriptNames;
    }
}

