/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HostDataCollectUtil {
    private static Log logger = LogFactory.getInstance(HostDataCollectUtil.class);

    private HostDataCollectUtil() {
    }

    public static String getHostDataCollectLogFilePath() {
        String logPath = PathUtil.getRuntimePath() + File.separator + "logs" + File.separator + "hostcollect" + File.separator;
        File f = new File(logPath);
        if (!f.exists() && !f.mkdirs()) {
            logger.error((Object)"mkdirs failed.", 90160758786988L);
        }
        return logPath;
    }

    public static long getDirSize(List<File> files) {
        try {
            logger.debug((Object)("files count:" + files.size()), 90160758786988L);
            long dirSize = 0L;
            for (File file : files) {
                logger.debug((Object)("fileName:" + file.getName() + ",fileSize=" + file.length() + ",dir size=" + (dirSize += file.length())), 90160758786988L);
            }
            return dirSize;
        }
        catch (Exception e) {
            throw ExceptionUtil.convertException((Throwable)e, (String)"get dir size fail.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public static List<File> getFiles(String filePath) {
        if (VerifyUtil.isEmpty((String)filePath)) {
            logger.error((Object)"get file fail,filePath is null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            File dir = new File(filePath);
            if (!dir.isDirectory()) {
                logger.error((Object)"filePath is not directory.", 90160758786989L);
                throw new LegoCheckedException(1073947393L);
            }
            ArrayList<File> fileList = new ArrayList<File>();
            File[] files = dir.listFiles();
            if (null == files) {
                throw new LegoCheckedException(-1L);
            }
            for (File file : files) {
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                fileList.addAll(HostDataCollectUtil.getFiles(file.getCanonicalPath()));
            }
            return fileList;
        }
        catch (Exception e) {
            throw ExceptionUtil.convertException((Throwable)e, (String)"get dir size fail.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public static void getFileSort(List<File> files) {
        if (VerifyUtil.isEmpty(files)) {
            return;
        }
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file, File newFile) {
                if (file.lastModified() < newFile.lastModified()) {
                    return -1;
                }
                if (file.lastModified() == newFile.lastModified()) {
                    return 0;
                }
                return 1;
            }
        });
    }
}

