/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.util.DrHostValidUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;
import java.util.Map;

public class HostDiscParamValidator
implements IDisParamValidator {
    public DiscParamVilidateResult validate(DiscoveryPolicy policy) {
        DiscParamVilidateResult rOK = new DiscParamVilidateResult();
        rOK.setResult(true);
        DiscParamVilidateResult rError = new DiscParamVilidateResult();
        rError.setResult(false);
        rError.setErrorCode(1073947393L);
        if (null == policy || null == policy.getParamMap()) {
            return rError;
        }
        Map paramMap = policy.getParamMap();
        String uName = (String)paramMap.get("username");
        String uPWD = (String)paramMap.get("password");
        String port = (String)paramMap.get("port");
        if (!(DrHostValidUtil.checkUserName(uName) && DrHostValidUtil.checkPwd(uPWD) && DrHostValidUtil.checkPort(port))) {
            return rError;
        }
        String osUsername = (String)paramMap.get("osUsername");
        String osPwd = (String)paramMap.get("osPassword");
        if (!VerifyUtil.isEmpty((String)osUsername) && !DrHostValidUtil.checkUserName(osUsername)) {
            return rError;
        }
        if (!VerifyUtil.isEmpty((String)osPwd) && !DrHostValidUtil.checkPwd(osPwd)) {
            return rError;
        }
        if (!VerifyUtil.isEmpty((String)osUsername) && !DrHostValidUtil.isPwdMatchComplex(uPWD, uName)) {
            return rError;
        }
        if (!VerifyUtil.isEmpty((String)((String)paramMap.get("snmpVersion")))) {
            return DrHostValidUtil.checkSNMP(paramMap);
        }
        return rOK;
    }

    public String getValidatorKey() {
        return "ism.drm.deviceType.drhost.mainType";
    }
}

