/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.mediation.service.impl.NeMgrProtocolExtendServiceImpl;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.SnmpAuthInfo;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.ism.util.NetUtil;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostTrapUtil {
    private static final Log LOGGER = LogFactory.getInstance(HostTrapUtil.class);

    public static void registerTrap(Host host, NeMgrProtocolExtend extend, boolean forcedDelTrap, boolean checkSnmpPara) {
        try {
            String localIp = HostTrapUtil.getLocalIp(extend);
            if (!NetUtil.isValidIPV4((String)localIp)) {
                LOGGER.info((Object)"get localIp fail.", 90160758786989L);
                return;
            }
            int port = LegoProperties.getTrapListenPort();
            LOGGER.info((Object)("register ip: " + localIp + " port:" + port + ",hostIp:" + extend.getNetworkIpAddress()), 90160758786988L);
            HostTrapUtil.deleteTrapIp(extend, localIp, port, forcedDelTrap);
            if (checkSnmpPara) {
                HostTrapUtil.checkSnmpParam(extend);
            }
            ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).registerTrap(extend, Integer.valueOf(3), localIp, Integer.valueOf(port));
            AlarmReporter.restoreAlarm((long)60149202961L, (String[])new String[]{host.getUuid()});
            HostTrapUtil.savaTrapRegisterInfo(host, localIp, port);
        }
        catch (Exception e) {
            LOGGER.error((Object)("register trap ip fail,hostIp:" + extend.getNetworkIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            String localIp = HostTrapUtil.getLocalIp(extend);
            int port = LegoProperties.getTrapListenPort();
            String[] alramParams = new String[]{localIp, String.valueOf(port), host.getName(), host.getUuid()};
            AlarmReporter.sendAlarm((long)60149202961L, (String)host.getUuid(), (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alramParams);
            HostTrapUtil.savaTrapRegisterInfo(host, " ", 0);
        }
    }

    private static void deleteTrapIp(NeMgrProtocolExtend extend, String localIp, int port, boolean forcedDelTrap) {
        String trapIp = (String)extend.getExtendParams().get("host_trapip");
        String trapPort = (String)extend.getExtendParams().get("host_trapport");
        if (VerifyUtil.isEmpty((String)trapIp) || VerifyUtil.isEmpty((String)trapPort)) {
            return;
        }
        if (forcedDelTrap || !trapIp.equals(localIp) || !trapPort.equals(String.valueOf(port))) {
            ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).deleteTrap(extend, Integer.valueOf(3), trapIp, NumberUtil.parseInteger((Object)trapPort));
            LOGGER.info((Object)("delete trap sucess,trapPort:" + trapPort + ",trapip:" + trapIp + ",hostIp:" + extend.getNetworkIpAddress()), 90160758786876L);
        }
    }

    private static void checkSnmpParam(NeMgrProtocolExtend extend) {
        String authPwd = WccEncryptor.decrypt((String)((String)extend.getExtendParams().get("snmpAuthPwd")));
        String encryptPwd = WccEncryptor.decrypt((String)((String)extend.getExtendParams().get("snmpEncryptPwd")));
        int authType = HostTrapUtil.getAuthProtocol((String)extend.getExtendParams().get("snmpAuthProtocol"));
        int encryptType = HostTrapUtil.getEncryptProtocol((String)extend.getExtendParams().get("snmpEncryptProtocol"));
        String securityName = (String)extend.getExtendParams().get("snmpSecurityName");
        SnmpAuthInfo snmpAuthInfo = new SnmpAuthInfo(Integer.valueOf(authType), authPwd, Integer.valueOf(encryptType), encryptPwd, securityName);
        ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).checkSnmpParam(extend, snmpAuthInfo);
    }

    public static int getAuthProtocol(String authProtocol) {
        if (null != authProtocol && "HMACMD5".equalsIgnoreCase(authProtocol)) {
            return 2;
        }
        if (null != authProtocol && "HMAC_SHA1".equalsIgnoreCase(authProtocol)) {
            return 3;
        }
        if (null != authProtocol && "HMAC_SHA2".equalsIgnoreCase(authProtocol)) {
            return 5;
        }
        return 1;
    }

    public static int getEncryptProtocol(String encryptProtocol) {
        if (null != encryptProtocol && "AES".equalsIgnoreCase(encryptProtocol)) {
            return 4;
        }
        if (null != encryptProtocol && "DES".equalsIgnoreCase(encryptProtocol)) {
            return 2;
        }
        return 1;
    }

    private static void savaTrapRegisterInfo(Host host, String localIp, int port) {
        try {
            NeMgrProtocolExtendServiceImpl neService = new NeMgrProtocolExtendServiceImpl();
            NeMgrProtocolExtend neMgrExtend = neService.findByMoId(host.getMoId());
            neMgrExtend.getExtendParams().put("host_trapip", localIp);
            neMgrExtend.getExtendParams().put("host_trapport", String.valueOf(port));
            neService.update(neMgrExtend);
        }
        catch (Exception e) {
            LOGGER.error((Object)("sava register trap info fail,hostIp:" + host.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private static String getLocalIp(NeMgrProtocolExtend neMgrExtend) {
        String ipAddress = neMgrExtend.getNetworkIpAddress();
        String port = (String)neMgrExtend.getExtendParams().get("port");
        String localIp = new LegoMoGenerator().getIpForTrap();
        if (VerifyUtil.isEmpty((String)localIp)) {
            try {
                localIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                LOGGER.error((Object)("Get install ip fail, error is: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
        LOGGER.info((Object)("Getting local ip " + localIp + " vs linkIP:" + ipAddress + " remotePort:" + port), 90160758786988L);
        return localIp;
    }
}

