/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.base.sdk.model;

import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.unit.MathUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;

public class Disk
extends ManagedObject
implements HSObject {
    private static final int PRECISION = 2;
    private static final long serialVersionUID = -1165619994014247930L;
    private Double totalCapacity;
    private Double usedCapacity;
    private String diskBusID;
    private String diskModel;
    private String diskName;
    private String diskNum;
    private String diskSN;
    private String diskStatus;
    private String diskType;
    private String diskTypeForThirdStorage;
    private String manufacture;
    private String totalCapacityUnit;
    private String usedCapacityUnit;
    private String arraySN;

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (null == obj) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disk other = (Disk)obj;
        return this.checkProp(other);
    }

    public String getDiskBusID() {
        return this.diskBusID;
    }

    public String getDiskModel() {
        return this.diskModel;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public String getDiskNum() {
        return this.diskNum;
    }

    public String getDiskSN() {
        return this.diskSN;
    }

    public String getDiskStatus() {
        return this.diskStatus;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public Double getFreeCapacity() {
        return CapacityUnitUtil.getFreeCapacity(this.totalCapacity, this.usedCapacity);
    }

    public String getFreeCapacityAndUnit() {
        return CapacityUnitUtil.getFreeCapacityAndUnit(this.totalCapacity, this.usedCapacity, this.totalCapacityUnit);
    }

    public String getFreeCapacityUnit() {
        return this.totalCapacityUnit;
    }

    public String getManufacture() {
        return this.manufacture;
    }

    public Double getRatio() {
        return NumberUtil.getSpaceUsageRatio(this.usedCapacity, this.totalCapacity);
    }

    public String getRatioString() {
        return MathUtil.downScaleToString(this.getRatio(), 2);
    }

    public Double getTotalCapacity() {
        return this.totalCapacity;
    }

    public String getTotalCapacityAndUnit() {
        return CapacityUnitUtil.getCapacityAndUnit(this.totalCapacity, this.totalCapacityUnit);
    }

    public String getTotalCapacityUnit() {
        return this.totalCapacityUnit;
    }

    public Double getUsedCapacity() {
        return this.usedCapacity;
    }

    public String getUsedCapacityAndUnit() {
        return CapacityUnitUtil.getCapacityAndUnit(this.usedCapacity, this.usedCapacityUnit);
    }

    public String getUsedCapacityUnit() {
        return this.usedCapacityUnit;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.diskStatus == null ? 0 : this.diskStatus.hashCode());
        result = 31 * result + (this.totalCapacity == null ? 0 : this.totalCapacity.hashCode());
        result = 31 * result + (this.totalCapacityUnit == null ? 0 : this.totalCapacityUnit.hashCode());
        result = 31 * result + (this.usedCapacity == null ? 0 : this.usedCapacity.hashCode());
        result = 31 * result + (this.usedCapacityUnit == null ? 0 : this.usedCapacityUnit.hashCode());
        return result;
    }

    public void setDiskBusID(String diskBusID) {
        this.diskBusID = diskBusID;
    }

    public void setDiskModel(String diskModel) {
        this.diskModel = diskModel;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    public void setDiskNum(String diskNum) {
        this.diskNum = diskNum;
    }

    public void setDiskSN(String diskSN) {
        this.diskSN = diskSN;
    }

    public void setDiskStatus(String diskStatus) {
        this.diskStatus = diskStatus;
    }

    public void setDiskType(String diskType) {
        this.diskType = diskType;
    }

    public void setManufacture(String manufacture) {
        this.manufacture = manufacture;
    }

    public void setTotalCapacity(Double totalcapacity) {
        this.totalCapacity = totalcapacity;
    }

    public void setTotalCapacityUnit(String totalCapacityUnit) {
        this.totalCapacityUnit = totalCapacityUnit;
    }

    public void setUsedCapacity(Double usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    public void setUsedCapacityUnit(String usedCapacityUnit) {
        this.usedCapacityUnit = usedCapacityUnit;
    }

    private boolean checkCapacity(Disk other) {
        if (this.totalCapacity == null ? other.totalCapacity != null : !this.totalCapacity.equals(other.totalCapacity)) {
            return false;
        }
        return this.checkUsedCapacity(other);
    }

    private boolean checkProp(Disk other) {
        if (!this.checkCapacity(other)) {
            return false;
        }
        if (this.diskStatus == null ? other.diskStatus != null : !this.diskStatus.equals(other.diskStatus)) {
            return false;
        }
        return this.checkUnit(other);
    }

    private boolean checkUnit(Disk other) {
        if (this.totalCapacityUnit == null ? other.totalCapacityUnit != null : !this.totalCapacityUnit.equals(other.totalCapacityUnit)) {
            return false;
        }
        return this.checkUsedCapacityUnit(other);
    }

    private boolean checkUsedCapacity(Disk other) {
        return !(this.usedCapacity == null ? other.usedCapacity != null : !this.usedCapacity.equals(other.usedCapacity));
    }

    private boolean checkUsedCapacityUnit(Disk other) {
        return !(this.usedCapacityUnit == null ? other.usedCapacityUnit != null : !this.usedCapacityUnit.equals(other.usedCapacityUnit));
    }

    public String getDiskTypeForThirdStorage() {
        return this.diskTypeForThirdStorage;
    }

    public void setDiskTypeForThirdStorage(String diskTypeForThirdStorage) {
        this.diskTypeForThirdStorage = diskTypeForThirdStorage;
    }

    public String getArraySN() {
        return this.arraySN;
    }

    public void setArraySN(String arraySN) {
        this.arraySN = arraySN;
    }
}

