/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;

public class BufferedReaderDecorator {
    private static final Log logger = LogFactory.getInstance(BufferedReaderDecorator.class);
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final int TWENTY = 20;
    private BufferedReader reader;
    private long maxStreamSize;
    private StringBuilder builder = new StringBuilder();
    private int curReadSize = 0;
    private int curIndex = 0;
    private int totalSize = 0;
    private char[] cBuffer = new char[1024];

    public BufferedReaderDecorator(BufferedReader reader) {
        this.reader = reader;
        this.maxStreamSize = 0x1400000L;
    }

    public BufferedReaderDecorator(BufferedReader reader, long maxStreamSize) {
        this.reader = reader;
        this.maxStreamSize = maxStreamSize;
    }

    public String readLine() throws IOException {
        String line;
        if (this.curIndex < this.curReadSize - 1) {
            ++this.curIndex;
            line = this.retrieveLine();
            if (null != line) {
                return line;
            }
        }
        while ((this.curReadSize = this.reader.read(this.cBuffer, 0, 1024)) != -1) {
            this.curIndex = 0;
            line = this.retrieveLine();
            this.totalSize += this.curReadSize;
            if (this.maxStreamSize < (long)this.totalSize) {
                logger.error((Object)"The stream exceeds the limit of size.", 90160766255361L);
                throw new IOException("Exceeds the limit of stream size.");
            }
            if (null == line) continue;
            return line;
        }
        if (this.curReadSize < 1024 && 0 == this.builder.length()) {
            return null;
        }
        line = this.builder.toString();
        this.builder.delete(0, this.builder.length());
        return line;
    }

    private String retrieveLine() {
        String line = null;
        while (this.curIndex < this.curReadSize) {
            if (this.isEndOfLine(this.cBuffer, this.curReadSize, this.curIndex)) {
                line = this.builder.toString();
                this.builder.delete(0, this.builder.length());
                if (this.curIndex >= this.curReadSize - 1 || this.cBuffer[this.curIndex + 1] != '\n' && this.cBuffer[this.curIndex + 1] != '\r') break;
                ++this.curIndex;
                break;
            }
            if (this.curIndex < this.cBuffer.length) {
                this.builder.append(this.cBuffer[this.curIndex]);
            }
            ++this.curIndex;
        }
        return line;
    }

    private boolean isEndOfLine(char[] cArray, int retValue, int index) {
        if (index + 1 < cArray.length) {
            boolean isEndLine1 = cArray[index + 1] != '\n' && cArray[index + 1] != '\r';
            boolean isEndLine2 = cArray[index + 1] == '\n' || cArray[index + 1] == '\r';
            return !(cArray[index] != '\n' && cArray[index] != '\r' || index != retValue - 1 && !isEndLine1 && !isEndLine2);
        }
        return false;
    }
}

