/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util.unit;

import com.huawei.ism.cbb.util.unit.CapUnit;
import com.huawei.ism.cbb.util.unit.MathUtil;

public abstract class AbstractCapUnitType {
    protected static final long UNIT_KILO = 1024L;
    protected static final long UNIT_BYTE = 8L;
    protected static final int THREE_PRECISION = 3;
    private double value;

    public String getAdaptedValueWithUnit(double inputvalue) {
        AbstractCapUnitType adaptedCapUnitType = this.getAdaptedCapUnitType(inputvalue);
        double adaptedValue = adaptedCapUnitType.getValue();
        String returnValue = MathUtil.parseNumber((Object)adaptedValue, true, 3, 3);
        return returnValue + " " + adaptedCapUnitType.getUnitName();
    }

    public CapUnit getAdaptedCapUnit(double inputvalue) {
        AbstractCapUnitType adaptedCapUnitType = this.getAdaptedCapUnitType(inputvalue);
        double adaptedValue = adaptedCapUnitType.getValue();
        double returnValue = MathUtil.downScaleToDouble(adaptedValue, new int[0]);
        CapUnit capUnit = new CapUnit(returnValue, adaptedCapUnitType.getUnitName());
        return capUnit;
    }

    public abstract String getUnitName();

    protected abstract AbstractCapUnitType getBiggerCapUnitType();

    protected abstract long getBiggerConversion();

    protected abstract AbstractCapUnitType getSmallerCapUnitType();

    protected abstract long getSmallerConversion();

    protected double getValue() {
        return this.value;
    }

    private AbstractCapUnitType getAdaptedCapUnitType(double inputvalue) {
        AbstractCapUnitType biggerCapUnit = this.getBiggerCapUnitType();
        long biggerConversion = this.getBiggerConversion();
        if (Math.abs(inputvalue) >= (double)biggerConversion && null != biggerCapUnit) {
            return biggerCapUnit.getAdaptedCapUnitType(inputvalue / (double)biggerConversion);
        }
        AbstractCapUnitType smallerCapUnit = this.getSmallerCapUnitType();
        long smallerConversion = this.getSmallerConversion();
        if (Math.abs(inputvalue) < 1.0 && null != smallerCapUnit) {
            return smallerCapUnit.getAdaptedCapUnitType(inputvalue * (double)smallerConversion);
        }
        this.value = inputvalue;
        return this;
    }
}

