/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util.unit;

import com.huawei.ism.cbb.util.unit.CapUnit;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.MathUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;

public final class UnitConvert {
    private static final int THREE_SCALE = 3;
    private static final int THREE_PRECISION = 3;
    private static final String UNKNOWN_DISPLAY_STRING = "--";
    private static final int SIX_PRECISION = 6;

    private UnitConvert() {
    }

    public static double convert(Double value, IUnitType srcUnit, IUnitType targetUnit) {
        if (null == value) {
            return 0.0;
        }
        return UnitConvert.convert(value, srcUnit, targetUnit, 6);
    }

    public static double convert(double value, IUnitType srcUnit, IUnitType targetUnit, int scale) {
        long tmp;
        if (scale < 1) {
            throw new IllegalArgumentException("Parameter scale must be not less than 1.");
        }
        if (!srcUnit.getClass().isInstance(targetUnit)) {
            throw new IllegalArgumentException("unmatiching unit");
        }
        if (Double.valueOf(value).equals(Double.MIN_VALUE)) {
            return value;
        }
        double returnValue = value;
        if (srcUnit.getUnit() > targetUnit.getUnit()) {
            tmp = srcUnit.getUnit() / targetUnit.getUnit();
            returnValue = (double)tmp * value;
        }
        if (srcUnit.getUnit() < targetUnit.getUnit()) {
            tmp = targetUnit.getUnit() / srcUnit.getUnit();
            returnValue = value / (double)tmp;
        }
        return MathUtil.downScaleToDouble(returnValue, scale);
    }

    public static int convert(int value, IUnitType srcUnit, IUnitType targetUnit) {
        if (!srcUnit.getClass().isInstance(targetUnit)) {
            throw new IllegalArgumentException("unmatiching unit");
        }
        if (Integer.MIN_VALUE == value) {
            return value;
        }
        long returnValue = value;
        if (srcUnit.getUnit() > targetUnit.getUnit()) {
            returnValue = srcUnit.getUnit() / targetUnit.getUnit() * (long)value;
        }
        if (srcUnit.getUnit() < targetUnit.getUnit()) {
            returnValue = (long)value / (targetUnit.getUnit() / srcUnit.getUnit());
        }
        return (int)returnValue;
    }

    public static long convert(long value, IUnitType srcUnit, IUnitType targetUnit) {
        if (!srcUnit.getClass().isInstance(targetUnit)) {
            throw new IllegalArgumentException("unmatiching unit");
        }
        if (Long.MIN_VALUE == value) {
            return value;
        }
        long returnValue = value;
        if (srcUnit.getUnit() > targetUnit.getUnit()) {
            returnValue = srcUnit.getUnit() / targetUnit.getUnit() * value;
        }
        if (srcUnit.getUnit() < targetUnit.getUnit()) {
            returnValue = value / (targetUnit.getUnit() / srcUnit.getUnit());
        }
        return returnValue;
    }

    public static String autoConvertToAdaptedValueAndUnit(Double value, CapabilityUnitType srcUnit) {
        String valueAndUnitStr = UNKNOWN_DISPLAY_STRING;
        if (null == value) {
            return valueAndUnitStr;
        }
        if (value <= 0.0) {
            DecimalFormat nf = new DecimalFormat();
            ((NumberFormat)nf).setMaximumFractionDigits(3);
            ((NumberFormat)nf).setMinimumFractionDigits(3);
            return nf.format(value) + " " + srcUnit.name();
        }
        try {
            Class<?> capUnitTypeClass = Class.forName("com.huawei.ism.cbb.util.unit." + srcUnit.toString() + "CapUnitType");
            Method method = capUnitTypeClass.getMethod("getAdaptedValueWithUnit", Double.TYPE);
            valueAndUnitStr = (String)method.invoke(capUnitTypeClass.newInstance(), value);
        }
        catch (RuntimeException e) {
            throw new LegoCheckedException("Auto convert unit error.", (Throwable)e);
        }
        catch (Exception e) {
            throw new LegoCheckedException("Auto convert unit error.", (Throwable)e);
        }
        return valueAndUnitStr;
    }

    public static CapUnit autoConvertToAdaptedCapUnit(double value, CapabilityUnitType srcUnit) {
        CapUnit capUnit;
        if (value <= 0.0) {
            CapUnit capUnit2 = new CapUnit(value, srcUnit.name());
            return capUnit2;
        }
        try {
            Class<?> capUnitTypeClass = Class.forName("com.huawei.ism.cbb.util.unit." + srcUnit.toString() + "CapUnitType");
            Method method = capUnitTypeClass.getMethod("getAdaptedCapUnit", Double.TYPE);
            capUnit = (CapUnit)method.invoke(capUnitTypeClass.newInstance(), value);
        }
        catch (RuntimeException e) {
            throw new LegoCheckedException("Auto convert unit error.", (Throwable)e);
        }
        catch (Exception e) {
            throw new LegoCheckedException("Auto convert unit error.", (Throwable)e);
        }
        return capUnit;
    }

    public static String convertStr(double value, IUnitType srcUnit, IUnitType targetUnit) {
        return UnitConvert.convertStr(value, srcUnit, targetUnit, 3);
    }

    private static String convertStr(double value, IUnitType srcUnit, IUnitType targetUnit, int scale) {
        double db = UnitConvert.convert(value, srcUnit, targetUnit, scale);
        return MathUtil.parseNumber((Object)db, targetUnit.isGroupingUsed(), scale);
    }

    public static long convertToByte(double value, CapabilityUnitType srcUnit, CapabilityUnitType targetUnit) {
        long tmp;
        if (!srcUnit.getClass().isInstance(targetUnit)) {
            throw new IllegalArgumentException("unmatiching unit");
        }
        if (Double.valueOf(value).equals(Double.MIN_VALUE)) {
            return Long.MIN_VALUE;
        }
        double returnValue = 0.0;
        if (srcUnit.getUnit() > targetUnit.getUnit()) {
            tmp = srcUnit.getUnit() / targetUnit.getUnit();
            returnValue = (double)tmp * value;
        }
        if (srcUnit.getUnit() < targetUnit.getUnit()) {
            tmp = targetUnit.getUnit() / srcUnit.getUnit();
            returnValue = value / (double)tmp;
        }
        return (long)returnValue;
    }

    public static String getMinUnit(CapabilityUnitType srcUnit, List<Double> datas) {
        if (datas == null || datas.isEmpty()) {
            return CapabilityUnitType.MB.toString();
        }
        Collections.sort(datas);
        double minValue = 0.0;
        for (int i = 0; i < datas.size() && !((minValue = datas.get(i).doubleValue()) > 0.0); ++i) {
        }
        CapUnit minCap = UnitConvert.autoConvertToAdaptedCapUnit(minValue, srcUnit);
        return minCap.getUnit();
    }
}

