/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.template.sdk.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractExtendPolicyTemlate;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemlate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;

public abstract class AbstractPolicyTemplateFilter
extends AbstractExtendPolicyTemlate
implements IPolicyTemplateFilter {
    public static final String CONCURRENT_3DC = "CONCURRENT_3DC";
    public static final String SITE_A_3DC = "SITE_A_3DC";
    public static final String SITE_B_3DC = "SITE_B_3DC";
    public static final String SITE_C_3DC = "SITE_C_3DC";
    public static final String PO_LIST = "PO_LIST";
    public static final String PRODUCT_DEVSN = "PRODUCT_DEVSN";
    public static final String TARGET_DEVSN = "TARGET_DEVSN";
    public static final String POLICY_TEMPLATE_CONTEXT = "temp_policy_template_context";
    private static final Log logger = LogFactory.getInstance(AbstractPolicyTemplateFilter.class);
    private final ThreadLocal<Map<String, Object>> filterContext = new AbstractPolicyTemlate.ThreadLocalMapContainer();

    public Map<String, Object> getFilterContext() {
        return this.filterContext.get();
    }

    protected <T> T getFilterContextAttribute(String key, Class<T> targetClass) {
        Map<String, Object> context = this.getFilterContext();
        Object object = context.get(key);
        if (!targetClass.isInstance(object)) {
            logger.error((Object)"Illegal param type, object type: %s, target type: %s.", new Object[]{object.getClass().getCanonicalName(), targetClass.getCanonicalName()});
            throw new LegoCheckedException(1073947393L);
        }
        return targetClass.cast(object);
    }

    protected String getDevAndLun(String deviceId, String lunId) {
        return deviceId + ":" + lunId;
    }

    protected String checkSameSrcDevice(List<ProtectObject> protectObjectSet) {
        HashSet<String> providerSN = new HashSet<String>();
        String arraySn = "";
        for (ProtectObject po : protectObjectSet) {
            for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
                arraySn = info.getResourceProviderSN();
                providerSN.add(arraySn);
            }
        }
        if (providerSN.isEmpty()) {
            logger.error((Object)"System database not hava ProtectObject's storage resource message", 90160758786897L);
            throw new LegoCheckedException(1073947719L);
        }
        if (providerSN.size() != 1) {
            logger.error((Object)("The ProtectObject's device not the same" + StringUtil.arrayToString((Object[])providerSN.toArray())), 90160758786897L);
            throw new LegoCheckedException(1073948192L);
        }
        return arraySn;
    }

    protected void checkSameVStoreId(List<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            return;
        }
        HashSet vStoreIdSet = new HashSet();
        for (ProtectObject protectObject : protectObjectSet) {
            if (protectObject == null || VerifyUtil.isEmpty((Collection)protectObject.getUsedStorageResourceSet())) continue;
            vStoreIdSet.addAll(protectObject.getUsedStorageResourceSet().stream().map(this::getVstoreId).collect(Collectors.toSet()));
        }
        if (vStoreIdSet.size() != 1) {
            logger.error((Object)"The ProtectObject's vStoreId not in the same tenant.");
            throw new LegoCheckedException(1073937962L);
        }
    }

    private String getVstoreId(ProtectObjectStorageInfo storageInfo) {
        HibernateCallback action = session -> this.executeQueryVstoreId(storageInfo, session);
        String vstoreId = (String)CommonDAOLocator.getBaseDao().getHibernateTemplate().execute(action);
        if (VerifyUtil.isEmpty((String)vstoreId)) {
            logger.error((Object)"The ProtectObject's vStoreId not find.");
            throw new LegoCheckedException(1073947394L);
        }
        return vstoreId;
    }

    private String executeQueryVstoreId(ProtectObjectStorageInfo storageInfo, Session session) {
        return (String)session.createQuery("select ns.vstoreId from NasFileSystem as ns where ns.devSn=:devsn and ns.resourceId=:resourceId", String.class).setParameter("devsn", (Object)storageInfo.getResourceProviderSN()).setParameter("resourceId", (Object)storageInfo.getResourceId()).uniqueResult();
    }

    protected List<ProtectObjectStorageInfo> getAllStorageInfo(List<ProtectObject> protectObjects) {
        ArrayList<ProtectObjectStorageInfo> allInfo = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                if (allInfo.contains(posi)) continue;
                allInfo.add(posi);
            }
        }
        return allInfo;
    }

    protected String getSetStr(Set<String> set) {
        StringBuilder sbBuilder = new StringBuilder();
        if (VerifyUtil.isEmpty(set)) {
            return sbBuilder.toString();
        }
        for (String str : set) {
            sbBuilder.append(str).append(",");
        }
        sbBuilder.replace(sbBuilder.length() - 1, sbBuilder.length(), "");
        return sbBuilder.toString();
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        return null;
    }

    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        return false;
    }

    public List<ProtectLocationPath> getReplicationProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatchWithoutReplica(protectObjects);
        String productDevSn = (String)this.getFilterContext().get(PRODUCT_DEVSN);
        String targetDevSn = (String)this.getFilterContext().get(TARGET_DEVSN);
        String productSite = this.getSiteByArraySn(productDevSn);
        String targetSite = this.getSiteByArraySn(targetDevSn);
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_A.getValue(), productDevSn, productSite, productDevSn, productSite));
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), productDevSn, productSite, targetDevSn, targetSite));
        return path;
    }

    protected String getSiteByArraySn(String deviceSN) {
        Site site = this.getSiteByDeviceSN(deviceSN);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getSiteByArraySn error, site is null, deviceSN:" + deviceSN), 90160758787071L);
            return null;
        }
        return site.getSiteId();
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            logger.error((Object)("deviceSN is empty!deviceSN:" + deviceSN));
            return null;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }

    protected ProtectLocationPath constructSitePath(int location, String productDevSn, String productSite, String targetDevSn, String targetSite) {
        logger.debug((Object)("constructSitePath.location:" + location + ",productDevSn:" + productDevSn + ",productSite:" + productSite + ",targetDevSn:" + targetDevSn));
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        ProtectLocationPath protectLocation = new ProtectLocationPath();
        protectLocation.setProtectLocation(location);
        protectLocation.setProtectedStorageSN(productDevSn);
        protectLocation.setRecoveryStorageSN(targetDevSn);
        protectLocation.setProtectedSiteId(productSite);
        protectLocation.setRecoverySiteId(targetSite);
        protectLocation.setProtectedSiteName(siteService.getSiteById(productSite).getName());
        protectLocation.setRecoverySiteName(siteService.getSiteById(targetSite).getName());
        return protectLocation;
    }

    protected boolean isMatchExtend() {
        return true;
    }

    protected boolean isSetPathExtend() {
        return false;
    }
}

