/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailSnapshotApiManager;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OceanProtectSnapshotManager
implements IAntiBlackmailSnapshotManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectSnapshotManager.class);
    private static final String ACTION_TYPE = "snapshot";
    private IAntiBlackmailSnapshotApiManager snapshotApiManager;

    public void setSnapshotApiManager(IAntiBlackmailSnapshotApiManager snapshotApiManager) {
        this.snapshotApiManager = snapshotApiManager;
    }

    public Optional<String> createSnapshot(String devSn, String copyName, String slaId, String pmFileSystemId) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (VerifyUtil.isEmpty((String)copyName) || VerifyUtil.isEmpty((String)slaId) || VerifyUtil.isEmpty((String)pmFileSystemId)) {
            LOGGER.error((Object)"Create snapshot parameter error: devSn, copyName, slaId, pmFileSystemId, which cannot be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        params.put("copy_name", copyName);
        params.put("action", ACTION_TYPE);
        params.put("sla_id", slaId);
        params.put("pmFileSystemId", pmFileSystemId);
        return this.snapshotApiManager.createSnapshot(devSn, params);
    }

    public List<AntiBlackmailSnapshot> queryResourceAllSnapshots(String devSn, String resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource_id", resourceId);
        return this.snapshotApiManager.queryResourceSnapshots(devSn, params);
    }

    public List<AntiBlackmailSnapshot> queryResourceSnapshotsByPage(String devSn, String resourceId, int pageNo, int pageSize) {
        if (pageNo < 0 || pageSize <= 0 || pageSize > 100) {
            LOGGER.error((Object)"Illegal page query param, pageNo: %s, pageSize: %s", new Object[]{pageNo, pageSize});
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page_no", String.valueOf(pageNo));
        params.put("page_size", String.valueOf(pageSize));
        params.put("resource_id", resourceId);
        return this.snapshotApiManager.queryResourceSnapshots(devSn, params);
    }

    public Optional<AntiBlackmailSnapshot> querySpecificSnapshot(String devSn, String resourceId, String snapshotUuid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page_no", String.valueOf(0));
        params.put("page_size", String.valueOf(10));
        params.put("resource_id", resourceId);
        List<AntiBlackmailSnapshot> snapshotList = this.snapshotApiManager.queryResourceSnapshots(devSn, params);
        Optional<AntiBlackmailSnapshot> snapshotOptional = snapshotList.stream().filter(snapshot -> snapshot.getUuid().equals(snapshotUuid)).findAny();
        if (snapshotOptional.isPresent()) {
            return snapshotOptional;
        }
        if (snapshotList.size() < 10) {
            LOGGER.error((Object)"The snapshot information isn't found, devSn: %s, resourceId: %s, snapshotUuid: %s.", new Object[]{devSn, resourceId, snapshotUuid});
            return snapshotOptional;
        }
        LOGGER.info((Object)"The first query attempt failed, snapshotUuid: %s. Start full query", new Object[]{snapshotUuid});
        snapshotList = this.queryResourceAllSnapshots(devSn, resourceId);
        snapshotOptional = snapshotList.stream().filter(snapshot -> snapshot.getUuid().equals(snapshotUuid)).findAny();
        if (!snapshotOptional.isPresent()) {
            LOGGER.error((Object)"The snapshot information isn't found, devSn: %s, resourceId: %s, snapshotUuid: %s.", new Object[]{devSn, resourceId, snapshotUuid});
        }
        return snapshotOptional;
    }

    public List<AntiBlackmailSnapshot> queryAllSnapshotByProtectGroup(String devSn, ProtectGroup protectGroup) {
        List<String> resourceIds = Optional.ofNullable(protectGroup).map(ProtectGroup::getPolist).filter(poList -> !VerifyUtil.isEmpty((Collection)poList)).orElseGet(Collections::emptySet).stream().map(protectObject -> protectObject.getProperty("antiBlackmailResourceUuid")).filter(resourceUuid -> !VerifyUtil.isEmpty((String)resourceUuid)).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(resourceIds)) {
            LOGGER.error((Object)"Illegal param because there is no resource found, protect group name: %s.", new Object[]{Optional.ofNullable(protectGroup).map(DRMObject::getName).orElse("")});
        }
        ArrayList<AntiBlackmailSnapshot> snapshotList = new ArrayList<AntiBlackmailSnapshot>();
        resourceIds.forEach(resourceId -> {
            List<AntiBlackmailSnapshot> snapshots = this.queryResourceAllSnapshots(devSn, (String)resourceId);
            snapshotList.addAll(snapshots.stream().filter(snapshot -> snapshot.getName().contains("BCM")).collect(Collectors.toList()));
        });
        return snapshotList;
    }

    public OperationResult deleteSpecificSnapshot(String devSn, String snapshotUuid) {
        return this.snapshotApiManager.deleteSpecificSnapshot(devSn, snapshotUuid);
    }

    public OperationResult misreportDeal(String devSn, String snapshotUuid) {
        return this.snapshotApiManager.misreportDeal(devSn, snapshotUuid);
    }

    public String getPlatformType() {
        return AntiBlackMailEnumDefine.PlatformType.OCEAN_PROTECT.getValue();
    }
}

