/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api.BaseOceanProtectApiManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailResource;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailResourceApiManager;
import com.huawei.ism.drm.anti.blackmail.util.OceanProtectRestTransition;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;

public class OceanProtectResourceApiManager
extends BaseOceanProtectApiManager
implements IAntiBlackmailResourceApiManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectResourceApiManager.class);
    private static final String RESOURCE_URI = "/v2/resources";
    private static final String SCAN_RESOURCE_URI = "/v2/resources/${deviceSn}/action/scan";

    public OperationResult scanResources(String devSn) {
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            String uri = SCAN_RESOURCE_URI.replace("${deviceSn}", devSn);
            connection.putForObject(uri, null);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to trigger ProtectManager(devSn: %s) resource scanning.", new Object[]{devSn});
            return new OperationResult("anti.blackmail.scan.resource.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to trigger ProtectManager(devSn: %s) resource scanning.", new Object[]{devSn});
            return new OperationResult("anti.blackmail.scan.resource.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return new OperationResult("anti.blackmail.scan.resource.operation", true, true, new String[0]);
    }

    public List<AntiBlackmailResource> queryResources(String devSn, Map<String, String> queryParams) {
        List<Map<String, String>> resultList = this.queryAllByPage(RESOURCE_URI, devSn, queryParams);
        return OceanProtectRestTransition.transitionAntiBlackmailResource(resultList);
    }

    @Override
    protected String getStartPageKey() {
        return "pageNo";
    }
}

