/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.message;

import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;

public class AntiBlackMailSubscriber
extends MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackMailSubscriber.class);

    public AntiBlackMailSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public void onMessage(MessageUnit messageUnit) {
        long msgType = messageUnit.getCmdcode();
        if (msgType != 8001L) {
            LOGGER.error((Object)String.format("Message was not subscribed, msgType: %s", msgType));
            return;
        }
        Object messageBody = messageUnit.getObj();
        if (!(messageBody instanceof Map)) {
            LOGGER.error((Object)"The type of message body isn't Map");
            return;
        }
        Map map = (Map)messageBody;
        this.scanResource(map);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.COMMAND);
        mrs[0].addMessageCode(8001L);
        return mrs;
    }

    private void scanResource(Map<String, String> params) {
        String devSn = params.get("devSn");
        String connectionType = params.get("connectionType");
        LOGGER.info((Object)"Start to scan resource, dev sn: %s, connection type: %s.", new Object[]{devSn, connectionType});
        AntiBlackmailUtil.scanResource((String)devSn, (String)connectionType, (boolean)true, null);
    }
}

