/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailResource;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSLA;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailVstore;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.oceanprotect.OceanProtectPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.oceanprotect.OceanProtectResource;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;

public class OceanProtectRestTransition {
    public static List<AntiBlackmailResource> transitionAntiBlackmailResource(List<Map<String, String>> resultList) {
        ArrayList<AntiBlackmailResource> resourceList = new ArrayList<AntiBlackmailResource>();
        if (VerifyUtil.isEmpty(resultList)) {
            return resourceList;
        }
        for (Map<String, String> perResultMap : resultList) {
            OceanProtectResource oceanProtectResource = new OceanProtectResource();
            oceanProtectResource.setUuid(perResultMap.get("uuid"));
            oceanProtectResource.setName(perResultMap.get("name"));
            OceanProtectRestTransition.transitionResourceExtendInfo(perResultMap.get("extendInfo"), oceanProtectResource);
            OceanProtectRestTransition.transitionResourceProtectedObjectInfo(perResultMap.get("protectedObject"), oceanProtectResource);
            resourceList.add((AntiBlackmailResource)oceanProtectResource);
        }
        return resourceList;
    }

    private static void transitionResourceExtendInfo(String extendInfo, OceanProtectResource oceanProtectResource) {
        if (VerifyUtil.isEmpty((String)extendInfo)) {
            return;
        }
        JSONObject extendInfoJsonObj = JSONObject.fromObject((Object)extendInfo);
        if (extendInfoJsonObj.containsKey((Object)"tenantName")) {
            oceanProtectResource.setVstoreName(extendInfoJsonObj.getString("tenantName"));
        }
        if (extendInfoJsonObj.containsKey((Object)"tenantId")) {
            oceanProtectResource.setVstoreId(extendInfoJsonObj.getString("tenantId"));
        }
        if (extendInfoJsonObj.containsKey((Object)"fileSystemId")) {
            oceanProtectResource.setResourceId(extendInfoJsonObj.getString("fileSystemId"));
        }
    }

    private static void transitionResourceProtectedObjectInfo(String protectedObjectInfo, OceanProtectResource oceanProtectResource) {
        if (VerifyUtil.isEmpty((String)protectedObjectInfo)) {
            return;
        }
        JSONObject protectedObjectJsonObj = JSONObject.fromObject((Object)protectedObjectInfo);
        if (protectedObjectJsonObj.containsKey((Object)"slaId")) {
            oceanProtectResource.setSlaId(protectedObjectJsonObj.getString("slaId"));
        }
        if (protectedObjectJsonObj.containsKey((Object)"slaName")) {
            oceanProtectResource.setSlaName(protectedObjectJsonObj.getString("slaName"));
        }
        if (protectedObjectJsonObj.containsKey((Object)"status")) {
            oceanProtectResource.setEnabledSla(protectedObjectJsonObj.getInt("status") == 1);
        }
    }

    public static List<AntiBlackmailPlatformTask> transitionAntiBlackmailPlatformTask(List<Map<String, String>> resultList) {
        ArrayList<AntiBlackmailPlatformTask> taskList = new ArrayList<AntiBlackmailPlatformTask>();
        if (VerifyUtil.isEmpty(resultList)) {
            return taskList;
        }
        for (Map<String, String> perResultMap : resultList) {
            OceanProtectPlatformTask task = new OceanProtectPlatformTask();
            task.setJobId(perResultMap.get("jobId"));
            task.setProgress(NumberUtil.parseInteger((Object)perResultMap.get("progress")).intValue());
            task.setStatus(perResultMap.get("status"));
            task.setStartTime(NumberUtil.parseLong((Object)perResultMap.get("startTime")).longValue());
            task.setAssociativeId(perResultMap.get("associativeId"));
            task.setType(perResultMap.get("type"));
            task.setSourceId(perResultMap.get("sourceId"));
            task.setCopyId(perResultMap.get("copyId"));
            taskList.add((AntiBlackmailPlatformTask)task);
        }
        return taskList;
    }

    public static List<AntiBlackmailSLA> transitionAntiBlackmailSLA(List<Map<String, String>> resultList) {
        ArrayList<AntiBlackmailSLA> slaList = new ArrayList<AntiBlackmailSLA>();
        if (VerifyUtil.isEmpty(resultList)) {
            return slaList;
        }
        for (Map<String, String> perResultMap : resultList) {
            AntiBlackmailSLA sla = new AntiBlackmailSLA();
            sla.setName(perResultMap.get("name"));
            sla.setUuid(perResultMap.get("uuid"));
            if (perResultMap.containsKey("policy_list")) {
                OptionalInt retentionType = OceanProtectRestTransition.extractRetentionType(perResultMap.get("policy_list"));
                retentionType.ifPresent(arg_0 -> ((AntiBlackmailSLA)sla).setRetentionType(arg_0));
            }
            slaList.add(sla);
        }
        return slaList;
    }

    private static OptionalInt extractRetentionType(String policyListStr) {
        if (VerifyUtil.isEmpty((String)policyListStr)) {
            return OptionalInt.empty();
        }
        JSONArray policyList = JSONArray.fromObject((Object)policyListStr);
        if (policyList.isEmpty()) {
            return OptionalInt.empty();
        }
        JSONObject policy = policyList.getJSONObject(0);
        if (!policy.containsKey((Object)"retention")) {
            return OptionalInt.empty();
        }
        JSONObject retention = policy.getJSONObject("retention");
        return retention.containsKey((Object)"retention_type") ? OptionalInt.of(retention.getInt("retention_type")) : OptionalInt.empty();
    }

    public static List<AntiBlackmailSnapshot> transitionAntiBlackmailSnapshot(List<Map<String, String>> resultList) {
        ArrayList<AntiBlackmailSnapshot> snapshotList = new ArrayList<AntiBlackmailSnapshot>();
        if (VerifyUtil.isEmpty(resultList)) {
            return snapshotList;
        }
        for (Map<String, String> perResultMap : resultList) {
            JSONObject jsonObject;
            AntiBlackmailSnapshot snapshot = new AntiBlackmailSnapshot();
            snapshot.setUuid(perResultMap.get("uuid"));
            snapshot.setName(perResultMap.get("name"));
            snapshot.setAntiStatus(NumberUtil.parseInteger((Object)perResultMap.get("anti_status")).intValue());
            snapshot.setResourceName(perResultMap.get("resource_name"));
            if (perResultMap.containsKey("properties") && (jsonObject = JSONObject.fromObject((Object)perResultMap.get("properties"))).containsKey((Object)"filesystemId")) {
                String filesystemId = jsonObject.getString("filesystemId");
                snapshot.setStorageResourceId(filesystemId);
                snapshot.setStorageSnapshotId(filesystemId + "@" + perResultMap.get("uuid"));
            }
            snapshotList.add(snapshot);
        }
        return snapshotList;
    }

    public static List<AntiBlackmailVstore> transitionAntiBlackmailVstore(List<Map<String, String>> resultList) {
        ArrayList<AntiBlackmailVstore> vstoreList = new ArrayList<AntiBlackmailVstore>();
        if (VerifyUtil.isEmpty(resultList)) {
            return vstoreList;
        }
        for (Map<String, String> perResultMap : resultList) {
            AntiBlackmailVstore vstore = new AntiBlackmailVstore();
            vstore.setVstoreId(perResultMap.get("vstoreId"));
            vstore.setVstoreName(perResultMap.get("vstoreName"));
            vstore.setEnabledSmartDetection("ENABLED".equals(perResultMap.get("copyDetectConfigStatus")));
            vstoreList.add(vstore);
        }
        return vstoreList;
    }
}

