/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSlaManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSLA;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSlaManager;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.action.service.IProtectExecutionPreprocessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class NasAirGapAntiBlackmailProtectionPreProcessor
implements IProtectExecutionPreprocessor {
    private static final Log LOGGER = LogFactory.getInstance(NasAirGapAntiBlackmailProtectionPreProcessor.class);

    public Map<String, Object> process(ActionContext context) {
        String nasAirGapSla;
        HashMap<String, Object> processResult = new HashMap<String, Object>();
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class);
        if (protectGroup.getTemplate().getType() != 46) {
            return processResult;
        }
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY", ProtectGroupReplica.class);
        String devSn = protectGroupReplica.getRecoveryArray();
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        Optional slaOptional = slaManager.querySlaByName(devSn, nasAirGapSla = "BCManagerNASAirGapSLA");
        if (!slaOptional.isPresent()) {
            LOGGER.error((Object)"There is no sla named %s on the ProtectManager side.", new Object[]{nasAirGapSla});
            throw new LegoCheckedException(1073948504L, new String[]{devSn, nasAirGapSla});
        }
        AntiBlackmailSLA sla = (AntiBlackmailSLA)slaOptional.get();
        if (sla.getRetentionType() != 1) {
            LOGGER.error((Object)"The replica retention type of the SLA named %s on the ProtectManager side isn't permanent.", new Object[]{sla.getName()});
            throw new LegoCheckedException(1073948497L, new String[]{devSn, sla.getName()});
        }
        String slaId = ((AntiBlackmailSLA)slaOptional.get()).getUuid();
        List resourceList = AntiBlackmailUtil.checkProtectObjectsValidity((ProtectGroup)protectGroup, (String)slaId, (boolean)false);
        processResult.put("antiBlackmailSLA", slaId);
        processResult.put("antiBlackmailResources", resourceList);
        return processResult;
    }

    public String getName() {
        return NasAirGapAntiBlackmailProtectionPreProcessor.class.getName();
    }
}

