/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.calculator;

import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.calculator.RPOCalculateBean;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayReplicationRecoveryPointObjectiveCalculator
extends BaseRecoveryPointObjectiveCalculator {
    public static final String IS_STANDBY = "isStandBy";
    private static final long SECOND = 1000L;
    private static final List<Integer> SPECIALLIST = Arrays.asList(0, 18, 20);
    private static final List<Integer> SYN_3DC_TEMPLATE_TYPE_LIST = Arrays.asList(23, 24);
    private static final Log logger = LogFactory.getInstance(ArrayReplicationRecoveryPointObjectiveCalculator.class);
    private final List<String> typeList = Arrays.asList("0", "1", "4", "3", "6", "35", "36", "33", "58", "59", "40", "41", "42", "43");
    private final String comma = ",";

    public List<String> getTypes() {
        return this.typeList;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        logger.debug((Object)"enter calcActualRPO");
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        LinkedHashMap<String, Object> actualRPO = new LinkedHashMap<String, Object>();
        if ((VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules()) || ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getScheduleMode() == 1) && protectGroup.getTemplate().getType() == 33) {
            String key = String.valueOf(((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getProtectLocation()) + ',' + protectGroup.getProductSiteId() + ',' + ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSiteId();
            actualRPO.put(key, -1);
            return actualRPO;
        }
        List rpoBeanList = (List)context.getObject("RPO_BEANS");
        for (RPOCalculateBean bean : rpoBeanList) {
            this.dealActualRPO(bean, actualRPO, protectGroup, context);
        }
        return actualRPO;
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        Object object = context.getObject("PG_ENTITY");
        if (object == null) {
            logger.error((Object)"protectGroup is empty.", 90160758784001L);
            return null;
        }
        ProtectGroup protectGroup = (ProtectGroup)object;
        LinkedHashMap<String, Object> cfgRPO = new LinkedHashMap<String, Object>();
        String productSiteId = protectGroup.getProductSiteId();
        PolicyTemplate template = protectGroup.getTemplate();
        Set schedules = template.getSchedules();
        if (schedules == null || schedules.isEmpty()) {
            cfgRPO.put(productSiteId, -2);
            return cfgRPO;
        }
        for (Schedule schedule : schedules) {
            int scheduleMode = schedule.getScheduleMode();
            if (1 == scheduleMode) {
                this.putCfgRPO(cfgRPO, schedule.getProtectLocation(), schedule.getSourceSiteId(), schedule.getTargetSiteId(), -1);
                continue;
            }
            if (VerifyUtil.isEmpty((Object)schedule.isEnableRpoCheck())) {
                this.putCfgRPO(cfgRPO, schedule.getProtectLocation(), schedule.getSourceSiteId(), schedule.getTargetSiteId(), -1);
                continue;
            }
            if (!schedule.isEnableRpoCheck().booleanValue()) {
                this.putCfgRPO(cfgRPO, schedule.getProtectLocation(), schedule.getSourceSiteId(), schedule.getTargetSiteId(), -3);
                continue;
            }
            if (!ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)schedule, new Date())) {
                this.putCfgRPO(cfgRPO, schedule.getProtectLocation(), schedule.getSourceSiteId(), schedule.getTargetSiteId(), -1);
                continue;
            }
            this.putCfgRPO(cfgRPO, schedule.getProtectLocation(), schedule.getSourceSiteId(), schedule.getTargetSiteId(), this.getConfigRPO(schedule.getExpectedRPO()));
        }
        this.loadProtectGroupReplica(protectGroup);
        RPOCalculateBean rpoBean = new RPOCalculateBean();
        rpoBean.setPgId(protectGroup.getUuid());
        rpoBean.setPgName(protectGroup.getName());
        ArrayList<RPOCalculateBean> rpoBeanList = new ArrayList<RPOCalculateBean>();
        rpoBeanList.add(rpoBean);
        context.addObject("RPO_BEANS", rpoBeanList);
        this.getRpoBean(protectGroup, context);
        return cfgRPO;
    }

    private void putCfgRPO(Map<String, Object> cfgRPO, int protectLocation, String sourceSiteId, String targetSiteId, Object obj) {
        if (sourceSiteId.contains(":")) {
            String[] sourceSiteIds;
            for (String srcSiteId : sourceSiteIds = sourceSiteId.split(":")) {
                cfgRPO.put(protectLocation + "," + srcSiteId + "," + targetSiteId, obj);
            }
        } else if (targetSiteId.contains(":")) {
            String[] targetSiteIds;
            for (String tgtSiteId : targetSiteIds = targetSiteId.split(":")) {
                cfgRPO.put(protectLocation + "," + sourceSiteId + "," + tgtSiteId, obj);
            }
        } else {
            cfgRPO.put(protectLocation + "," + sourceSiteId + "," + targetSiteId, obj);
        }
    }

    public Boolean isNeedRpoEarlyAlarm(RPOContext context) {
        logger.debug((Object)"enter isNeedRpoEarlyAlarm");
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        List rpoBeanList = (List)context.getObject("RPO_BEANS");
        for (RPOCalculateBean bean : rpoBeanList) {
            String replicaId = bean.getReplicaId();
            if (!this.checkRpoEarlyAlarm(protectGroup, replicaId).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected String getSiteId(String str) {
        String[] array = str.split(",");
        if (array.length != 3) {
            logger.error((Object)"getSiteId error!", 90160758787071L);
            return "";
        }
        return array[2];
    }

    protected Object getProductSiteId(String key) {
        String[] array = key.split(",");
        if (array.length != 3) {
            logger.error((Object)"getSiteId error!", 90160758787071L);
            return "";
        }
        return array[1];
    }

    private void dealActualRPO(RPOCalculateBean rpoCalBean, Map<String, Object> cfgRPO, ProtectGroup protectGroup, RPOContext context) {
        Boolean isRdManual = rpoCalBean.getIsRdManual();
        Boolean isDeviceManual = rpoCalBean.getIsDeviceManual();
        long deviceInterval = rpoCalBean.getDeviceInterval();
        String recoverySiteId = rpoCalBean.getRecoverySiteId();
        Boolean isSyncArray = rpoCalBean.getIsSyncArray();
        Boolean dataStatus = rpoCalBean.getDataStatus();
        Boolean pairStatus = rpoCalBean.getPairStatus();
        Boolean isOkRdConnDevice = rpoCalBean.getIsOkRdConnDevice();
        String replicaId = rpoCalBean.getReplicaId();
        Boolean replicaActive = rpoCalBean.isReplicaActive();
        if (!isOkRdConnDevice.booleanValue()) {
            cfgRPO.put(recoverySiteId, -2);
            return;
        }
        if (isSyncArray.booleanValue()) {
            this.calculateSyncReplicationRPO(cfgRPO, recoverySiteId, dataStatus, pairStatus, replicaActive);
            return;
        }
        if (isRdManual == null) {
            logger.error((Object)"IsRdManual value is null!");
            cfgRPO.put(recoverySiteId, -2);
            return;
        }
        if (!isRdManual.booleanValue()) {
            this.calculateRdAutoRPO(cfgRPO, protectGroup, recoverySiteId, replicaId, replicaActive);
            if (!VerifyUtil.isEmpty((Object)context.getObject(IS_STANDBY)) && !protectGroup.hasMultiCg()) {
                cfgRPO.put(recoverySiteId, -1);
            }
            return;
        }
        if (isDeviceManual != null && !isDeviceManual.booleanValue()) {
            if (pairStatus.booleanValue() && dataStatus.booleanValue()) {
                cfgRPO.put(recoverySiteId, deviceInterval);
                if (!VerifyUtil.isEmpty((Object)context.getObject(IS_STANDBY)) && !protectGroup.hasMultiCg()) {
                    cfgRPO.put(recoverySiteId, -1);
                }
            } else {
                cfgRPO.put(recoverySiteId, -3);
            }
            return;
        }
        cfgRPO.put(recoverySiteId, -1);
    }

    private void calculateSyncReplicationRPO(Map<String, Object> cfgRPO, String recoverySiteId, Boolean dataStatus, Boolean pairStatus, Boolean replicaActive) {
        logger.debug((Object)"enter calculateSyncReplicationRPO");
        if (replicaActive != null && !replicaActive.booleanValue()) {
            cfgRPO.put(recoverySiteId, -3);
            return;
        }
        if (pairStatus.booleanValue() && dataStatus.booleanValue()) {
            cfgRPO.put(recoverySiteId, 0);
        } else {
            cfgRPO.put(recoverySiteId, -3);
        }
    }

    private void calculateRdAutoRPO(Map<String, Object> cfgRPO, ProtectGroup protectGroup, String recoverySiteId, String replicaId, Boolean replicaActive) {
        logger.debug((Object)"enter calculateRdAutoRPO");
        if (replicaActive != null && !replicaActive.booleanValue()) {
            cfgRPO.put(recoverySiteId, -3);
            return;
        }
        Long lastSuccessExecutedTime = this.getLastSuccessExcTime(protectGroup, replicaId);
        if (lastSuccessExecutedTime != null) {
            cfgRPO.put(recoverySiteId, System.currentTimeMillis() - lastSuccessExecutedTime);
        } else {
            cfgRPO.put(recoverySiteId, -3);
        }
    }

    private void getRpoBean(ProtectGroup protectGroup, RPOContext context) {
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        Map allReplicationRelation = protectGroup.getAllReplicationRelation();
        Schedule schedule = this.getSchedule(1, policyTemplate);
        if (schedule.getExpectedRPO() == null) {
            return;
        }
        ProtectGroupReplica pgr = this.getProtectGroupReplica(1, protectGroup.getReplicaList());
        List rpoBeanList = (List)context.getObject("RPO_BEANS");
        if (VerifyUtil.isEmpty((Collection)rpoBeanList)) {
            logger.error((Object)"rpoBeanList is empty!", 1073947393L);
            return;
        }
        RPOCalculateBean rpoBean1 = (RPOCalculateBean)rpoBeanList.get(0);
        int policyType = policyTemplate.getType();
        if (policyType == 0) {
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, pgr, (Map<String, List<ReplicationRelationBo>>)allReplicationRelation, true);
            return;
        }
        if (policyType == 1 || policyType == 33) {
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, pgr, (Map<String, List<ReplicationRelationBo>>)allReplicationRelation, false);
            return;
        }
        if (SYN_3DC_TEMPLATE_TYPE_LIST.contains(policyType)) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
                logger.error((Object)"ReplicaList is empty!", 1073947393L);
                return;
            }
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, (ProtectGroupReplica)protectGroup.getReplicaList().iterator().next(), (Map<String, List<ReplicationRelationBo>>)allReplicationRelation, true);
            return;
        }
        if (SPECIALLIST.contains(policyType)) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
                logger.error((Object)"ReplicaList is empty!", 1073947393L);
                return;
            }
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, (ProtectGroupReplica)protectGroup.getReplicaList().iterator().next(), (Map<String, List<ReplicationRelationBo>>)allReplicationRelation, false);
            return;
        }
        if (policyType == 27 || policyType == 26) {
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, pgr, (Map<String, List<ReplicationRelationBo>>)allReplicationRelation, context);
            return;
        }
        this.extractArray3dcRPOData(protectGroup, allReplicationRelation, schedule, pgr, rpoBeanList, rpoBean1);
    }

    protected RPOCalculateBean extractArrayRPOData(PolicyTemplate policyTemplate, RPOCalculateBean rpoBean1, Schedule schedule, ProtectGroupReplica pgr, Map<String, List<ReplicationRelationBo>> allReplicationRelation, RPOContext context) {
        return null;
    }

    private void extractArray3dcRPOData(ProtectGroup protectGroup, Map<String, List<ReplicationRelationBo>> allReplicationRelation, Schedule schedule, ProtectGroupReplica pgr, List<RPOCalculateBean> rpoBeanList, RPOCalculateBean rpoBean1) {
        logger.debug((Object)"enter extractArray3dcRPOData");
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        Schedule schedule2 = this.getSchedule(2, policyTemplate);
        ProtectGroupReplica pgr2 = this.getProtectGroupReplica(2, protectGroup.getReplicaList());
        RPOCalculateBean rpoBean2 = new RPOCalculateBean();
        rpoBean2.setPgId(protectGroup.getUuid());
        rpoBean2.setPgName(protectGroup.getName());
        rpoBeanList.add(rpoBean2);
        this.setReplicaId(pgr, rpoBean1, pgr2, rpoBean2);
        int policyType = policyTemplate.getType();
        if (policyType == 4 || policyType == 6 || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(policyType)) {
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, pgr, allReplicationRelation, false);
        } else if (policyType == 3 || policyType == 5) {
            this.extractArrayRPOData(policyTemplate, rpoBean1, schedule, pgr, allReplicationRelation, true);
        }
        this.extractArrayRPOData(policyTemplate, rpoBean2, schedule2, pgr2, allReplicationRelation, false);
    }

    private void setReplicaId(ProtectGroupReplica pgr, RPOCalculateBean rpoBean1, ProtectGroupReplica pgr2, RPOCalculateBean rpoBean2) {
        logger.debug((Object)"enter setReplicaId");
        if (null != pgr) {
            rpoBean1.setReplicaId(pgr.getId());
        }
        if (null != pgr2) {
            rpoBean2.setReplicaId(pgr2.getId());
        }
    }

    private RPOCalculateBean extractArrayRPOData(PolicyTemplate policyTemplate, RPOCalculateBean rpoCalBean, Schedule schedule, ProtectGroupReplica pgr, Map<String, List<ReplicationRelationBo>> allReplicationRelation, Boolean isSync) {
        logger.debug((Object)"enter extractArrayRPOData");
        if (null != pgr) {
            rpoCalBean.setRecoverySiteId(schedule.getProtectLocation() + "," + this.getProductSiteIdByReplica(pgr) + "," + pgr.getRecoverySite());
            rpoCalBean.setReplicaActive(pgr.getStatus() == DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
        }
        if (!isSync.booleanValue()) {
            rpoCalBean.setIsSyncArray(false);
            this.dealRDRPO(policyTemplate, schedule, rpoCalBean);
        } else {
            rpoCalBean.setIsSyncArray(true);
        }
        if (null != pgr) {
            this.dealDeviceRPO(pgr, allReplicationRelation, rpoCalBean);
        }
        return rpoCalBean;
    }

    protected void dealRDRPO(PolicyTemplate policyTemplate, Schedule schedule, RPOCalculateBean rpoCalBean) {
        logger.debug((Object)"enter dealRDRPO");
        int scheduleMode = schedule.getScheduleMode();
        if (1 == scheduleMode) {
            rpoCalBean.setIsRdManual(true);
        } else {
            rpoCalBean.setIsRdManual(false);
            if (!ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)schedule, new Date())) {
                rpoCalBean.setInTimeRange(false);
            } else {
                rpoCalBean.setRdInterval(this.getConfigRPO(policyTemplate.getProps(), schedule.getProtectLocation()));
            }
        }
    }

    protected void dealDeviceRPO(ProtectGroupReplica pgr, Map<String, List<ReplicationRelationBo>> allReplicationRelation, RPOCalculateBean rpoCalBean) {
        String recoverySite = pgr.getRecoverySite();
        List<ReplicationRelationBo> bos = allReplicationRelation.get(recoverySite);
        if (null == bos) {
            logger.error((Object)("There is no replication. Site:" + recoverySite));
            return;
        }
        for (ReplicationRelationBo bo : bos) {
            String errorMsg = "pgName:" + rpoCalBean.getPgName() + ", replicationId:" + bo.getReplicationId() + ", srcDevSn:" + bo.getSrcDeviceSn() + ", targetDevSn:" + bo.getTgtDeviceSn();
            String srcDeviceSn = bo.getSrcDeviceSn();
            String tgtDeviceSn = bo.getTgtDeviceSn();
            boolean consistentGroup = bo.isConsistentGroup();
            int deviceStatus = this.getStorageStatus(srcDeviceSn);
            if (deviceStatus != 0) {
                rpoCalBean.setIsOkRdConnDevice(false);
                return;
            }
            rpoCalBean.setIsOkRdConnDevice(true);
            Site srcSite = this.getSiteByResourceSN(srcDeviceSn);
            if (srcSite == null) {
                logger.error((Object)("srcSite is empty!" + errorMsg), -1L);
                return;
            }
            List<ReplicationTargetLun> repTgtLuns = this.getReplicationTargetLuns(bo, rpoCalBean);
            if (VerifyUtil.isEmpty(repTgtLuns)) {
                logger.error((Object)("ReplicationTargetLun is empty!" + errorMsg), -1L);
                return;
            }
            if (consistentGroup) {
                IRecoveryResourceService recoveryResourceService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
                ReplicationRelation rr = recoveryResourceService.queryReplication(srcDeviceSn, tgtDeviceSn, bo.getReplicationId(), true);
                if (rr == null) {
                    logger.error((Object)("the replicationGroup is null! " + errorMsg), -1L);
                    continue;
                }
                ReplicationGroup rg = (ReplicationGroup)rr;
                this.dealConsistentGroup(rpoCalBean, rg, repTgtLuns);
                continue;
            }
            this.dealNotConsistentGroup(rpoCalBean, repTgtLuns, false);
        }
    }

    protected List<ReplicationTargetLun> getReplicationTargetLuns(ReplicationRelationBo bo, RPOCalculateBean rpoCalBean) {
        IRecoveryProcessHandler recoveryProcHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        List repTgtLuns = recoveryProcHandler.querySyncStatus(bo.getSrcDeviceSn(), bo.getTgtDeviceSn(), bo.getReplicationId(), bo.isConsistentGroup());
        return repTgtLuns;
    }

    protected ProtectGroupReplica getProtectGroupReplica(int index, Set<ProtectGroupReplica> replicaList) {
        logger.debug((Object)"enter getProtectGroupReplica");
        for (ProtectGroupReplica pgr : replicaList) {
            if (pgr.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue() && index == 1) {
                return pgr;
            }
            if (pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_C.getValue() && pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.B_C.getValue() && pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue() || index != 2) continue;
            return pgr;
        }
        return null;
    }

    protected void dealConsistentGroup(RPOCalculateBean rpoCalBean, ReplicationGroup rg, List<ReplicationTargetLun> repTgtLuns) {
        if (null != rg) {
            int syncType = rg.getSyncType();
            logger.debug((Object)("syncType:" + syncType));
            if (TypeEnum.HyperMirrorEnums.SyncType.MANUAL.getValue() == syncType) {
                rpoCalBean.setIsDeviceManual(true);
                return;
            }
            Long timing = rg.getTiming();
            if (rpoCalBean.getIsDeviceManual() == null) {
                rpoCalBean.setIsDeviceManual(false);
            }
            long interval = rpoCalBean.getDeviceInterval();
            if (timing != null) {
                rpoCalBean.setDeviceInterval(interval < (timing = Long.valueOf(timing * 1000L)) ? timing : interval);
            }
        }
        this.dealNotConsistentGroup(rpoCalBean, repTgtLuns, true);
    }

    protected void dealNotConsistentGroup(RPOCalculateBean rpoCalBean, List<ReplicationTargetLun> targetLuns, Boolean isConsistentGroup) {
        logger.debug((Object)"enter dealNotConsistentGroup");
        for (ReplicationTargetLun targetLun : targetLuns) {
            this.dealSingleTargetLun(rpoCalBean, targetLun, isConsistentGroup);
        }
    }

    private void dealSingleTargetLun(RPOCalculateBean rpoCalBean, ReplicationTargetLun targetLun, Boolean isConsistentGroup) {
        Boolean pStatus;
        Boolean dStatus;
        int syncType = targetLun.getSyncType();
        if (TypeEnum.HyperMirrorEnums.SyncType.MANUAL.getValue() == syncType && !isConsistentGroup.booleanValue()) {
            rpoCalBean.setIsDeviceManual(true);
            return;
        }
        Integer dataStatus = targetLun.getDataStatus();
        Integer pairStatus = targetLun.getPairStatus();
        if (rpoCalBean.getIsDeviceManual() == null) {
            rpoCalBean.setIsDeviceManual(false);
        }
        if (!(dStatus = this.getDataStatus(dataStatus)).booleanValue()) {
            rpoCalBean.setDataStatus(dStatus);
        }
        if (!(pStatus = this.getPairStatus(pairStatus)).booleanValue()) {
            rpoCalBean.setPairStatus(pStatus);
        }
        if (isConsistentGroup.booleanValue()) {
            return;
        }
        Long timing = targetLun.getTiming();
        logger.debug((Object)("get targetLun timing is : " + timing));
        long interval = rpoCalBean.getDeviceInterval();
        if (timing != null) {
            rpoCalBean.setDeviceInterval(interval < (timing = Long.valueOf(timing * 1000L)) ? timing : interval);
        }
    }

    protected Schedule getSchedule(int index, PolicyTemplate policyTemplate) {
        Set schedules = policyTemplate.getSchedules();
        if (schedules == null || schedules.isEmpty()) {
            return new Schedule();
        }
        if (schedules.size() == 1) {
            return (Schedule)schedules.iterator().next();
        }
        HashSet<Schedule> schedules2 = new HashSet<Schedule>();
        for (Schedule sch : schedules) {
            if (sch.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue() && index == 1) {
                schedules2.add(sch);
            }
            if (sch.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_C.getValue() && sch.getProtectLocation() != DrmEnumDefine.ProtectLocation.B_C.getValue() || index != 2) continue;
            schedules2.add(sch);
        }
        if (schedules2.isEmpty()) {
            return this.getAutoSchedule(schedules);
        }
        return this.getAutoSchedule(schedules2);
    }

    protected Schedule getAutoSchedule(Set<Schedule> schedules) {
        for (Schedule schedule : schedules) {
            if (schedule.getScheduleMode() == 1) continue;
            logger.debug((Object)("ScheduleId:" + schedule.getScheduleId()));
            return schedule;
        }
        return schedules.iterator().next();
    }

    private Boolean getPairStatus(Integer pairStatus) {
        return 1 == pairStatus;
    }

    private Boolean getDataStatus(Integer dataStatus) {
        return XveEnumDefinePParent.RM_LUN_MIRROR_STATE_E.RM_LUN_MIRROR_STATE_SYNCED.getValue() == dataStatus.intValue() || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZED.getValue() == dataStatus.intValue() || XveEnumDefinePParent.RM_LUN_MIRROR_STATE_E.RM_LUN_MIRROR_STATE_CONSISTENT.getValue() == dataStatus.intValue();
    }

    protected String getProductSiteIdByReplica(ProtectGroupReplica pgr) {
        String productSn = pgr.getProductArray();
        Site productSite = this.getSiteByResourceSN(productSn == null ? "--" : productSn);
        String productSiteId = productSite == null ? "--" : productSite.getSiteId();
        return productSiteId;
    }
}

