/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CascadeSAsyncProtectionPath
extends AbstractProtectionPathImpl {
    protected static final String ACTUAL_TEMPLATE_TYPE = "ACTUAL_TEMPLATE_TYPE";
    private static final Log logger = LogFactory.getInstance(CascadeSAsyncProtectionPath.class);

    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ExecutionContext context = this.init(luns, batchOperation);
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        ProtectionPath siteprotectionpath = new ProtectionPath();
        ProtectionPath recoveryprotectionpath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelation(protectgroup, context));
        siteprotectionpath.setPathDetails(sitePathDetails);
        pathList.add(siteprotectionpath);
        rdPathDetails.add(this.getRDPath(protectgroup, context));
        recoveryprotectionpath.setPathDetails(rdPathDetails);
        pathList.add(recoveryprotectionpath);
        ProtectionPathData ppd = new ProtectionPathData(pathList);
        if (batchOperation.getErrorCode() != 0L) {
            logger.warn((Object)("CascadeSAsyncProtectionPath build error. error code:" + batchOperation.getErrorCode()));
            batchOperation.setTargetName(protectgroup.getName());
            ppd.setOperation(batchOperation);
        }
        ppd.setTemplateType(this.getPolicyTemplateType());
        if (!VerifyUtil.isEmpty((Object)context.getAttribute(ACTUAL_TEMPLATE_TYPE))) {
            ppd.setTemplateType(((Integer)context.getAttribute(ACTUAL_TEMPLATE_TYPE)).intValue());
        }
        return ppd;
    }

    public int getPolicyTemplateType() {
        logger.debug((Object)"PolicyTemplateType:ARRAY_CASCADE_SYNC_ASYNC");
        return 3;
    }

    protected String getSiteRelation(ProtectGroup protectgroup, ExecutionContext context) {
        String info = "SiteRelationsInfo";
        logger.debug((Object)("getSiteRelation info:" + info));
        String sbresult = this.getDataByInfo(info, protectgroup, context);
        String result = sbresult + "\n";
        return result;
    }

    protected String getRDPath(ProtectGroup protectgroup, ExecutionContext context) {
        String info = "RDPathInfo";
        logger.debug((Object)("getRDPath info:" + info));
        String sbresult = this.getDataByInfo(info, protectgroup, context);
        String result = sbresult + "\n";
        return result;
    }

    private List<ProtectGroupReplica> protectGroupReplicaoderByType(Set<ProtectGroupReplica> replicaset) {
        List<ProtectGroupReplica> list = replicaset.stream().filter(replica -> replica.getType() != 3).filter(replica -> replica.getType() != 4).filter(replica -> replica.getType() != 102).distinct().collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j <= i; ++j) {
                if (((ProtectGroupReplica)list.get(j)).getProtectLocation() <= list.get(i).getProtectLocation()) continue;
                ProtectGroupReplica temp = list.get(i);
                list.set(i, list.get(j));
                list.set(j, temp);
            }
        }
        logger.debug((Object)("list:" + list));
        return list;
    }

    private String getDataByInfo(String info, ProtectGroup protectgroup, ExecutionContext context) {
        StringBuffer sb = new StringBuffer();
        List<ProtectGroupReplica> replicalist = this.protectGroupReplicaoderByType(protectgroup.getReplicaList());
        if ("SiteRelationsInfo".equals(info)) {
            sb.append(this.getSiteInfo(replicalist, context));
        } else if ("RDPathInfo".equals(info)) {
            sb.append(this.getReplicaInfo(replicalist, context));
        }
        logger.debug((Object)("sb:" + sb));
        return sb.toString();
    }

    protected String getSiteInfo(List<ProtectGroupReplica> replicalist, ExecutionContext context) {
        if (VerifyUtil.isEmpty(replicalist) || replicalist.size() < 2) {
            logger.error((Object)("replicalist is empty or the size is less than two. replicalist:" + replicalist));
            throw new LegoCheckedException(1073947393L);
        }
        Site siteA = this.getSiteByStorageSn(replicalist.get(0).getProductArray());
        Site siteB = this.getSiteByStorageSn(replicalist.get(0).getRecoveryArray());
        Site siteC = this.getSiteByStorageSn(replicalist.get(1).getRecoveryArray());
        if (null == siteA || null == siteB || null == siteC) {
            logger.error((Object)("get site info failed.siteA:" + siteA + ", siteB:" + siteB + ", siteC:" + siteC));
            this.getBatchOperation(context).setErrorCode(1073948207L);
        }
        if (replicalist.get(1).getProtectLocation() == DrmEnumDefine.ProtectLocation.C_C.getValue()) {
            this.getActualTemplateType(replicalist.get(0), context);
            return this.getSiteHeadInfoDRRing(siteA, siteB, siteC, context);
        }
        return this.getSiteHeadInfo(siteA, siteB, siteC);
    }

    protected String getSiteHeadInfoDRRing(Site siteA, Site siteB, Site siteC, ExecutionContext context) {
        int templateType = this.getPolicyTemplateType();
        if (!VerifyUtil.isEmpty((Object)context.getAttribute(ACTUAL_TEMPLATE_TYPE))) {
            templateType = (Integer)context.getAttribute(ACTUAL_TEMPLATE_TYPE);
        }
        if (PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC.getValue() == templateType) {
            return this.getCascadeInfoDRRing(siteA, siteB, siteC);
        }
        return this.getConCurrentInfoDRRing(siteA, siteB, siteC);
    }

    private String getCascadeInfoDRRing(Site siteA, Site siteB, Site siteC) {
        StringBuffer sb = new StringBuffer();
        if (null != siteA && null != siteB && null != siteC) {
            sb.append(siteA.getName());
            sb.append(" --> ");
            sb.append(siteB.getName());
            sb.append(" -(normal)-> ");
            sb.append(siteC.getName() + "\n");
            sb.append(siteA.getName());
            sb.append(" -(standby)-> ");
            sb.append(siteC.getName() + "\n");
        }
        logger.debug((Object)("sb:" + sb));
        return sb.toString();
    }

    private String getConCurrentInfoDRRing(Site siteA, Site siteB, Site siteC) {
        StringBuffer sb = new StringBuffer();
        if (null != siteA && null != siteB && null != siteC) {
            sb.append(siteA.getName());
            sb.append(" --> ");
            sb.append(siteB.getName());
            sb.append(" -(standby)-> ");
            sb.append(siteC.getName() + "\n");
            sb.append(siteA.getName());
            sb.append(" -(normal)-> ");
            sb.append(siteC.getName() + "\n");
        }
        logger.debug((Object)("sb:" + sb));
        return sb.toString();
    }

    protected void getActualTemplateType(ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        int templateType = this.getPolicyTemplateType();
        List pairList = null;
        String proDevSn = "";
        String lunId = "";
        try {
            Set pors = protectGroupReplica.getReplicas();
            ProtectObjectReplica por = (ProtectObjectReplica)pors.iterator().next();
            RelicaStorageInfo resInfo = (RelicaStorageInfo)por.getStorageInfos().iterator().next();
            proDevSn = resInfo.getSrcStorageProviderSN();
            lunId = resInfo.getSrcStorageId();
            ArrayList<String> lunIds = new ArrayList<String>();
            lunIds.add(lunId);
            Integer resourceType = DrmEnumDefine.ResourceTypeE.LUN.getValue();
            String wwn = resInfo.getProtectObjectStorageWwn();
            if (VerifyUtil.isEmpty((String)wwn) || wwn.contains("/")) {
                resourceType = DrmEnumDefine.ResourceTypeE.NAS.getValue();
            }
            logger.debug((Object)"sn:%s, resId:%s,type:%s, wwn:%s", new Object[]{proDevSn, lunIds, resourceType, wwn});
            pairList = this.getStorageService().queryReplicationPairsByMasterLunId(proDevSn, lunIds, true, resourceType);
        }
        catch (Exception e) {
            logger.error((Object)("query replicationpairs error." + proDevSn + " error is :" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (VerifyUtil.isEmpty(pairList)) {
            context.setAttribute(ACTUAL_TEMPLATE_TYPE, (Object)templateType);
            return;
        }
        this.ensureTemplateType(pairList, proDevSn, context);
    }

    private void ensureTemplateType(List<ReplicationPair> pairList, String proDevSn, ExecutionContext context) {
        boolean isCascade = false;
        for (ReplicationPair replicationPair : pairList) {
            if (!replicationPair.isStandby() || !proDevSn.equals(replicationPair.getSrcDevSN())) continue;
            isCascade = true;
            break;
        }
        if (isCascade) {
            context.setAttribute(ACTUAL_TEMPLATE_TYPE, (Object)PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC.getValue());
            return;
        }
        context.setAttribute(ACTUAL_TEMPLATE_TYPE, (Object)PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_SYNC_ASYNC.getValue());
    }

    private String getSiteHeadInfo(Site siteA, Site siteB, Site siteC) {
        StringBuffer sb = new StringBuffer();
        if (null != siteA && null != siteB && null != siteC) {
            sb.append(siteA.getName());
            sb.append(" --> ");
            sb.append(siteB.getName());
            sb.append(" --> ");
            sb.append(siteC.getName() + "\n");
        }
        logger.debug((Object)("sb:" + sb));
        return sb.toString();
    }

    private String getReplicaInfo(List<ProtectGroupReplica> replicalist, ExecutionContext context) {
        logger.debug((Object)"to getReplicaInfo start..");
        StringBuffer sb = new StringBuffer();
        HashMap<String, List<RelicaStorageInfo[]>> map = new HashMap<String, List<RelicaStorageInfo[]>>();
        for (ProtectGroupReplica protectgroupreplica : replicalist) {
            this.informationSplic(protectgroupreplica, map);
        }
        HashSet<String> pathSet = new HashSet<String>();
        for (List replicas : map.values()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            for (RelicaStorageInfo[] replica : replicas) {
                String lunReplicaInfo = this.getLunReplicaInfo(replica, context);
                if (pathSet.contains(lunReplicaInfo)) continue;
                pathSet.add(lunReplicaInfo);
                sb.append(lunReplicaInfo + "\n");
            }
        }
        return sb.toString();
    }

    protected String getLunReplicaInfo(RelicaStorageInfo[] replica, ExecutionContext context) {
        int templateType = this.getPolicyTemplateType();
        if (!VerifyUtil.isEmpty((Object)context.getAttribute(ACTUAL_TEMPLATE_TYPE))) {
            templateType = (Integer)context.getAttribute(ACTUAL_TEMPLATE_TYPE);
        }
        if (PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC.getValue() == templateType) {
            return this.getCascadeLunReplicaInfo(replica, context);
        }
        return this.getConCurrentLunReplicaInfo(replica, context);
    }

    protected String getCascadeLunReplicaInfo(RelicaStorageInfo[] replica, ExecutionContext context) {
        StringBuffer sb = new StringBuffer();
        if (replica == null || replica.length < 2) {
            return sb.toString();
        }
        sb.append(this.getRelicaStorageString(replica[0], true, context));
        sb.append(this.getRelicaStorageString(replica[1], false, context));
        logger.debug((Object)("to getLunReplicaInfo. lun replica info:" + sb));
        return sb.toString();
    }

    protected String getConCurrentLunReplicaInfo(RelicaStorageInfo[] replica, ExecutionContext context) {
        StringBuffer sb = new StringBuffer();
        if (replica == null || replica.length < 2) {
            return sb.toString();
        }
        sb.append(this.getRelicaStorageString(replica[0], true, context));
        sb.append(" + \n" + this.getRelicaStorageString(replica[1], true, context));
        return sb.toString();
    }

    protected String getRelicaStorageString(RelicaStorageInfo replica, boolean flag, ExecutionContext context) {
        StringBuilder sb = new StringBuilder();
        if (flag) {
            sb.append(this.getLunNameAndIp(true, replica.getSrcStorageProviderSN(), replica.getSrcStorageId(), context));
        }
        sb.append(" --> ").append(this.getLunNameAndIp(false, replica.getStorageProviderSN(), replica.getStorageId(), context));
        logger.debug((Object)("to getRelicaStorageString end. sb:" + sb));
        return sb.toString();
    }

    protected String getLunNameAndIp(boolean flag, String sn, String id, ExecutionContext context) {
        DrResource resource = this.getStorageBySn(sn);
        String name = null;
        String resourceIp = null;
        StorageResource storageResource = (StorageResource)this.getAllLuns(context).get(sn + id);
        if (null != storageResource && null != resource) {
            name = storageResource.getName();
            resourceIp = resource.getIpAddress();
        } else {
            this.getBatchOperation(context).setErrorCode(1073948206L);
        }
        logger.debug((Object)("to getLunNameAndIp end. sn:" + sn + ", id:" + id));
        return name + "(" + resourceIp + ")";
    }

    private void informationSplic(ProtectGroupReplica protectgroupreplica, Map<String, List<RelicaStorageInfo[]>> map) {
        logger.debug((Object)"informationSplic invoked..");
        for (ProtectObjectReplica por : protectgroupreplica.getReplicas()) {
            this.getResult(por, map);
        }
    }

    private void getResult(ProtectObjectReplica por, Map<String, List<RelicaStorageInfo[]>> mapping) {
        logger.debug((Object)"getResult invoked..");
        for (RelicaStorageInfo resInfo : por.getStorageInfos()) {
            RelicaStorageInfo[] exist;
            String id = por.getPoId() + resInfo.getProtectObjectStorageWwn();
            List<RelicaStorageInfo[]> storages = mapping.get(id);
            if (storages == null) {
                storages = new ArrayList<RelicaStorageInfo[]>();
                mapping.put(id, storages);
            }
            if ((exist = this.getExist(storages, resInfo)) == null) {
                storages.add(new RelicaStorageInfo[]{resInfo, null});
                continue;
            }
            exist[1] = resInfo;
        }
    }

    protected RelicaStorageInfo[] getExist(List<RelicaStorageInfo[]> m, RelicaStorageInfo info) {
        RelicaStorageInfo[] result = null;
        for (RelicaStorageInfo[] each : m) {
            if (each == null || each.length < 2) {
                logger.warn((Object)"each is null or the size is less than 2.");
                continue;
            }
            RelicaStorageInfo that = each[0];
            if (each[1] != null || !that.getStorageProviderSN().equals(info.getSrcStorageProviderSN())) continue;
            result = each;
            break;
        }
        return result;
    }
}

