/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SnapashotProtectionPath
extends AbstractProtectionPathImpl {
    private static final Log logger = LogFactory.getInstance(SnapashotProtectionPath.class);

    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        ProtectionPath siteprotectionpath = new ProtectionPath();
        ProtectionPath recoveryprotectionpath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelation(protectgroup));
        siteprotectionpath.setPathDetails(sitePathDetails);
        pathList.add(siteprotectionpath);
        rdPathDetails.add(this.getRDPath(protectgroup));
        recoveryprotectionpath.setPathDetails(rdPathDetails);
        pathList.add(recoveryprotectionpath);
        ProtectionPathData ppd = new ProtectionPathData(pathList);
        if (batchOperation.getErrorCode() != 0L) {
            batchOperation.setTargetName(protectgroup.getName());
            ppd.setOperation(batchOperation);
        }
        return ppd;
    }

    private String getRDPath(ProtectGroup protectgroup) {
        StringBuilder sb = new StringBuilder();
        Set polist = protectgroup.getPolist();
        String devSn = null;
        Integer resourceType = DrmEnumDefine.ResourceTypeE.LUN.getValue();
        if (VerifyUtil.isEmpty((Collection)polist)) {
            logger.error((Object)("polist is empty!protectGroupName:" + protectgroup.getName()));
            return sb.toString();
        }
        HashSet<String> resourceIdSet = new HashSet<String>();
        for (ProtectObject po : polist) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
                logger.warn((Object)("usedStorageResourceSet is empty!poName:" + po.getName()));
                continue;
            }
            for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
                String resourceId = poStorageInfo.getResourceId();
                devSn = poStorageInfo.getResourceProviderSN();
                resourceType = poStorageInfo.getResourceType();
                resourceIdSet.add(resourceId);
            }
        }
        ArrayList resourceIdList = new ArrayList(resourceIdSet);
        DrmEnumDefine.ResourceTypeE type = DrmEnumDefine.ResourceTypeE.NAS.getValue() == resourceType.intValue() ? DrmEnumDefine.ResourceTypeE.NAS : DrmEnumDefine.ResourceTypeE.LUN;
        List storageResources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(devSn, resourceIdList, type);
        if (VerifyUtil.isEmpty((Collection)storageResources)) {
            logger.warn((Object)("storageResources is empty!devSn:" + devSn + ",resourceIdList:" + resourceIdList));
            return sb.toString();
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(devSn);
        String ip = drResource == null ? "" : drResource.getIpAddress();
        for (StorageResource sr : storageResources) {
            sb.append(sr.getName()).append('(').append(ip).append(')').append(';').append("\n");
        }
        return sb.toString();
    }

    private String getSiteRelation(ProtectGroup protectgroup) {
        return protectgroup.getProductSiteName();
    }

    public int getPolicyTemplateType() {
        return 2;
    }
}

