/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayHyperMetroSnapShotBuilder
extends ArraySnapshotBuilder {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroSnapShotBuilder.class);

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
    }

    @Override
    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        List storageInfos = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            return Collections.emptyMap();
        }
        ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)storageInfos.iterator().next();
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{info.getLunWWN()});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("resources is empty or the size is not two!" + info.getLunWWN()), 90160758786897L);
            return null;
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(DrmEnumDefine.ProtectLocation.A_A.getValue(), ((StorageResource)resources.get(0)).getDevSn());
        result.put(DrmEnumDefine.ProtectLocation.B_B.getValue(), ((StorageResource)resources.get(1)).getDevSn());
        return result;
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        ArrayList wwns = new ArrayList();
        HashMap<String, List<ProtectObjectStorageInfo>> map = new HashMap<String, List<ProtectObjectStorageInfo>>();
        HashMap storageInfoMap = new HashMap();
        protectGroup.distinctStorageInfo().forEach(storageInfo -> storageInfoMap.put(storageInfo.getLunWWN(), storageInfo));
        protectGroup.distinctStorageInfo().forEach(storage -> wwns.add(storage.getLunWWN()));
        ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()])).forEach(storageResource -> {
            Lun lun = (Lun)storageResource;
            ProtectObjectStorageInfo oldStorageInfo = (ProtectObjectStorageInfo)storageInfoMap.get(lun.getWwn());
            if (null != oldStorageInfo) {
                ProtectObjectStorageInfo storageInfo = new ProtectObjectStorageInfo();
                storageInfo.setArchiveLog(oldStorageInfo.getArchiveLog());
                storageInfo.setResourceProviderSN(lun.getDevSn());
                storageInfo.setResourceId(lun.getResourceId());
                ProtectGroupUtil.putObjectToMap((Map)map, (Object)lun.getDevSn(), (Object)storageInfo);
            }
        });
        return map;
    }
}

