/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLicenseManager;
import com.huawei.ism.drm.storage.protection.replica.factory.AbstractReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.DoradoHyperClone;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Set;

public class HyperCloneReplicaFactory
extends AbstractReplicaFactory {
    private static final Log logger = LogFactory.getInstance(HyperCloneReplicaFactory.class);

    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        logger.info((Object)("begin to create clone replica of  protectgroup replica(" + sourceReplica.getId() + "-" + sourceReplica.getName() + ")."));
        if (sourceReplica.getType() != 3 && sourceReplica.getType() != 5) {
            logger.error((Object)("The replica (" + sourceReplica.getId() + "-" + sourceReplica.getName() + ") can not create clone replica"));
            throw new LegoCheckedException(1073948693L);
        }
        String devSN = sourceReplica.getProductArray();
        IStorageLicenseManager licenseManager = (IStorageLicenseManager)ServiceLocator.getInstance().getService(IStorageLicenseManager.class);
        StorageLicense licenseInfo = licenseManager.getArrayLicense(devSN);
        if (!licenseInfo.isSupportFeature("3")) {
            logger.error((Object)("Device " + devSN + " is not support to create clone feature."));
            throw new LegoCheckedException(1073948693L);
        }
        ProtectGroupReplica newReplica = sourceReplica;
        Object targetReplicaFactory = null;
        if (sourceReplica.getType() == 4 || sourceReplica.getType() == 102) {
            logger.error((Object)"HyperCDP replica can not create clone replica.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica cloneReplica = null;
        try {
            cloneReplica = (ProtectGroupReplica)newReplica.clone();
            cloneReplica.setId(UUIDGenerator.getUUID());
            cloneReplica.setName(this.buildReplicaName(sourceReplica));
            cloneReplica.setSourceReplicaId(sourceReplica.getId());
            cloneReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            cloneReplica.setMountedHost("");
            cloneReplica.addProperty("planId", null);
            cloneReplica.setGeneration(Integer.valueOf(2));
            cloneReplica.setType(5);
            Set replicaList = cloneReplica.getReplicas();
            String devId = newReplica.getStorageDeviceId();
            IStorageHyperCloneManager cloneManager = StorageHyperCloneManagerProxy.getInstance().getStorageHyperCloneManager(devId);
            for (ProtectObjectReplica protectObjectReplica : replicaList) {
                protectObjectReplica.setId(UUIDGenerator.getUUID());
                Set protectObjectStorageList = protectObjectReplica.getStorageInfos();
                for (RelicaStorageInfo storageInfo : protectObjectStorageList) {
                    String srcDevId = storageInfo.getSrcStorageId();
                    DoradoHyperClone hyperClone = new DoradoHyperClone();
                    hyperClone.setClone(true);
                    hyperClone.setName("DRdata_" + srcDevId + "_" + System.currentTimeMillis());
                    hyperClone.setSourceId(srcDevId);
                    hyperClone.setSplitSpeed(Integer.valueOf(4));
                    hyperClone = cloneManager.createDoradoHyperClone(devId, hyperClone);
                    cloneManager.splitDoradoHyperClone(devId, hyperClone.getResourceId());
                    storageInfo.setSrcStorageId(srcDevId);
                    storageInfo.setStorageId(hyperClone.getResourceId());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred while create clone replica of protectgroup replica(" + newReplica.getId() + "-" + newReplica.getName() + "). error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        logger.info((Object)("Finish creating clone replica of protectgroup replica(" + sourceReplica.getId() + "-" + sourceReplica.getName() + "), clone replica(" + cloneReplica.getId() + "-" + cloneReplica.getName() + ")."));
        return cloneReplica;
    }

    private void deleteTmpSnapShot(IReplicaFactory targetReplicaFactory, ProtectGroupReplica newReplica) {
        if (!VerifyUtil.isEmpty((Object)targetReplicaFactory)) {
            ArrayList<ProtectGroupReplica> delReplicas = new ArrayList<ProtectGroupReplica>();
            delReplicas.add(newReplica);
            targetReplicaFactory.deleteReplicas(newReplica.getPg(), delReplicas, true);
        }
    }

    public boolean validReplica(ProtectGroupReplica replica, boolean needHandleException) {
        return true;
    }

    @Override
    protected void deleteReplica(ProtectGroupReplica toDelete, boolean isNeedSendAlarm) {
        toDelete.getReplicas().stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
            Set storageReplicaList = item.getStorageInfos();
            storageReplicaList.stream().filter(si -> !VerifyUtil.isEmpty((Object)si)).forEach(si -> this.deleteCloneLun((RelicaStorageInfo)si, isNeedSendAlarm));
        });
    }

    private void deleteCloneLun(RelicaStorageInfo replicaInfo, boolean isNeedSendAlarm) {
        String deviceId = replicaInfo.getStorageProviderSN();
        String lunId = replicaInfo.getStorageId();
        logger.info((Object)("Begin to delete clone lun " + lunId + " from " + deviceId + "."));
        try {
            Lun lun = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(deviceId).getLunById(deviceId, lunId);
            if (null == lun) {
                logger.info((Object)("lun " + lunId + " from " + deviceId + " is not exists"));
                return;
            }
            StorageLunManagerProxy.getInstance().deleteLun(deviceId, new String[]{lunId});
            logger.info((Object)("Delete clone lun " + replicaInfo.getStorageId() + " from " + replicaInfo.getStorageProviderSN() + " succ."));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("deleteCloneLun error: " + replicaInfo.getSrcStorageProviderSN() + ",Id=" + lunId + " from device=" + deviceId + "," + ExceptionUtil.getErrorMessage((Throwable)e) + ",errorcode=" + e.getErrorCode()));
            this.dealDeleteReplicaException(replicaInfo, (Exception)((Object)e), isNeedSendAlarm);
        }
        catch (Exception e) {
            logger.error((Object)("deleteCloneLun: delete clone lun=" + lunId + " from device=" + deviceId + " failed," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.dealDeleteReplicaException(replicaInfo, e, isNeedSendAlarm);
        }
    }

    private void dealDeleteReplicaException(RelicaStorageInfo replicaInfo, Exception e, boolean isNeedSendAlarm) {
        logger.error((Object)("delete clone repica error.cloneID:" + replicaInfo.getStorageId()), (Throwable)e);
        if (isNeedSendAlarm) {
            String id = replicaInfo.getStorageId();
            String ipAddress = this.getIpAddress(replicaInfo.getStorageProviderSN());
            String[] params = new String[]{id, ipAddress};
            AlarmReporter.sendAlarm((String)"0x3230044", null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])params);
        } else {
            ExceptionUtil.rethrowException((Throwable)e, (String)"delete Snapshot error.", (long)1073948679L, null, (Log)logger);
        }
    }

    public int getFactoryType() {
        return 5;
    }
}

