/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.realtime;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayHyperMetroVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.realtime.ArrayHyperVaultRealTimeBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroVaultRealTimeBuilder
extends ArrayHyperVaultRealTimeBuilder {
    private static final String USED_VAULTID = "USED_VAULTID";
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroVaultRealTimeBuilder.class);

    @Override
    public PolicyTemplateType.PolicyTemplateE getType() {
        return PolicyTemplateType.PolicyTemplateE.ARRAY_HYPERMETRO_VAULT;
    }

    @Override
    public void callBackReplica(ProtectGroupReplica replica) {
        new ArrayHyperMetroVaultBuilder().deleteSnapshots(replica);
    }

    @Override
    public ProtectGroupReplica buildReplica(ProtectGroup protectGroup, int protectLocation) {
        if (protectLocation != DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            logger.error((Object)("hyperMetroVault unsupport Localtion A:" + protectGroup.getUuid()));
            throw new LegoCheckedException(1073947393L);
        }
        this.check(protectGroup, protectLocation);
        ExecutionContext context = this.initData(protectGroup);
        ProtectGroupReplica protectGroupReplica = this.buildProtectGroupReplica(context, protectLocation);
        this.addAllVaultReplica(context, protectGroupReplica);
        return protectGroupReplica;
    }

    private void addAllVaultReplica(ExecutionContext context, ProtectGroupReplica pgReplica) {
        Set hyperVaultSet = (Set)context.getAttribute(USED_VAULTID);
        List hyperVaultList = (List)context.getAttribute("HYPER_VAULT", List.class);
        ProtectObjectReplica poReplica = (ProtectObjectReplica)CommonUtil.getFirstElement((Collection)pgReplica.getReplicas());
        for (HyperVault hyperVault : hyperVaultList) {
            if (!VerifyUtil.isEmpty((Collection)hyperVaultSet) && hyperVaultSet.contains(hyperVault.getId())) continue;
            this.checkAndBuildReplia(context, poReplica, hyperVault.getRemoteResourceId(), hyperVault.getRemoteDeviceSn(), hyperVault);
        }
    }

    @Override
    protected void buildPoStorageInfoReplica(ExecutionContext context, ProtectObjectStorageInfo poStorageInfo, ProtectObjectReplica poReplica) {
        HashSet<String> hyperVaultSet;
        String resourceId = poStorageInfo.getResourceId();
        String sourceDevSn = (String)context.getAttribute("DEVICE_SN_LOCATION_" + DrmEnumDefine.ProtectLocation.A_A.getValue());
        String resourceProviderSN = poStorageInfo.getResourceProviderSN();
        if (!resourceProviderSN.equals(sourceDevSn)) {
            resourceId = this.getOtherSiteResourceIdByHyperMetroPair(resourceProviderSN, resourceId);
        }
        int protectLocation = poReplica.getPgReplica().getProtectLocation();
        HyperVault hyperVault = this.getHyperVaultByLocalResourceId(context, resourceId);
        if (protectLocation == DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            resourceProviderSN = hyperVault.getRemoteDeviceSn();
            resourceId = hyperVault.getRemoteResourceId();
        }
        if (VerifyUtil.isEmpty((Collection)(hyperVaultSet = (HashSet<String>)context.getAttribute(USED_VAULTID)))) {
            hyperVaultSet = new HashSet<String>();
            context.setAttribute(USED_VAULTID, hyperVaultSet);
        }
        hyperVaultSet.add(hyperVault.getId());
        this.checkAndBuildReplia(context, poReplica, resourceId, resourceProviderSN, hyperVault);
    }

    private void checkAndBuildReplia(ExecutionContext context, ProtectObjectReplica poReplica, String resourceId, String resourceProviderSN, HyperVault hyperVault) {
        this.checkNasFileSystem(this.getPG(context), resourceId, resourceProviderSN);
        String snapshotName = PolicyTemplateTools.getInstance().generateSnapshotName(resourceId);
        String snapshotId = "NONE";
        this.buildHyperVaultReplica(poReplica, snapshotId, snapshotName, resourceId, resourceProviderSN, hyperVault.getId());
    }

    private String getOtherSiteResourceIdByHyperMetroPair(String resourceProviderSN, String resourceId) {
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List hyperMetroPairList = storageResourceService.getHyperMetroPairByFileSystems(resourceProviderSN, Arrays.asList(resourceId), null);
        if (VerifyUtil.isEmpty((Collection)hyperMetroPairList)) {
            logger.error((Object)("hyperMetroPairList is not existed! resourceId:" + resourceId + "  devSN:" + resourceProviderSN));
            throw new LegoCheckedException(1073947394L);
        }
        for (HyperMetroPair hyperMetroPair : hyperMetroPairList) {
            if (VerifyUtil.isEmpty((String)hyperMetroPair.getVstorePairId())) continue;
            return hyperMetroPair.getRemoteObjId();
        }
        logger.error((Object)("vstore's HyperMetroPair is not existed! resourceId:" + resourceId + "  devSN:" + resourceProviderSN));
        throw new LegoCheckedException(1073947394L);
    }

    private HyperVault getHyperVaultByLocalResourceId(ExecutionContext context, String resourceId) {
        List hyperVaultList = (List)context.getAttribute("HYPER_VAULT", List.class);
        for (HyperVault hyperVault : hyperVaultList) {
            if (!hyperVault.getLocalResourceId().equals(resourceId)) continue;
            return hyperVault;
        }
        logger.error((Object)("hyperVault is not existed!" + this.getMsg(this.getPG(context))));
        throw new LegoCheckedException(1073948242L);
    }

    private ExecutionContext initData(ProtectGroup protectGroup) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute("PROTECT_GROUP", (Object)protectGroup);
        List<ProtectionRelation> protectionRelationList = this.extractProtectionRelation(protectGroup);
        if (VerifyUtil.isEmpty(protectionRelationList)) {
            logger.error((Object)"protectionRelationList is null");
            throw new LegoCheckedException(1073947393L);
        }
        context.setAttribute("protectionRelation", protectionRelationList);
        List<HyperVault> hyperVaultList = this.getHyperVaultListFromProtectionRelations(protectionRelationList, context);
        context.setAttribute("HYPER_VAULT", hyperVaultList);
        this.setDeviceSN(context, hyperVaultList.get(0));
        return context;
    }

    private List<HyperVault> getHyperVaultListFromProtectionRelations(List<ProtectionRelation> protectionRelationList, ExecutionContext context) {
        String devSn = null;
        HashSet<String> resourceIds = new HashSet<String>();
        for (ProtectionRelation relation : protectionRelationList) {
            devSn = relation.getSrcResourceProviderSn();
            resourceIds.add(relation.getSrcResourceId());
        }
        List vaultList = this.getHyperVaultService(devSn).queryHyperVaultListByResourceIds(devSn, new ArrayList(resourceIds));
        if (VerifyUtil.isEmpty((Collection)vaultList)) {
            logger.error((Object)("hyperVault is not existed!" + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073948242L);
        }
        return vaultList;
    }

    private List<ProtectionRelation> extractProtectionRelation(ProtectGroup protectGroup) {
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        Map props = policyTemplate.getProps();
        String prStr = (String)props.get("protectionRelation");
        logger.debug((Object)("param [protectionRelation] str:" + prStr));
        if (VerifyUtil.isEmpty((String)prStr)) {
            logger.error((Object)"Create hyper vault Relation failed! Because param [protectionRelation] is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        List protectionRelationList = ProtectionRelationJsonConverter.toProtectionRelationList((String)prStr);
        return protectionRelationList;
    }
}

