/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.realtime;

import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.impl.AbstractReplicaRealTimeBuilder;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayHyperVaultBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperVaultRealTimeBuilder
extends AbstractReplicaRealTimeBuilder {
    protected static final String PROTECTION_RELATION_KEY = "protectionRelation";
    protected static final String DEVICE_SN_PREFIX = "DEVICE_SN_LOCATION_";
    protected static final String HYPER_VAULT_KEY = "HYPER_VAULT";
    protected static final String PROTECT_GROUP = "PROTECT_GROUP";
    private static final Log logger = LogFactory.getInstance(ArrayHyperVaultBuilder.class);

    public ProtectGroupReplica buildReplica(ProtectGroup protectGroup, int protectLocation) {
        this.check(protectGroup, protectLocation);
        ExecutionContext context = this.initData(protectGroup);
        return this.buildProtectGroupReplica(context, protectLocation);
    }

    public void callBackReplica(ProtectGroupReplica replica) {
        new ArrayHyperVaultBuilder().deleteSnapshots(replica);
    }

    public PolicyTemplateType.PolicyTemplateE getType() {
        return PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_VAULT;
    }

    protected void check(ProtectGroup protectGroup, int protectLocation) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (protectLocation != DrmEnumDefine.ProtectLocation.A_A.getValue() && protectLocation != DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            logger.error((Object)("protectLocation is not right!protectLocation:" + protectLocation));
            throw new LegoCheckedException(1073947393L);
        }
    }

    private ExecutionContext initData(ProtectGroup protectGroup) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute(PROTECT_GROUP, (Object)protectGroup);
        ProtectionRelation protectionRelation = this.extractProtectionRelation(protectGroup);
        if (protectionRelation == null) {
            logger.error((Object)"protectionRelation is null");
            throw new LegoCheckedException(1073947393L);
        }
        context.setAttribute(PROTECTION_RELATION_KEY, (Object)protectionRelation);
        HyperVault hyperVault = this.getHyperVaultService(protectionRelation.getSrcResourceProviderSn()).queryHyperVaultByResourceId(protectionRelation.getSrcResourceProviderSn(), protectionRelation.getSrcResourceId());
        if (hyperVault == null) {
            logger.error((Object)("hyperVault is not existed!" + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073948242L);
        }
        context.setAttribute(HYPER_VAULT_KEY, (Object)hyperVault);
        this.setDeviceSN(context, hyperVault);
        return context;
    }

    protected ProtectGroupReplica buildProtectGroupReplica(ExecutionContext context, int location) {
        logger.debug((Object)("buildProtectGroupReplica. location:" + location));
        ProtectGroup protectGroup = this.getPG(context);
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("SNAPSHOT-" + protectGroup.getName() + "-" + Calendar.getInstance().getTimeInMillis());
        protectGroupReplica.setType(3);
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(location);
        String srcDevSn = this.getSrcDevSN(context, location);
        String siteId = this.getSiteByArraySn(srcDevSn);
        protectGroupReplica.setRecoverySite(siteId);
        protectGroupReplica.setProductArray(srcDevSn);
        protectGroupReplica.setRecoveryArray(srcDevSn);
        protectGroup.getReplicaList().add(protectGroupReplica);
        this.buildProtectObjectReplica(context, protectGroupReplica);
        return protectGroupReplica;
    }

    private void buildProtectObjectReplica(ExecutionContext context, ProtectGroupReplica protectGroupReplica) {
        ProtectGroup protectGroup = this.getPG(context);
        long startTime = System.currentTimeMillis();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica poReplica = new ProtectObjectReplica();
            poReplica.setId(UUIDGenerator.getUUID());
            poReplica.setPoId(protectObject.getUuid());
            poReplica.setProtectObject(protectObject);
            poReplica.setPgReplica(protectGroupReplica);
            protectGroupReplica.getReplicas().add(poReplica);
            this.buildPoStorageInfoReplica(context, protectObject, poReplica);
        }
        logger.debug((Object)("build protectObject replica cost time:" + (System.currentTimeMillis() - startTime)));
    }

    private void buildPoStorageInfoReplica(ExecutionContext context, ProtectObject protectObject, ProtectObjectReplica poReplica) {
        Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty!" + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073948453L);
        }
        for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
            this.buildPoStorageInfoReplica(context, poStorageInfo, poReplica);
        }
    }

    protected void buildPoStorageInfoReplica(ExecutionContext context, ProtectObjectStorageInfo poStorageInfo, ProtectObjectReplica poReplica) {
        String resourceId = poStorageInfo.getResourceId();
        String resourceProviderSN = poStorageInfo.getResourceProviderSN();
        int protectLocation = poReplica.getPgReplica().getProtectLocation();
        if (protectLocation == DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT_KEY, HyperVault.class);
            resourceProviderSN = hyperVault.getRemoteDeviceSn();
            resourceId = hyperVault.getRemoteResourceId();
        }
        this.checkNasFileSystem(this.getPG(context), resourceId, resourceProviderSN);
        String snapshotName = PolicyTemplateTools.getInstance().generateSnapshotName(resourceId);
        String snapshotId = "NONE";
        this.buildHyperVaultReplica(poReplica, snapshotId, snapshotName, resourceId, resourceProviderSN, this.getPairId(context));
    }

    protected NasFileSystem checkNasFileSystem(ProtectGroup pg, String resourceId, String resourceProviderSN) {
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        ArrayList<String> resIds = new ArrayList<String>();
        resIds.add(resourceId);
        List nasFiles = srService.getStorageResources(resourceProviderSN, resIds, NasFileSystem.class);
        if (VerifyUtil.isEmpty((Collection)nasFiles)) {
            String errorMsg = "The nasFile query from DB is empty. Please try to refresh the device in site msg:" + this.getMsg(pg) + ", resIds : " + resIds + ", deviceSN:" + resourceProviderSN;
            logger.warn((Object)errorMsg);
            throw new LegoCheckedException(1073948685L, new String[]{resourceId, resourceProviderSN}, errorMsg);
        }
        return (NasFileSystem)nasFiles.get(0);
    }

    protected HyperVaultReplica buildHyperVaultReplica(ProtectObjectReplica poReplica, String snapshotId, String snapshotName, String resourceId, String resourceProviderSN, String vaultId) {
        logger.debug((Object)("resourceProviderSN:" + resourceProviderSN + ", resourceId:" + resourceId));
        HyperVaultReplica hyperVaultReplica = new HyperVaultReplica();
        hyperVaultReplica.setId(UUIDGenerator.getUUID());
        hyperVaultReplica.setSnapshotName(snapshotName);
        hyperVaultReplica.setSrcStorageId(resourceId);
        hyperVaultReplica.setSrcStorageProviderSN(resourceProviderSN);
        hyperVaultReplica.setStorageId(snapshotId);
        hyperVaultReplica.setStorageProviderSN(resourceProviderSN);
        hyperVaultReplica.setPoReplica(poReplica);
        hyperVaultReplica.setPairId(vaultId);
        poReplica.getStorageInfos().add(hyperVaultReplica);
        return hyperVaultReplica;
    }

    private String getPairId(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT_KEY, HyperVault.class);
        return hyperVault.getId();
    }

    private String getSrcDevSN(ExecutionContext context, int location) {
        return (String)context.getAttribute(DEVICE_SN_PREFIX + location, String.class);
    }

    protected ProtectGroup getPG(ExecutionContext context) {
        return (ProtectGroup)context.getAttribute(PROTECT_GROUP, ProtectGroup.class);
    }

    protected IStorageHyperVaultManager getHyperVaultService(String devSn) {
        StorageHyperVaultManagerProxy hyperVaultManagerProxy = StorageHyperVaultManagerProxy.getInstance();
        IStorageHyperVaultManager manager = hyperVaultManagerProxy.getMgrByDevId(devSn);
        if (manager == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return manager;
    }

    private ProtectionRelation extractProtectionRelation(ProtectGroup protectGroup) {
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        Map props = policyTemplate.getProps();
        String prStr = (String)props.get(PROTECTION_RELATION_KEY);
        logger.debug((Object)("param [protectionRelation] str:" + prStr));
        if (VerifyUtil.isEmpty((String)prStr)) {
            logger.error((Object)"Create hyper vault Relation failed! Because param [protectionRelation] is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionRelation protectionRelation = ProtectionRelationJsonConverter.toProtectionRelation((String)prStr);
        return protectionRelation;
    }

    protected void setDeviceSN(ExecutionContext context, HyperVault hyperVault) {
        logger.debug((Object)("DevSn:" + hyperVault.getDevSn() + ",RemoteDeviceSn:" + hyperVault.getRemoteDeviceSn()));
        context.setAttribute(DEVICE_SN_PREFIX + DrmEnumDefine.ProtectLocation.A_A.getValue(), (Object)hyperVault.getDevSn());
        context.setAttribute(DEVICE_SN_PREFIX + DrmEnumDefine.ProtectLocation.B_B.getValue(), (Object)hyperVault.getRemoteDeviceSn());
    }

    protected String getMsg(ProtectGroup protectGroup) {
        return " [pgName:" + protectGroup.getName() + ", pgId:" + protectGroup.getUuid() + "]";
    }
}

