/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractHyperMetroFilter
extends AbstractPolicyTemplateFilter {
    protected static final String IS_MULTI_HYPER_METRO_CG_KEY = "is_multi_hyper_metro_cg_key";
    protected static final String KEY_DEVICE_SN_SET = "DEVICE_SN_SET";
    protected static final String KEY_DEVICE_SITE_SET = "DEVICE_SITE_SET";
    protected static final String REMOTE_HYPER_METRA_SITE = "REMOTE_HYPER_METRA_SITE";
    protected static final String LOCAL_HYPER_METRA_SITE = "LOCAL_HYPER_METRA_SITE";
    protected static final String REMOTE_DEVICESN = "REMOTE_DEVICESN";
    protected static final String HYPERMETRO_VSTOREID = "HYPERMETRO_VSTOREID";
    protected static final String POLICY_TEMPLATE_KEY = "POLICY_TEMPLATE_KEY";
    private static final Log logger = LogFactory.getInstance(AbstractHyperMetroFilter.class);

    public void isMatchDoubleActivePolicy(PolicyTemplateContext context, Set<String> allWwn) {
        if (this.isNas(context)) {
            List protectObjectList = (List)context.getObject("PO_LIST");
            ProtectObject protectObject = (ProtectObject)protectObjectList.get(0);
            String deviceSn = this.getDevSnFromPo(protectObject);
            this.getSiteFromSn(deviceSn);
            VstoreHyperMetroPair vstoreHyperMetroPair = this.getVstoreHyperMetroPairFromPos(protectObjectList, deviceSn);
            this.checkPairHealthStatus(vstoreHyperMetroPair.getHealthStatus());
            this.checkNasHyperPair(context, allWwn, deviceSn, vstoreHyperMetroPair);
            this.checkRemoteVstoreInfo(context, deviceSn, vstoreHyperMetroPair.getRemoteVstoreId());
        } else {
            this.checkDevice(context, allWwn);
            this.checkPair(context, allWwn);
        }
        this.checkHyperMetroSite(context);
    }

    protected final String getDevSnFromPo(ProtectObject protectObject) {
        String deviceSn = this.getProtectObjectStorageInfo(protectObject).getResourceProviderSN();
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            logger.error((Object)"The device SNs does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        return deviceSn;
    }

    private VstoreHyperMetroPair getVstoreHyperMetroPairFromPos(List<ProtectObject> protectObjectList, String deviceSn) {
        String vStoreId = this.getVstoreFromPo(protectObjectList);
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstoreId(deviceSn, vStoreId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073948191L);
        }
        return vstoreHyperMetroPair;
    }

    protected void checkHyperMetroSite(PolicyTemplateContext context) {
        Set devSnSet = (Set)context.getObject(KEY_DEVICE_SN_SET);
        if (null == devSnSet) {
            logger.error((Object)"The device SNs does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> siteIdSet = new HashSet<String>();
        HashSet<String> serverIdSet = new HashSet<String>();
        for (String devSn : devSnSet) {
            Site site = this.getSiteFromSn(devSn);
            siteIdSet.add(site.getSiteId());
            serverIdSet.add(site.getServerUuid());
        }
        context.addObject(KEY_DEVICE_SITE_SET, siteIdSet);
        if (siteIdSet.size() != 2) {
            logger.error((Object)("The site of sites is not two! siteIdSet:" + this.getSetStr(siteIdSet)), 90160758786989L);
            throw new LegoCheckedException(1073948216L);
        }
        if (serverIdSet.size() != 1) {
            logger.error((Object)("The hypermetro array is not in the same BCManager! serverId:" + this.getSetStr(serverIdSet)), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkDevice(PolicyTemplateContext context, Set<String> allWwn) {
        List<Lun> resources = this.getStorageResource(allWwn, this.getRemoteSite(context));
        if (VerifyUtil.isEmpty(resources)) {
            logger.error((Object)("resources is empty! allwwn:" + this.getSetStr(allWwn)));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> devSnSet = this.getHyperMetroDeviceSN(context, resources);
        int wwnSize = allWwn.size() * 2;
        int resourceSize = resources.size();
        if (devSnSet.size() > 2 || resourceSize > wwnSize) {
            logger.error((Object)("the size of the devSnSet is not two! or size of resources is not eqauls to size of the allWwn. devSnSet:" + this.getSetStr(devSnSet) + ", wwnSize:" + wwnSize + ", resourceSize:" + resourceSize));
            throw new LegoCheckedException(1073948215L);
        }
        if (devSnSet.size() < 2 || resourceSize < wwnSize) {
            logger.error((Object)("the size of the devSnSet is less than two! or size of resources is less than the size of the allWwn. devSnSet:" + this.getSetStr(devSnSet) + ",allwwn:" + this.getSetStr(allWwn) + ", wwnSize:" + wwnSize + ", resourceSize:" + resourceSize));
            throw new LegoCheckedException(1073948191L);
        }
        context.addObject(KEY_DEVICE_SN_SET, devSnSet);
    }

    protected Set<String> getHyperMetroDeviceSN(PolicyTemplateContext context, List<Lun> resources) {
        HashSet<String> devSnSet = new HashSet<String>();
        for (StorageResource storageResource : resources) {
            String devSn = storageResource.getDevSn();
            if (VerifyUtil.isEmpty((String)devSn)) {
                logger.error((Object)("devSn is empty! storageResource:" + storageResource.getName() + ", id:" + storageResource.getResourceId() + ",devSnSet:" + this.getSetStr(devSnSet)));
                throw new LegoCheckedException(1073948191L);
            }
            devSnSet.add(devSn);
        }
        return devSnSet;
    }

    private Site getRemoteSite(PolicyTemplateContext context) {
        Site remoteSite = null;
        Object object = context.getObject(REMOTE_HYPER_METRA_SITE);
        if (object instanceof Site) {
            remoteSite = (Site)object;
        }
        return remoteSite;
    }

    private List<Lun> getStorageResource(Set<String> allWwnSet, Site remoteSite) {
        String serverId = null;
        if (remoteSite != null) {
            serverId = remoteSite.getServerUuid();
        }
        ArrayList<String> wwnList = new ArrayList<String>(allWwnSet);
        List lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(serverId, wwnList, Lun.class);
        return lunList;
    }

    private void checkPair(PolicyTemplateContext context, Set<String> allWwn) {
        List<HyperMetroPair> pairList;
        try {
            long startTime = System.currentTimeMillis();
            pairList = this.getHyperMetroPair(context, allWwn);
            logger.debug((Object)("checkPair getHyperMetroPair. cost time:" + (System.currentTimeMillis() - startTime)));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + allWwn + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        if (VerifyUtil.isEmpty(pairList) || pairList.size() != allWwn.size() * 2) {
            logger.error((Object)("pairList is null or the number of resource wwn is not equals of the number of pairs!" + this.getPairListStr(pairList) + ". all wwns:" + allWwn), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
        HashSet<String> consistentGroupIdSet = new HashSet<String>();
        boolean existConsistentGroup = false;
        boolean notExistConsistentGroup = false;
        List<ProtectObject> protectObjects = this.getProtectObjectList(context);
        boolean existProtectGroupReplica = this.existProtectGroupReplica(protectObjects);
        this.checkHyperMetroConsistentGroup(pairList, protectObjects);
        for (HyperMetroPair pair : pairList) {
            String healthStatus = pair.getHealthState();
            this.checkPairHealthStatus(healthStatus);
            if (!existProtectGroupReplica && this.shouldCheckHyperMetroRunningStatus() && !String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) {
                throw new LegoCheckedException(1073948223L);
            }
            String cgId = pair.getCgId();
            if (VerifyUtil.isEmpty((String)cgId) || "--".equals(cgId)) {
                notExistConsistentGroup = true;
            }
            if (notExistConsistentGroup && existConsistentGroup) {
                logger.error((Object)("The pair don't exist in the consistent group! consistentGroup[" + this.getSetStr(consistentGroupIdSet) + "]"));
                throw new LegoCheckedException(1073948246L);
            }
            if (VerifyUtil.isEmpty((String)cgId) || "--".equals(cgId)) continue;
            existConsistentGroup = true;
            consistentGroupIdSet.add(cgId);
        }
        this.checkConsistentGroup(context, pairList, consistentGroupIdSet);
        context.addObject("PAIR_LIST", pairList);
    }

    private void checkHyperMetroConsistentGroup(List<HyperMetroPair> pairList, List<ProtectObject> protectObjects) {
        List<Integer> templateOneRing = Arrays.asList(27, 26);
        if (!templateOneRing.contains(this.getType())) {
            return;
        }
        List<Integer> appTypeOneRing = Arrays.asList(DrmEnumDefine.AppType.ORACLE.getValue());
        int poType = protectObjects.get(0).getPoType();
        if (VerifyUtil.isEmpty(protectObjects) || appTypeOneRing.contains(poType)) {
            return;
        }
        HashSet<String> consistentGroupIdSet = new HashSet<String>();
        for (HyperMetroPair pair : pairList) {
            String cgId = pair.getCgId();
            if (VerifyUtil.isEmpty((String)cgId) || "--".equals(cgId)) continue;
            consistentGroupIdSet.add(cgId);
        }
        int consistentGroupIdSetNums = consistentGroupIdSet.size();
        int pairNums = pairList.size();
        if (consistentGroupIdSetNums > 1 && !this.isHyperMetroMultiCg() || consistentGroupIdSetNums == 0 && pairNums > 2) {
            logger.error((Object)"exist More than one consistent group! consistentGroupIdSetNums : %s , pairNums : %s", new Object[]{consistentGroupIdSetNums, pairNums});
            throw new LegoCheckedException(1073948246L);
        }
    }

    protected boolean shouldCheckHyperMetroRunningStatus() {
        return Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SYNC_REPLICATION.getValue()).contains(this.getType());
    }

    protected void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairList, Set<String> consistentGroupIdSet) {
        if (VerifyUtil.isEmpty(consistentGroupIdSet) && pairList.size() != 2) {
            logger.error((Object)("The pairs is not in the consistent group, but there are more than one pair! pair size:" + pairList.size()));
            throw new LegoCheckedException(1073948191L);
        }
        if (!VerifyUtil.isEmpty(consistentGroupIdSet) && consistentGroupIdSet.size() != 1) {
            logger.error((Object)("The pair don't exist in the consistent group! consistentGroup[" + this.getSetStr(consistentGroupIdSet) + "]"));
            throw new LegoCheckedException(1073948246L);
        }
        this.checkConsistentGroupHealthStatus(context, consistentGroupIdSet);
    }

    private String getVstoreFromPo(List<ProtectObject> protectObjects) {
        HashSet<String> vstoreIds = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            Set storageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)storageResourceSet)) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo info : storageResourceSet) {
                if (VerifyUtil.isEmpty((String)info.getVstoreId())) {
                    logger.error((Object)"The ProtectObjectStorageInfo vstoreId does not exist.");
                    throw new LegoCheckedException(1073948191L);
                }
                vstoreIds.add(info.getVstoreId());
            }
        }
        if (VerifyUtil.isEmpty(vstoreIds)) {
            logger.error((Object)"The ProtectObjectStorageInfo vstoreId does not exist.");
            throw new LegoCheckedException(1073948191L);
        }
        if (vstoreIds.size() > 1) {
            logger.error((Object)"The ProtectObjectStorageInfo vstoreId is more than one");
            throw new LegoCheckedException(1073948191L);
        }
        return (String)vstoreIds.iterator().next();
    }

    protected void checkRemoteVstoreInfo(PolicyTemplateContext context, String devSN, String remoteVstoreId) {
        Set devSnSet = (Set)context.getObject(KEY_DEVICE_SN_SET);
        String remoteDevSN = null;
        for (String sn : devSnSet) {
            if (devSN.equals(sn)) continue;
            remoteDevSN = sn;
            break;
        }
        if (VerifyUtil.isEmpty(remoteDevSN)) {
            logger.warn((Object)"remoteDevSn is empty!");
            throw new LegoCheckedException(1073948191L);
        }
        List vstoreNasList = StorageResourceServiceRouter.getInstance().getFileSystemByVstore(remoteDevSN, remoteVstoreId);
        List pairList = (List)context.getObject("PAIR_LIST");
        if (VerifyUtil.isEmpty((Collection)pairList) || pairList.size() != vstoreNasList.size()) {
            logger.error((Object)("pairList is null or the number of resource ids is not equals of the number of pairs!" + this.getPairListStr(pairList)), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkNasHyperPair(PolicyTemplateContext context, Set<String> allPoNasIds, String devSN, VstoreHyperMetroPair vstoreHyperMetroPair) {
        String vstoreId = vstoreHyperMetroPair.getLocalVstoreId();
        List<HyperMetroPair> pairList = this.getNasHyperMetroPairs(devSN, vstoreHyperMetroPair, vstoreId);
        List vstoreNasList = StorageResourceServiceRouter.getInstance().getFileSystemByVstore(devSN, vstoreId);
        HashSet<String> vstoreNasIds = new HashSet<String>();
        for (NasFileSystem nasFileSystem : vstoreNasList) {
            vstoreNasIds.add(nasFileSystem.getResourceId());
        }
        if (VerifyUtil.isEmpty(pairList) || pairList.size() != vstoreNasList.size()) {
            logger.error((Object)"pairList is null or the number of resource ids is not equals of the number of pairs! pairList: %s, ErrorMessage: %s", new Object[]{this.getPairListStr(pairList), 90160758786897L});
            throw new LegoCheckedException(1073948191L);
        }
        for (HyperMetroPair pair : pairList) {
            this.checkPairHealthStatus(pair.getHealthState());
            if (vstoreNasIds.contains(pair.getLocalObjId())) continue;
            logger.error((Object)"The pair don't exist Nas id : %s", new Object[]{pair.getLocalObjId()});
            throw new LegoCheckedException(1073948191L);
        }
        context.addObject("PAIR_LIST", pairList);
        this.getAllDevSn(context, allPoNasIds, vstoreHyperMetroPair, vstoreNasList);
    }

    protected List<HyperMetroPair> getNasHyperMetroPairs(String devSN, VstoreHyperMetroPair vstoreHyperMetroPair, String vstoreId) {
        List tempList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByVstore(devSN, vstoreId);
        if (VerifyUtil.isEmpty((Collection)tempList)) {
            logger.error((Object)"pairLis is empty", 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
        ArrayList<HyperMetroPair> pairList = new ArrayList<HyperMetroPair>();
        String vstorePairId = vstoreHyperMetroPair.getVstorePairId();
        for (HyperMetroPair pair : tempList) {
            if (!vstorePairId.equals(pair.getVstorePairId())) continue;
            pairList.add(pair);
        }
        return pairList;
    }

    protected void getAllDevSn(PolicyTemplateContext context, Set<String> allPoNasIds, VstoreHyperMetroPair vstoreHyperMetroPair, List<NasFileSystem> vstoreNasList) {
        HashSet<String> devSNSet = new HashSet<String>();
        for (String nasId : allPoNasIds) {
            NasFileSystem nasFileSystem = this.getNasfile(vstoreNasList, nasId);
            if (nasFileSystem == null) {
                logger.error((Object)("nas system file  in vstore is not equal protectObject files, nasFileId =" + nasId));
                throw new LegoCheckedException(1073948191L);
            }
            devSNSet.add(nasFileSystem.getDevSn());
        }
        Site remoteSite = this.getRemoteSite(context);
        String serverId = null;
        if (remoteSite != null) {
            serverId = remoteSite.getServerUuid();
        }
        List vstoreHyperMetroPairs = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(serverId, vstoreHyperMetroPair);
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit)) continue;
            devSNSet.add(((HvsUnit)managedObject).getDevSn());
        }
        context.addObject(KEY_DEVICE_SN_SET, devSNSet);
    }

    private NasFileSystem getNasfile(List<NasFileSystem> list, String nasId) {
        for (NasFileSystem nasFileSystem : list) {
            if (!nasId.equals(nasFileSystem.getResourceId())) continue;
            return nasFileSystem;
        }
        return null;
    }

    protected void checkConsistentGroupHealthStatus(PolicyTemplateContext context, Set<String> consistentGroupIdSet) {
        if (consistentGroupIdSet.size() != 1) {
            return;
        }
        String cgId = consistentGroupIdSet.iterator().next();
        Set deviceSnSet = (Set)context.getObject(KEY_DEVICE_SN_SET);
        if (null == deviceSnSet) {
            logger.error((Object)"The device SNs does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = deviceSnSet.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"The device SN does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        String deviceSn = (String)iterator.next();
        HyperMetroConsistentGroup cg = null;
        try {
            long startTime = System.currentTimeMillis();
            cg = StorageResourceServiceRouter.getInstance().getHyperMetroConsistentGroup(deviceSn, cgId, true);
            logger.debug((Object)("checkConsistentGroupHealthStatus getHyperMetroConsistentGroup. cost time:" + (System.currentTimeMillis() - startTime)));
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            String errMsg = "query HyperMetroConsistentGroup failed!deviceSn:" + deviceSn + ", cgId:" + cgId + ", errorCode:" + errorCode;
            this.rethrowException(e, errorCode, errMsg);
        }
        if (cg == null) {
            logger.error((Object)("cg is null! deviceSn:" + deviceSn + ", cgId:" + cgId));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkPairHealthStatus(cg.getHealthState());
    }

    private void rethrowException(LegoCheckedException e, long errorCode, String errMsg) {
        if (errorCode == 1073947393L || errorCode == -1L) {
            ExceptionUtil.rethrowException((Throwable)e, (String)errMsg, (long)1073948191L, (String[])e.getParameters(), (Log)logger);
        }
        logger.error((Object)errMsg);
        throw e;
    }

    private void checkPairHealthStatus(String healthStatus) {
        int status;
        if (VerifyUtil.isEmpty((String)healthStatus)) {
            logger.error((Object)"The healthStatus is null! ");
            throw new LegoCheckedException(1073948223L);
        }
        try {
            status = Integer.parseInt(healthStatus);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("The pair health status is not ok! healthPair status[" + healthStatus + "]."), 1073948223L);
            throw new LegoCheckedException(1073948223L, (Throwable)e);
        }
        if (XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue() != status) {
            logger.error((Object)("The pair health status is not ok! pair status[" + status + "]."), 1073948223L);
            throw new LegoCheckedException(1073948223L);
        }
    }

    private List<HyperMetroPair> getHyperMetroPair(PolicyTemplateContext context, Set<String> allWwn) {
        Object remoteSiteObj = context.getObject(REMOTE_HYPER_METRA_SITE);
        StorageResourceServiceRouter storageResourceService = StorageResourceServiceRouter.getInstance();
        ArrayList<String> wwnList = new ArrayList<String>(allWwn);
        String serverId = null;
        if (remoteSiteObj != null) {
            Site remoteSite = (Site)remoteSiteObj;
            serverId = remoteSite.getServerUuid();
        }
        return storageResourceService.getHyperMetroPairsByWwns(serverId, wwnList, null, true);
    }

    protected String getPairListStr(List<HyperMetroPair> pairList) {
        StringBuilder sb = new StringBuilder("pairList [ ");
        if (VerifyUtil.isEmpty(pairList)) {
            sb.append("empty.]");
            return sb.toString();
        }
        for (HyperMetroPair pair : pairList) {
            sb.append(this.getPairStr(pair));
        }
        return sb.toString();
    }

    private String getPairStr(HyperMetroPair pair) {
        StringBuilder sb = new StringBuilder();
        String uuid = pair.getUuid();
        String resourceWwn = pair.getResourceWwn();
        String localObjId = pair.getLocalObjId();
        String remoteObjId = pair.getRemoteObjId();
        sb.append("pairUuid:" + uuid).append(",").append("runningStatus:" + pair.getRunningState()).append(",").append("healthStatus:" + pair.getHealthState()).append(",").append("resourceWwn:" + resourceWwn).append(",").append("localObjId:" + localObjId).append(",").append("remoteObjId:" + remoteObjId).append(",").append("devSn:" + pair.getDevSn()).append("]");
        return sb.toString();
    }

    protected List<ProtectObject> getProtectObjectList(PolicyTemplateContext context) {
        List poList = (List)context.getObject("PO_LIST");
        if (null == poList) {
            logger.error((Object)"poList is null!");
            throw new LegoCheckedException(1073948191L);
        }
        return poList;
    }

    protected void checkMultiCgMatch(List<ProtectObject> protectObjectList) {
    }

    protected void cascadeFilterOperation(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
    }

    protected boolean existProtectGroupReplica(List<ProtectObject> protectObjects) {
        return !VerifyUtil.isEmpty(this.getProtectGroupReplicaList(protectObjects));
    }

    protected List<ProtectGroupReplica> getProtectGroupReplicaList(List<ProtectObject> protectObjects) {
        if (null != protectObjects && !protectObjects.isEmpty()) {
            ProtectObject protectObject = protectObjects.iterator().next();
            if (null == protectObject || null == protectObject.getProtectGroup()) {
                return Collections.emptyList();
            }
            ProtectGroup protectGroup = protectObject.getProtectGroup();
            if (null == protectGroup.getUuid()) {
                return Collections.emptyList();
            }
            IReplicaService repService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
            List pgReplicas = repService.queryProtectGroupReplicaByGroup(protectGroup.getUuid(), null, false);
            return pgReplicas;
        }
        return Collections.emptyList();
    }

    protected boolean isNas(ProtectObject po) {
        ProtectObjectStorageInfo protectObjectStorageInfo = this.getProtectObjectStorageInfo(po);
        Integer resourceType = protectObjectStorageInfo.getResourceType();
        return null != resourceType && resourceType.equals(DrmEnumDefine.ResourceTypeE.NAS.getValue());
    }

    private ProtectObjectStorageInfo getProtectObjectStorageInfo(ProtectObject po) {
        Set poStorageInfos = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)poStorageInfos)) {
            logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
            throw new LegoCheckedException(1073948453L);
        }
        return (ProtectObjectStorageInfo)poStorageInfos.iterator().next();
    }

    protected boolean isNas(PolicyTemplateContext context) {
        List protectObjectList = (List)context.getObject("PO_LIST");
        return this.isNas((ProtectObject)protectObjectList.get(0));
    }

    protected Set<String> getAllWwn(List<ProtectObject> protectObjects) {
        return this.getAllResourceIds(protectObjects);
    }

    protected Set<String> getAllResourceIds(List<ProtectObject> protectObjects) {
        HashSet<String> resourceIds = new HashSet<String>();
        boolean isNas = this.isNas(protectObjects.get(0));
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String resourceId = isNas ? posi.getResourceId() : posi.getLunWWN();
                if (VerifyUtil.isEmpty((String)resourceId)) {
                    logger.error((Object)("lunWWN or fileSystemId is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                    throw new LegoCheckedException(1073948453L);
                }
                if (resourceIds.contains(resourceId)) continue;
                resourceIds.add(resourceId);
            }
        }
        return resourceIds;
    }

    protected List<StorageResource> getNasStorageResource(PolicyTemplateContext context) {
        ArrayList allStorageResources = null;
        HashSet set = new HashSet();
        List pairList = (List)context.getObject("PAIR_LIST");
        HashSet<String> srcResourceIds = new HashSet<String>();
        HashSet<String> remoteResourceIds = new HashSet<String>();
        for (HyperMetroPair pair : pairList) {
            srcResourceIds.add(pair.getLocalObjId());
            remoteResourceIds.add(pair.getRemoteObjId());
        }
        String srcDevSn = ((HyperMetroPair)pairList.iterator().next()).getDevSn();
        set.addAll(StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(srcDevSn, new ArrayList(srcResourceIds), NasFileSystem.class));
        Set devSnSet = (Set)context.getObject(KEY_DEVICE_SN_SET);
        String remoteDevSN = null;
        for (String sn : devSnSet) {
            if (srcDevSn.equals(sn)) continue;
            remoteDevSN = sn;
            break;
        }
        if (null != remoteDevSN) {
            set.addAll(StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(remoteDevSN, new ArrayList(remoteResourceIds), NasFileSystem.class));
        }
        if (!set.isEmpty()) {
            allStorageResources = new ArrayList();
            allStorageResources.addAll(set);
        }
        return allStorageResources;
    }

    protected void checkAsyncHyperMetro(PolicyTemplateContext context, Set<String> allWwnSet) {
        Object snObj = context.getObject(REMOTE_DEVICESN);
        Object vStoreIdObj = context.getObject(HYPERMETRO_VSTOREID);
        if (null == snObj || null == vStoreIdObj) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073948191L);
        }
        String deviceSn = (String)snObj;
        String vStoreId = (String)vStoreIdObj;
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstoreId(deviceSn, vStoreId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073948191L);
        }
        Object policyTemplateObject = context.getObject(POLICY_TEMPLATE_KEY);
        if (null != policyTemplateObject && policyTemplateObject instanceof PolicyTemplate) {
            PolicyTemplate policyTemplate = (PolicyTemplate)policyTemplateObject;
            Map map = policyTemplate.getProps();
            map.put("PROP_KEY_VSTORE_PAIR_ID", vstoreHyperMetroPair.getVstorePairId());
        }
        this.checkPairHealthStatus(vstoreHyperMetroPair.getHealthStatus());
        this.checkNasHyperPair(context, allWwnSet, deviceSn, vstoreHyperMetroPair);
        this.checkRemoteVstoreInfo(context, deviceSn, vstoreHyperMetroPair.getRemoteVstoreId());
        this.checkHyperMetroSite(context);
    }

    protected boolean isHyperMetroMultiCg() {
        Map filterContext = this.getFilterContext();
        if (VerifyUtil.isEmpty((Map)filterContext)) {
            return false;
        }
        return Boolean.TRUE.equals(filterContext.get(IS_MULTI_HYPER_METRO_CG_KEY));
    }
}

