/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class HyperDRRingPathUtil {
    public static final String REPLICATION_PAIR_STANDBY_STATUS = "110";
    private static final Log logger = LogFactory.getInstance(HyperDRRingPathUtil.class);

    public static ReplicationPair getTarReplicationPair(List<ReplicationPair> pairs, boolean isStanBy) {
        if (VerifyUtil.isEmpty(pairs)) {
            logger.error((Object)"pair is empty");
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryProcessHandler recoveryProcHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        for (ReplicationPair replicationPair : pairs) {
            List repTgtLuns = recoveryProcHandler.querySyncStatus(replicationPair.getDevSn(), replicationPair.getSrcDevSN(), replicationPair.getReplicationId(), false);
            if (!VerifyUtil.isEmpty((Collection)repTgtLuns)) {
                ReplicationTargetLun repTgtLun = (ReplicationTargetLun)repTgtLuns.iterator().next();
                if (REPLICATION_PAIR_STANDBY_STATUS.equals(repTgtLun.getRunningState()) && isStanBy) {
                    return replicationPair;
                }
                if (REPLICATION_PAIR_STANDBY_STATUS.equals(repTgtLun.getRunningState()) || isStanBy) continue;
                return replicationPair;
            }
            logger.error((Object)("replicationTargetLun is empty , sn : " + replicationPair.getDevSn() + "id : " + replicationPair.getReplicationId()));
            ReplicationPair pair = HyperDRRingPathUtil.getPairByUuid(replicationPair.getUuid());
            if (REPLICATION_PAIR_STANDBY_STATUS.equals(pair.getRunningState()) && isStanBy) {
                return replicationPair;
            }
            if (REPLICATION_PAIR_STANDBY_STATUS.equals(pair.getRunningState()) || isStanBy) continue;
            return replicationPair;
        }
        logger.debug((Object)("getTarReplicationPair failed , is standby : " + isStanBy + " pairs :" + pairs));
        return null;
    }

    private static ReplicationPair getPairByUuid(String uuid) {
        ReplicationPair pair = (ReplicationPair)CommonDAOLocator.getBaseDao().getHibernateTemplate().get("from ReplicationPair as pair where pair.uuid = :uuid", (Serializable)((Object)uuid));
        if (VerifyUtil.isEmpty((Object)pair)) {
            logger.error((Object)("pair is null , uuid is :" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        return pair;
    }
}

