/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.ActiveSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActiveSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2987802729998264838L;
    private static final Log logger = LogFactory.getInstance(ActiveSnapshotProcessor.class);
    private Set<RecoveryProcessor> createSnapshotSubProcessors = new HashSet<RecoveryProcessor>();

    public ActiveSnapshotProcessor() {
        this.setIsNeedSave(false);
    }

    public Set<RecoveryProcessor> getCreateSnapshotSubProcessors() {
        return this.createSnapshotSubProcessors;
    }

    public void setCreateSnapshotSubProcessors(Set<RecoveryProcessor> createSnapshotSubProcessors) {
        this.createSnapshotSubProcessors = createSnapshotSubProcessors;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        Set<RecoveryProcessor> activeSnapshotSubProcessors = this.createActiveSnapshotSubProcessor(recoveryTasks, this.convertTo(this.getCreateSnapshotSubProcessors()));
        this.setChildProc(activeSnapshotSubProcessors);
        this.checkIfHasSubProcessor();
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(activeSnapshotSubProcessors));
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProtectGroupId(String key, Collection<RecoveryTask> recoveryTasks) {
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return "";
        }
        String pgId = "";
        for (RecoveryTask task : recoveryTasks) {
            Map lunAndPgMap = task.getLunAndPgMap();
            if (!lunAndPgMap.containsKey(key)) continue;
            List pgIds = (List)lunAndPgMap.get(key);
            if (VerifyUtil.isEmpty((Collection)pgIds)) {
                logger.info((Object)"There is no pgId data. Key: %s", new Object[]{key});
                continue;
            }
            for (String tmpPgId : pgIds) {
                if (VerifyUtil.isEmpty((String)tmpPgId)) continue;
                pgId = tmpPgId + ":" + task.getTgtDevcieId();
                break;
            }
            if (!VerifyUtil.isEmpty((String)pgId)) continue;
            logger.info((Object)"There is no pgId data. Key: %s, Data: %s", new Object[]{key, pgIds.toString()});
        }
        return pgId;
    }

    private Set<RecoveryProcessor> createActiveSnapshotSubProcessor(Collection<RecoveryTask> recoveryTasks, Set<CreateSnapshotSubProcessor> createSnapshotProcessors) {
        HashMap<String, ArrayList<String>> pgAndSnapshotsMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, String> pgAndDeviceIdMap = new HashMap<String, String>();
        for (CreateSnapshotSubProcessor subProcessor : createSnapshotProcessors) {
            String key = RecoveryProcessUtil.generateLunAndHostMapKey((String)subProcessor.getReplicationId(), (String)subProcessor.getSrcDeviceId(), (String)subProcessor.getSrcLunId(), (String)subProcessor.getDeviceId(), (String)subProcessor.getLunId());
            String pgId = this.getProtectGroupId(key, recoveryTasks);
            if (pgId.isEmpty()) {
                logger.error((Object)"Protect group id does not exist.Key: %s", new Object[]{key});
                continue;
            }
            pgAndDeviceIdMap.put(pgId, subProcessor.getDeviceId());
            ArrayList<String> snapshotIds = (ArrayList<String>)pgAndSnapshotsMap.get(pgId);
            if (VerifyUtil.isEmpty((Collection)snapshotIds)) {
                logger.info((Object)"There is no snapshot.PgId: %s", new Object[]{pgId});
                snapshotIds = new ArrayList<String>();
            }
            if (VerifyUtil.isEmpty((String)subProcessor.getSnapshotId()) || DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == subProcessor.getProcStatus()) {
                snapshotIds.add("");
            } else {
                snapshotIds.add(subProcessor.getSnapshotId());
            }
            pgAndSnapshotsMap.put(pgId, snapshotIds);
        }
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        Set entrySet = pgAndSnapshotsMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String pgIdKey = (String)entry.getKey();
            List snapshotIds = (List)entry.getValue();
            ActiveSnapshotSubProcessor activeSnapSubProcess = new ActiveSnapshotSubProcessor();
            activeSnapSubProcess.setPgId(RecoveryProcessUtil.getProtectGroupIdFromWrapper((String)pgIdKey));
            activeSnapSubProcess.setSnapshotIds(snapshotIds);
            activeSnapSubProcess.setDeviceId((String)pgAndDeviceIdMap.get(pgIdKey));
            activeSnapSubProcess.setProcName(activeSnapSubProcess.getName());
            activeSnapSubProcess.setProcType(this.getProcType());
            activeSnapSubProcess.setPlanId(this.getPlanId());
            activeSnapSubProcess.setProcessId(this.getProcessId());
            activeSnapSubProcess.setParentProc((RecoveryProcessor)this);
            activeSnapSubProcess.setProcId(null);
            activeSnapSubProcess.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            activeSnapSubProcess.setIsNeedCreateDetail(this.getIsNeedCreateDetail());
            processors.add((RecoveryProcessor)activeSnapSubProcess);
        }
        return processors;
    }

    private Set<CreateSnapshotSubProcessor> convertTo(Set<RecoveryProcessor> recoveryProcessors) {
        HashSet<CreateSnapshotSubProcessor> convertedProcessors = new HashSet<CreateSnapshotSubProcessor>();
        for (RecoveryProcessor processor : recoveryProcessors) {
            convertedProcessors.add((CreateSnapshotSubProcessor)processor);
        }
        return convertedProcessors;
    }
}

