/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageProtectGroupManagerProxy;
import com.huawei.ism.drm.storage.recovery.process.RemoveLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AddLunSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(RemoveLunSubProcessor.class);
    private String lunIds;
    private String groupId;
    private String devSn;

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start to add lun to group, devSn=%s, groupId=%s, lunIds:%s", new Object[]{this.devSn, this.groupId, this.lunIds});
        this.updateProcessNameParams(new String[]{this.lunIds, this.groupId});
        String[] lunIdArray = this.lunIds.split(",");
        List<String> lunIdList = Arrays.asList(lunIdArray);
        List lunList = lunIdList.stream().map(id -> {
            Lun lun = new Lun();
            lun.setLunId(id);
            lun.setDevSn(this.devSn);
            return lun;
        }).collect(Collectors.toList());
        try {
            StorageProtectGroupManagerProxy proxy = StorageProtectGroupManagerProxy.getInstance();
            proxy.addLuns(lunList, this.groupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Add luns to group failed, error msg: %s", new Object[]{e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        LOGGER.info((Object)"Add luns to group success.");
        return true;
    }

    public String getLunIds() {
        return this.lunIds;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public void setLunIds(String lunIds) {
        this.lunIds = lunIds;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }
}

