/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateLunSubProcessor;
import com.huawei.ism.drm.storage.sdk.service.SaveStorageResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CreateLunProcessor
extends BaseRecoveryProcessor
implements SaveStorageResource {
    private static final Log LOGGER = LogFactory.getInstance(CreateLunSubProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (!this.generateSubProcessor(context)) {
            LOGGER.error((Object)"Create subProcessors failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    public void endRecoveryProcessor() {
        Set childProcSet = Optional.ofNullable(this.getChildProc()).orElseGet(Collections::emptySet);
        this.saveStorageResource(this.getContextRef(), this.covertToStorageResource(childProcSet));
        super.endRecoveryProcessor();
    }

    private Set<StorageResource> covertToStorageResource(Set<RecoveryProcessor> childProcSet) {
        HashSet<StorageResource> resources = new HashSet<StorageResource>();
        for (RecoveryProcessor recoveryProcessor : childProcSet) {
            if (!(recoveryProcessor instanceof CreateLunSubProcessor)) continue;
            CreateLunSubProcessor lunSubProcessor = (CreateLunSubProcessor)recoveryProcessor;
            Lun createdLun = new Lun();
            createdLun.setDevSn(lunSubProcessor.getDeviceId());
            createdLun.setName(lunSubProcessor.getLunName());
            createdLun.setWwn(lunSubProcessor.getLunWwn());
            createdLun.setLunId(lunSubProcessor.getLunId());
            resources.add((StorageResource)createdLun);
        }
        return resources;
    }

    private boolean generateSubProcessor(RecoveryProcessorContext context) {
        Collection recoveryTask = context.getRecoveryTask("recoveryTasks");
        if (VerifyUtil.isEmpty((Collection)recoveryTask)) {
            LOGGER.error((Object)"No lun need to be created.");
            return false;
        }
        Map lunMap = (Map)context.getAttribute("lunToBeCreated", Map.class);
        if (recoveryTask.size() != lunMap.size()) {
            LOGGER.error((Object)"Some snapshots in the copy don't exist on the storage. recovery task size=%s, lun map size=%s", new Object[]{recoveryTask.size(), lunMap.size()});
            return false;
        }
        HashSet<CreateLunSubProcessor> createLunProcessors = new HashSet<CreateLunSubProcessor>();
        for (Lun lun : lunMap.values()) {
            CreateLunSubProcessor subProcessor = new CreateLunSubProcessor();
            subProcessor.setProcType(this.getProcType());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setDeviceId(lun.getDevSn());
            subProcessor.setLunCapacity(lun.getCapacity());
            subProcessor.setLunName(lun.getName());
            createLunProcessors.add(subProcessor);
        }
        this.setChildProc(createLunProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

