/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.AbstractRecoveryTaskInterceptor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CreateReplicationPreparer
extends AbstractRecoveryTaskInterceptor {
    private static final Log LOGGER = LogFactory.getInstance(CreateReplicationPreparer.class);

    public CreateReplicationPreparer(BaseRecoveryProcessor interceptTask) {
        super(interceptTask);
    }

    public boolean before() {
        Map snapshotMap;
        BaseRecoveryProcessor interceptedProcessor = this.getInterceptTask();
        RecoveryProcessorContext context = interceptedProcessor.getContextRef();
        Map createdLunMap = (Map)context.getAttribute("lunToBeCreated", Map.class);
        if (!this.checkSnapshotAndLun(createdLunMap, snapshotMap = (Map)context.getAttribute("recovery_snapshots", Map.class))) {
            return false;
        }
        List<RecoveryTask> recoveryTaskList = this.generateRemoteRecoveryTasks(createdLunMap, snapshotMap);
        context.setAttribute("remoteRecoveryTasks", recoveryTaskList);
        return true;
    }

    public boolean after() {
        BaseRecoveryProcessor interceptedProcessor = this.getInterceptTask();
        RecoveryProcessorContext context = interceptedProcessor.getContextRef();
        Set childProc = interceptedProcessor.getChildProc();
        if (VerifyUtil.isEmpty((Collection)childProc)) {
            LOGGER.warn((Object)"No createReplicationSubProcessor was found, recovery plan's name is %s.", new Object[]{context.getRecoveryPlan().getName()});
            return true;
        }
        Collection recoveryTasks = context.getRecoveryTask("remoteRecoveryTasks");
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.error((Object)"No new remote replication is found, recovery plan's name is %s.", new Object[]{context.getRecoveryPlan().getName()});
            return false;
        }
        return this.updateRecoveryTaskInfo(childProc, recoveryTasks);
    }

    private boolean checkSnapshotAndLun(Map<String, Lun> createdLunMap, Map<String, Snapshot> snapshotMap) {
        if (VerifyUtil.isEmpty(snapshotMap)) {
            LOGGER.error((Object)"No snapshot need to be recovered.");
            return false;
        }
        if (VerifyUtil.isEmpty(createdLunMap)) {
            LOGGER.error((Object)"No lun had been created.");
            return false;
        }
        String createdLunStr = createdLunMap.values().stream().map(ManagedObject::getName).collect(Collectors.joining(","));
        String recoverySnapshotStr = snapshotMap.values().stream().map(ManagedObject::getName).collect(Collectors.joining(","));
        if (createdLunMap.size() != snapshotMap.size()) {
            LOGGER.error((Object)"Snapshots exist and LUNs aren't created on the remote. created lun=%s, recovery snapshot=%s.", new Object[]{createdLunStr, recoverySnapshotStr});
            return false;
        }
        for (Map.Entry<String, Snapshot> entry : snapshotMap.entrySet()) {
            if (createdLunMap.containsKey(entry.getKey())) continue;
            LOGGER.error((Object)"Snapshots exist and LUNs aren't created on the remote. created lun=%s, recovery snapshot=%s.", new Object[]{createdLunStr, recoverySnapshotStr});
            return false;
        }
        return true;
    }

    private List<RecoveryTask> generateRemoteRecoveryTasks(Map<String, Lun> createdLunMap, Map<String, Snapshot> snapshotMap) {
        RecoveryProcessorContext context = this.getInterceptTask().getContextRef();
        String disasterSiteId = (String)context.getAttribute("PRODUCT_SITE_ID", String.class);
        String productSiteId = (String)context.getAttribute("DISASTER_SITE_ID", String.class);
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site productionSite = VerifyUtil.isEmpty((String)productSiteId) ? null : siteService.getSiteById(productSiteId);
        Site disasterSite = VerifyUtil.isEmpty((String)productSiteId) ? null : siteService.getSiteById(disasterSiteId);
        String planId = context.getRecoveryPlan().getPlanId();
        ArrayList<RecoveryTask> recoveryTaskList = new ArrayList<RecoveryTask>();
        for (Map.Entry<String, Snapshot> entry : snapshotMap.entrySet()) {
            String snapshotName = entry.getKey();
            Snapshot snapshot = entry.getValue();
            Lun createdLun = createdLunMap.get(snapshotName);
            RecoveryTask recoveryTask = new RecoveryTask();
            recoveryTask.setProductionSite(productionSite);
            recoveryTask.setDisasterSite(disasterSite);
            recoveryTask.setProtectType(ReplicationConstantDefine.ReplicationDescription.HYPER_MIRROR.getValue());
            recoveryTask.setRecoveryPlanId(planId);
            String srcDevSn = snapshot.getDevSn();
            String tgtDevSn = createdLun.getDevSn();
            String srcResourceId = snapshot.getSnapshotId();
            String tgtResourceId = createdLun.getLunId();
            recoveryTask.setProtectName(snapshotName);
            recoveryTask.setSrcDeviceId(srcDevSn);
            recoveryTask.setTgtDevcieId(tgtDevSn);
            recoveryTask.setSrcStorageIds(Collections.singleton(srcDevSn + ":" + srcResourceId));
            recoveryTask.setTgtStorageIds(Collections.singleton(tgtDevSn + ":" + tgtResourceId));
            recoveryTask.setSrcStorageWwns(Collections.singleton(snapshot.getWwn()));
            recoveryTaskList.add(recoveryTask);
        }
        return recoveryTaskList;
    }

    private boolean updateRecoveryTaskInfo(Set<RecoveryProcessor> childProc, Collection<RecoveryTask> recoveryTasks) {
        Map subProcessorMap = childProc.stream().filter(processor -> processor instanceof CreateReplicationSubProcessor).map(processor -> (CreateReplicationSubProcessor)((Object)processor)).collect(Collectors.toMap(CreateReplicationSubProcessor::getSrcResourceName, Function.identity()));
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String srcResourceName = recoveryTask.getProtectName();
            if (!subProcessorMap.containsKey(srcResourceName)) {
                LOGGER.error((Object)"The CreateReplicationSubProcessor of the primary resource(name:%s) is not found.", new Object[]{srcResourceName});
                continue;
            }
            CreateReplicationSubProcessor subProcessor = (CreateReplicationSubProcessor)((Object)subProcessorMap.get(srcResourceName));
            recoveryTask.setProtectId(subProcessor.getReplicationId());
        }
        return true;
    }
}

