/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class CreateReplicationProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(CreateReplicationProcessor.class);

    public String getRecoveryTasksKey() {
        return "remoteRecoveryTasks";
    }

    protected boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = context.getRecoveryTask(this.getRecoveryTasksKey());
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.warn((Object)"No replication need to be created because recovery task is empty.");
            return true;
        }
        Map snapshotMap = (Map)context.getAttribute("recovery_snapshots", Map.class);
        Map lunMap = (Map)context.getAttribute("lunToBeCreated", Map.class);
        if (VerifyUtil.isEmpty((Map)snapshotMap) || VerifyUtil.isEmpty((Map)lunMap)) {
            LOGGER.error((Object)"No recovery snapshots are found.");
            return false;
        }
        if (!this.generateSubProcessor(recoveryTasks, snapshotMap, lunMap)) {
            LOGGER.error((Object)"Create subProcessors failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(Collection<RecoveryTask> recoveryTasks, Map<String, Snapshot> snapshotMap, Map<String, Lun> lunMap) {
        HashSet<CreateReplicationSubProcessor> subProcessorSet = new HashSet<CreateReplicationSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String srcResourceName = recoveryTask.getProtectName();
            if (!snapshotMap.containsKey(srcResourceName) || !lunMap.containsKey(srcResourceName)) {
                LOGGER.error((Object)"The corresponding snapshot and LUN resources are not found for %s.", new Object[]{srcResourceName});
                throw new LegoCheckedException(100664710L);
            }
            CreateReplicationSubProcessor subProcessor = new CreateReplicationSubProcessor();
            subProcessor.setProcName(((Object)((Object)this)).getClass().getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setSrcDevSn(recoveryTask.getSrcDeviceId());
            subProcessor.setTargetDevSn(recoveryTask.getTgtDevcieId());
            subProcessor.setReplicationMode(recoveryTask.getProtectType());
            subProcessor.setSrcResourceType(XveMOType.LUN.getValue());
            Snapshot snapshot = snapshotMap.get(srcResourceName);
            Lun lun = lunMap.get(srcResourceName);
            subProcessor.setSrcResourceId(snapshot.getSnapshotId());
            subProcessor.setRemoteResourceId(lun.getLunId());
            subProcessor.setSrcResourceName(snapshot.getName());
            subProcessor.setRemoteResourceName(lun.getName());
            subProcessorSet.add(subProcessor);
        }
        this.setChildProc(subProcessorSet);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

