/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.DeleteLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeleteLunProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteLunProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Execute delete native lun processor");
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Delete lun failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        Set<RecoveryProcessor> subProcessors = this.generateSubProcessor(context);
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(subProcessors);
        } else {
            this.setChildProc(subProcessors);
        }
        if (!((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this)) {
            LOGGER.error((Object)"Generate delete lun failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.info((Object)"No lun needs to deleted, execute successfully.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        return this.executeSubProcessor(context);
    }

    protected Set<RecoveryProcessor> generateSubProcessor(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> delLunProcessors = new HashSet<RecoveryProcessor>();
        Map lunMap = (Map)context.getAttribute("lunToBeCreated", Map.class);
        if (VerifyUtil.isEmpty((Map)lunMap)) {
            LOGGER.info((Object)"No lun need to be deleted.");
            return delLunProcessors;
        }
        for (Lun lun : lunMap.values()) {
            DeleteLunSubProcessor subProcessor = new DeleteLunSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setDeviceId(lun.getDevSn());
            subProcessor.setLunId(lun.getLunId());
            subProcessor.setLunName(lun.getName());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setIsNeedSave(this.getIsNeedSave());
            subProcessor.setIsNeedCreateDetail(this.getIsNeedCreateDetail());
            delLunProcessors.add((RecoveryProcessor)subProcessor);
        }
        return delLunProcessors;
    }
}

