/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.DeleteProtectionGroupSubProcessor;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DeleteProtectionGroupProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteProtectionGroupProcessor.class);
    private String name;
    private String nameParam;
    private List<HvsProtectionGroup> deletedProtectionGroups;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateCustomProcessName();
        Collection recoveryTasks = context.getRecoveryTask(this.getRecoveryTasksKey());
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.warn((Object)"Empty recoveryTasks.");
            return this.success();
        }
        if (!this.generateSubProcessor(recoveryTasks)) {
            LOGGER.error((Object)"Failed to generate subProcessor.");
            return this.failure();
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(Collection<RecoveryTask> recoveryTasks) {
        HashSet<DeleteProtectionGroupSubProcessor> childProcessors = new HashSet<DeleteProtectionGroupSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String pgId = String.valueOf(recoveryTask.getParams().get("PROTECTION_GROUP_ID"));
            String srcDevSn = recoveryTask.getSrcDeviceId();
            VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, pgId});
            DeleteProtectionGroupSubProcessor deletePgSubProcessor = new DeleteProtectionGroupSubProcessor();
            deletePgSubProcessor.setProcType(this.getProcType());
            deletePgSubProcessor.setPlanId(this.getPlanId());
            deletePgSubProcessor.setProcessId(this.getProcessId());
            deletePgSubProcessor.setParentProc((RecoveryProcessor)this);
            deletePgSubProcessor.setGroupId(pgId);
            deletePgSubProcessor.setDevSn(srcDevSn);
            childProcessors.add(deletePgSubProcessor);
        }
        return this.saveSubProcessors(childProcessors);
    }

    public void endRecoveryProcessor() {
        super.endRecoveryProcessor();
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            Set childProc = Optional.ofNullable(this.getChildProc()).orElseGet(Collections::emptySet);
            ArrayList<HvsProtectionGroup> deletedPgs = new ArrayList<HvsProtectionGroup>();
            for (RecoveryProcessor recoveryProcessor : childProc) {
                if (!(recoveryProcessor instanceof DeleteProtectionGroupSubProcessor)) continue;
                DeleteProtectionGroupSubProcessor deletePgSubProcessor = (DeleteProtectionGroupSubProcessor)((Object)CastUtil.castTo((Object)recoveryProcessor, DeleteProtectionGroupSubProcessor.class));
                deletePgSubProcessor.getDeletedProtectionGroup().ifPresent(deletedPgs::add);
            }
            this.setDeletedProtectionGroups(deletedPgs);
        }
    }

    private void updateCustomProcessName() {
        String customName = this.getProperty("CUSTOM_NAME");
        String customNamesParam = Optional.ofNullable(this.getProperty("CUSTOM_NAME_PARAM")).orElse("");
        if (!VerifyUtil.isEmpty((String)customName)) {
            this.updateProcessName(customName);
            this.updateProcessNameParams(customNamesParam.split(";", -1));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameParam(String nameParam) {
        this.nameParam = nameParam;
    }

    public void setDeletedProtectionGroups(List<HvsProtectionGroup> deletedProtectionGroups) {
        this.deletedProtectionGroups = deletedProtectionGroups;
    }

    public String getName() {
        return this.name;
    }

    public String getNameParam() {
        return this.nameParam;
    }

    public List<HvsProtectionGroup> getDeletedProtectionGroups() {
        return this.deletedProtectionGroups;
    }
}

