/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageProtectGroupManagerProxy;
import com.huawei.ism.drm.util.ErrorCodeUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteProtectionGroupSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteProtectionGroupSubProcessor.class);
    private static final String DELETED_SUFFIX = ".deleted";
    private static final String FAILED_SUFFIX = ".failed";
    private String devSn;
    private String vStoreId;
    private String groupId;
    private String protectionGroupJson;

    public void beforeExecRecoveryProcessor() {
        super.beforeExecRecoveryProcessor();
        this.setGroupId(this.getProperty("PG_ID"));
        this.setDevSn(this.getProperty("DEV_SN"));
        this.setVStoreId(this.getProperty("VSTORE_ID"));
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDevSn(), this.getGroupId()});
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            return this.success(this.getName() + DELETED_SUFFIX, null);
        }
        return this.deleteProtectionGroup();
    }

    private boolean deleteProtectionGroup() {
        StorageProtectGroupManagerProxy groupManager = StorageProtectGroupManagerProxy.getInstance();
        HvsProtectionGroup tempPg = new HvsProtectionGroup();
        tempPg.setDevSn(this.getDevSn());
        tempPg.setProtectGroupId(this.getGroupId());
        tempPg.setVstoreId(this.getVStoreId());
        Optional protectionGroup = groupManager.queryProtectionGroup(tempPg);
        if (!protectionGroup.isPresent() || VerifyUtil.isEmpty((String)((HvsProtectionGroup)protectionGroup.get()).getProtectGroupId())) {
            LOGGER.info((Object)"Replication group not found: cgId=%s, devSn=%s, vStoreId=%s", new Object[]{this.getGroupId(), this.getDevSn(), this.getVStoreId()});
            return this.success(this.getName() + DELETED_SUFFIX, null);
        }
        try {
            ((HvsProtectionGroup)protectionGroup.get()).setDevSn(this.getDevSn());
            Set ignoreFields = Arrays.stream(ManagedObject.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
            this.setProtectionGroupJson(JSONObject.fromObject(protectionGroup.get(), ignoreFields).toString());
            IRecoveryProcessBaseService processBaseService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            processBaseService.updateRecoveryProcessor((RecoveryProcessor)this);
            groupManager.deleteProtectGroup((HvsProtectionGroup)protectionGroup.get());
            LOGGER.info((Object)"Protection group deleted: pgId=%s, devSn=%s", new Object[]{this.getGroupId(), this.getDevSn()});
            return this.success();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1086545666L) {
                LOGGER.info((Object)"Protection group not exist:%s", new Object[]{((HvsProtectionGroup)protectionGroup.get()).getProtectGroupName()});
                return this.success(this.getName() + DELETED_SUFFIX, null);
            }
            LOGGER.error((Object)"Failed to delete Protection group: pgId=%s, devSn=%s", new Object[]{this.getGroupId(), this.getDevSn()});
            if (ErrorCodeUtil.isErrorCodeHasI18n((long)e.getErrorCode())) {
                this.updateProcessDetail(e);
            } else {
                this.updateProcessDetail(this.getName() + FAILED_SUFFIX, null);
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
    }

    public Optional<HvsProtectionGroup> getDeletedProtectionGroup() {
        if (VerifyUtil.isEmpty((String)this.getProtectionGroupJson())) {
            LOGGER.warn((Object)"Protection group data is empty.");
            return Optional.empty();
        }
        return Optional.ofNullable(JSONObject.toBean((String)this.getProtectionGroupJson(), HvsProtectionGroup.class));
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getVStoreId() {
        return this.vStoreId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getProtectionGroupJson() {
        return this.protectionGroupJson;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setVStoreId(String vStoreId) {
        this.vStoreId = vStoreId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setProtectionGroupJson(String protectionGroupJson) {
        this.protectionGroupJson = protectionGroupJson;
    }
}

