/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationGroupSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteReplicationGroupProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteReplicationGroupProcessor.class);
    private String name;
    private String nameParam;
    private List<ReplicationGroup> deletedReplicationGroups;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateCustomProcessName();
        if (!this.generateSubProcessor()) {
            LOGGER.error((Object)"Failed to generate subProcessor.");
            return this.failure();
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return true;
        }
        String recoveryTaskId = (String)this.getProps().get(this.getRecoveryTasksKey());
        String taskJson = (String)this.getProps().get(recoveryTaskId);
        JSONArray jsonArray = JSONArray.fromObject((Object)taskJson);
        ArrayList<RecoveryTask> recoveryTasks = new ArrayList<RecoveryTask>();
        for (Object jsonTask : jsonArray) {
            RecoveryTask recoveryTask = (RecoveryTask)JSONObject.fromObject(jsonTask).toBean(RecoveryTask.class);
            recoveryTasks.add(recoveryTask);
        }
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            LOGGER.warn((Object)"Empty recoveryTasks.");
            return this.success();
        }
        HashSet<DeleteReplicationGroupSubProcessor> childProcessors = new HashSet<DeleteReplicationGroupSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String cgId = recoveryTask.getConsistentGroupId();
            String srcDevSn = recoveryTask.getSrcDeviceId();
            String tgtDevcieSn = recoveryTask.getTgtDevcieId();
            VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, cgId});
            DeleteReplicationGroupSubProcessor deleteCgSubProcessor = new DeleteReplicationGroupSubProcessor();
            deleteCgSubProcessor.setProcType(this.getProcType());
            deleteCgSubProcessor.setPlanId(this.getPlanId());
            deleteCgSubProcessor.setProcessId(this.getProcessId());
            deleteCgSubProcessor.setParentProc((RecoveryProcessor)this);
            deleteCgSubProcessor.setProperty("REP_CG_ID", cgId);
            deleteCgSubProcessor.setProperty("SRC_DEV_SN", srcDevSn);
            deleteCgSubProcessor.setProperty("TGT_DEV_SN", tgtDevcieSn);
            this.initReplicationGroupJsonParam(srcDevSn, cgId, deleteCgSubProcessor);
            childProcessors.add(deleteCgSubProcessor);
        }
        return this.saveSubProcessors(childProcessors);
    }

    private void initReplicationGroupJsonParam(String devSn, String groupId, DeleteReplicationGroupSubProcessor subProcessor) {
        StorageReplicationManagerProxy repManagerProxy = StorageReplicationManagerProxy.getInstance();
        ReplicationGroup repCg = repManagerProxy.getReplicationGroup(devSn, groupId);
        Set ignoreFields = Arrays.stream(ManagedObject.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
        subProcessor.setReplicationGroupJson(JSONObject.fromObject((Object)repCg, ignoreFields).toString());
    }

    public void endRecoveryProcessor() {
        super.endRecoveryProcessor();
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            Set childProc = Optional.ofNullable(this.getChildProc()).orElseGet(Collections::emptySet);
            ArrayList<ReplicationGroup> deletedRepCgs = new ArrayList<ReplicationGroup>();
            for (RecoveryProcessor recoveryProcessor : childProc) {
                if (!(recoveryProcessor instanceof DeleteReplicationGroupSubProcessor)) continue;
                DeleteReplicationGroupSubProcessor deleteCgSubProcessor = (DeleteReplicationGroupSubProcessor)((Object)CastUtil.castTo((Object)recoveryProcessor, DeleteReplicationGroupSubProcessor.class));
                deleteCgSubProcessor.getDeletedReplicationGroup().ifPresent(deletedRepCgs::add);
            }
            this.setDeletedReplicationGroups(deletedRepCgs);
        }
    }

    private void updateCustomProcessName() {
        String customName = this.getProperty("CUSTOM_NAME");
        String customNamesParam = Optional.ofNullable(this.getProperty("CUSTOM_NAME_PARAM")).orElse("");
        if (!VerifyUtil.isEmpty((String)customName)) {
            this.updateProcessName(customName);
            this.updateProcessNameParams(customNamesParam.split(";", -1));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameParam(String nameParam) {
        this.nameParam = nameParam;
    }

    public void setDeletedReplicationGroups(List<ReplicationGroup> deletedReplicationGroups) {
        this.deletedReplicationGroups = deletedReplicationGroups;
    }

    public String getName() {
        return this.name;
    }

    public String getNameParam() {
        return this.nameParam;
    }

    public List<ReplicationGroup> getDeletedReplicationGroups() {
        return this.deletedReplicationGroups;
    }
}

