/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.util.ErrorCodeUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteReplicationGroupSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteReplicationGroupSubProcessor.class);
    private static final String DELETED_SUFFIX = ".deleted";
    private static final String FAILED_SUFFIX = ".failed";
    private String devSn;
    private String tgtDevSn;
    private String groupId;
    private String replicationGroupJson;

    public void beforeExecRecoveryProcessor() {
        super.beforeExecRecoveryProcessor();
        this.setGroupId(this.getProperty("REP_CG_ID"));
        this.setDevSn(this.getProperty("SRC_DEV_SN"));
        this.setTgtDevSn(this.getProperty("TGT_DEV_SN"));
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDevSn(), this.getTgtDevSn(), this.getGroupId()});
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            return this.success(this.getName() + DELETED_SUFFIX, null);
        }
        return this.deleteReplicationGroup();
    }

    private boolean deleteReplicationGroup() {
        StorageReplicationManagerProxy repManagerProxy = StorageReplicationManagerProxy.getInstance();
        ReplicationGroup repCg = repManagerProxy.getReplicationGroup(this.getDevSn(), this.getGroupId());
        if (VerifyUtil.isEmpty((Object)repCg)) {
            LOGGER.info((Object)"Replication group not found: cgId=%s, devSn=%s", new Object[]{this.getGroupId(), this.getDevSn()});
            return this.success(this.getName() + DELETED_SUFFIX, null);
        }
        repCg.setTgtDevSN(this.tgtDevSn);
        try {
            Set ignoreFields = Arrays.stream(ManagedObject.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
            this.setReplicationGroupJson(JSONObject.fromObject((Object)repCg, ignoreFields).toString());
            IRecoveryProcessBaseService processBaseService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            processBaseService.updateRecoveryProcessor((RecoveryProcessor)this);
            repManagerProxy.deleteReplicationGroup(repCg);
            LOGGER.info((Object)"Replication group deleted: cgId=%s, devSn=%s", new Object[]{this.getGroupId(), this.getDevSn()});
            return this.success();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 0x40400704L || e.getErrorCode() == 1073749155L) {
                LOGGER.info((Object)"Replication group not exist:%s", new Object[]{repCg.getReplicationName()});
                return this.success(this.getName() + DELETED_SUFFIX, null);
            }
            LOGGER.error((Object)"Failed to delete replication group: cgId=%s, devSn=%s, error code=%s", new Object[]{this.getGroupId(), this.getDevSn(), e.getErrorCode()});
            if (ErrorCodeUtil.isErrorCodeHasI18n((long)e.getErrorCode())) {
                this.updateProcessDetail(e);
            } else {
                this.updateProcessDetail(this.getName() + FAILED_SUFFIX, null);
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
    }

    public Optional<ReplicationGroup> getDeletedReplicationGroup() {
        if (VerifyUtil.isEmpty((String)this.getReplicationGroupJson())) {
            LOGGER.warn((Object)"Replication group data is empty.");
            return Optional.empty();
        }
        return Optional.ofNullable(JSONObject.toBean((String)this.getReplicationGroupJson(), ReplicationGroup.class));
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getTgtDevSn() {
        return this.tgtDevSn;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getReplicationGroupJson() {
        return this.replicationGroupJson;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setTgtDevSn(String tgtDevSn) {
        this.tgtDevSn = tgtDevSn;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setReplicationGroupJson(String replicationGroupJson) {
        this.replicationGroupJson = replicationGroupJson;
    }
}

