/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCgCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCgCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotHandler;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5855850053623210145L;

    public boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List recoveryProcesses = null;
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, CreateSnapshotCgCopySubProcessor.class);
            if (null != recoveryProcesses && !recoveryProcesses.isEmpty()) {
                this.updateCgSubCopyProcessors(recoveryProcesses);
                this.checkIfHasSubProcessor();
            } else {
                recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, CreateSnapshotCopySubProcessor.class);
                if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
                    this.updateSubCopyProcessors(recoveryProcesses);
                    this.checkIfHasSubProcessor();
                }
            }
        } else {
            Class<? extends RecoveryProcessor> snapshotProcessor = this.getCreateSnapshotProcessorClass();
            recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, snapshotProcessor);
            if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
                this.updateSubProcessors(recoveryProcesses);
                this.checkIfHasSubProcessor();
            }
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        this.removeSnapshotCopyInfos(context);
        return this.calcProcessResultBySubProc();
    }

    private Class<? extends RecoveryProcessor> getCreateSnapshotProcessorClass() {
        String fullClassName = this.getProps().getOrDefault("createsnapshotprocessor", CreateSnapshotSubProcessor.class.getCanonicalName());
        try {
            Class<?> snapshotClass = Class.forName(fullClassName);
            if (RecoveryProcessor.class.isAssignableFrom(snapshotClass)) {
                return snapshotClass;
            }
        }
        catch (ClassNotFoundException e) {
            throw new LegoCheckedException(1073947393L);
        }
        throw new LegoCheckedException(1073947393L);
    }

    private void removeSnapshotCopyInfos(RecoveryProcessorContext context) {
        PolicyTemplate policyTemplate;
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null != protectGroup && null != (policyTemplate = protectGroup.getTemplate()) && 11 == protectGroup.getPoType() && 2 == policyTemplate.getType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            RecoveryProcessUtil.removeContextParamByKey((RecoveryProcessorContext)context, (String)"SnapshotCopyIds");
            RecoveryProcessUtil.removeContextParamByKey((RecoveryProcessorContext)context, (String)"SnapshotCopyWWNs");
        }
    }

    private boolean updateSubProcessors(List<RecoveryProcessor> recoveryProcesses) {
        if (null == recoveryProcesses || recoveryProcesses.isEmpty()) {
            return true;
        }
        HashSet<DeleteSnapshotSubProcessor> subProcessor = new HashSet<DeleteSnapshotSubProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            ICreateSnapshotHandler createSnapshotProcessor;
            String snapshotId;
            if (!(process instanceof ICreateSnapshotHandler) || VerifyUtil.isEmpty((String)(snapshotId = (createSnapshotProcessor = (ICreateSnapshotHandler)process).getSnapshotId()))) continue;
            DeleteSnapshotSubProcessor processor = new DeleteSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setLunId(createSnapshotProcessor.getLunId());
            processor.setLunName(createSnapshotProcessor.getLunName());
            processor.setDeviceId(createSnapshotProcessor.getDeviceId());
            processor.setSnapshotId(createSnapshotProcessor.getSnapshotId());
            processor.setSnapshotName(createSnapshotProcessor.getSnapshotName());
            subProcessor.add(processor);
        }
        this.setChildProc(subProcessor);
        IRecoveryProcessService planInterCalledService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        return planInterCalledService.updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean updateSubCopyProcessors(List<RecoveryProcessor> recoveryProcesses) {
        if (null == recoveryProcesses || recoveryProcesses.isEmpty()) {
            return true;
        }
        HashSet<DeleteSnapshotSubProcessor> subProcessor = new HashSet<DeleteSnapshotSubProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            CreateSnapshotCopySubProcessor createSnapshotProcessor = (CreateSnapshotCopySubProcessor)process;
            String snapshotId = createSnapshotProcessor.getSnapshotId();
            if (null == snapshotId || snapshotId.isEmpty()) continue;
            DeleteSnapshotSubProcessor processor = new DeleteSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setLunId(createSnapshotProcessor.getSrcSnapshotId());
            processor.setLunName(createSnapshotProcessor.getSnapshotName());
            processor.setDeviceId(createSnapshotProcessor.getDeviceId());
            processor.setSnapshotId(createSnapshotProcessor.getSnapshotId());
            processor.setSnapshotName(createSnapshotProcessor.getSnapshotName());
            subProcessor.add(processor);
        }
        this.setChildProc(subProcessor);
        IRecoveryProcessService planInterCalledService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        boolean result = planInterCalledService.updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected boolean updateCgSubCopyProcessors(List<RecoveryProcessor> recoveryProcesses) {
        if (null == recoveryProcesses || recoveryProcesses.isEmpty()) {
            return true;
        }
        HashSet<DeleteSnapshotCgCopySubProcessor> subProcessor = new HashSet<DeleteSnapshotCgCopySubProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            CreateSnapshotCgCopySubProcessor processor = (CreateSnapshotCgCopySubProcessor)process;
            DeleteSnapshotCgCopySubProcessor delProcessor = new DeleteSnapshotCgCopySubProcessor();
            delProcessor.setProcType(this.getProcType());
            delProcessor.setPlanId(this.getPlanId());
            delProcessor.setProcessId(this.getProcessId());
            delProcessor.setParentProc((RecoveryProcessor)this);
            delProcessor.setDeviceId(processor.getDeviceId());
            delProcessor.setCgGroupID(processor.getCgGroupID());
            delProcessor.setProtectType(processor.getProtectType());
            subProcessor.add(delProcessor);
        }
        this.setChildProc(subProcessor);
        IRecoveryProcessService planInterCalledService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        boolean result = planInterCalledService.updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (null == recoveryPlan) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            this.setProcName("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCopyProcessor");
        }
    }

    public void updateDescription() {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (!VerifyUtil.isEmpty((Object)recoveryPlan) && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCopyProcessor.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotProcessor.des");
        }
    }

    public String getStepPosition() {
        return "DeleteSnapshot";
    }
}

