/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.DeleteNasSnapshotSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class DeleteSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3005277581833059871L;
    private static final Log logger = LogFactory.getInstance(DeleteNasSnapshotSubProcessor.class);
    private String deviceId;
    private String lunId;
    private String lunName;
    private String snapshotId = null;
    private String snapshotName = null;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getSnapshotName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{this.getSnapshotName()});
            this.updateProcessDetail("ism.drm.recovery.snapshot.already.deleted", new String[]{this.getSnapshotName()});
            return true;
        }
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(this.getSnapshotId());
        arraySnapshot.setSnapshotName(this.getSnapshotName());
        long startTime = System.currentTimeMillis();
        OperationResult operationResult = proxy.deleteSnapshot(this.getDeviceId(), (Snapshot)arraySnapshot);
        logger.debug((Object)("delete nas Snapshot cost time:" + (System.currentTimeMillis() - startTime)));
        if (!operationResult.isSuccess()) {
            this.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getDeleteSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getLunId(), (String)this.getSnapshotId());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void updateProcessName() {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (null == recoveryPlan) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            this.setProcName("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCopySubProcessor");
        }
    }
}

