/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RemoveReplicationSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(RemoveReplicationSubProcessor.class);
    private String groupId;
    private String devSn;
    private String pairIds;

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start to remove pair from group, devSn=%s, groupId=%s, pairIds:%s", new Object[]{this.devSn, this.groupId, this.pairIds});
        this.updateProcessNameParams(new String[]{this.groupId, this.pairIds});
        String[] pairIdArray = this.pairIds.split(",");
        List<String> pairIdList = Arrays.asList(pairIdArray);
        List pairList = pairIdList.stream().map(id -> {
            ReplicationPair pair = new ReplicationPair();
            pair.setReplicationId(id);
            return pair;
        }).collect(Collectors.toList());
        ReplicationGroup group = new ReplicationGroup();
        group.setSrcDevSN(this.devSn);
        group.setReplicationId(this.groupId);
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            proxy.removeReplicationPair(group, pairList);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Remove pairs from group failed, error msg: %s", new Object[]{e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        LOGGER.info((Object)"Remove pairs from group success.");
        return true;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getPairIds() {
        return this.pairIds;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setPairIds(String pairIds) {
        this.pairIds = pairIds;
    }
}

