/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;

public class RollbackBackupSubProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(RollbackBackupSubProcessor.class);
    private static final long serialVersionUID = 4100324431551899508L;
    private String deviceId;
    private String lunId;
    private String imageId;
    private Map<String, String> lunRelationships;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public Map<String, String> getLunRelationships() {
        return this.lunRelationships;
    }

    public void setLunRelationships(Map<String, String> lunRelationships) {
        this.lunRelationships = lunRelationships;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getRollbackBackupResultKey((String)this.getDeviceId(), (String)this.getLunId(), (String)this.getImageId());
    }

    protected boolean execute(RecoveryProcessorContext context) {
        OperationResult result = this.restoreBackup(context);
        if (!result.isSuccess()) {
            logger.error((Object)("rollback backup failed, imageId:" + this.imageId));
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            logger.debug((Object)("rollback backup success. imageId:" + this.imageId));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private OperationResult restoreBackup(RecoveryProcessorContext context) {
        logger.debug((Object)("start roll back backup, imageId:" + this.imageId));
        IBackupManager manager = BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
        try {
            this.updateProcessNameParams(new String[]{this.imageId});
            String requestID = manager.restore(this.deviceId, this.imageId, this.lunRelationships);
            context.setAttribute("context_restore_request_id", (Object)requestID);
            return new OperationResult("Rollback", true, true, new String[0]);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("restore failed! deviceId:" + this.deviceId + " imageId" + this.imageId + " lunRelationships" + this.lunRelationships.toString()), (Throwable)ex);
            return new OperationResult("Rollback", true, false, String.valueOf(ex.getErrorCode()), ex.getParameters());
        }
    }
}

