/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperVaultJob;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.recovery.process.RollbackNasSnapshotSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class RollbackHyperVaultSubProcessor
extends RollbackNasSnapshotSubProcessor {
    private static final long serialVersionUID = 7868883137918887569L;
    private static final Log LOGGER = LogFactory.getInstance(RollbackHyperVaultSubProcessor.class);

    @Override
    protected OperationResult rollbackNasSnapshot(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getSnapshotId(), this.getSnapshotId()});
        IStorageHyperVaultManager fileSystemSnapshotManagerProxy = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
        OperationResult result = null;
        try {
            String jobId = fileSystemSnapshotManagerProxy.restoreHyperVaultCopy(this.getDeviceId(), this.getSnapshotId());
            if (VerifyUtil.isEmpty((String)jobId)) {
                LOGGER.error((Object)("The jobId is null,sn: " + this.getDeviceId() + "snapId:" + this.getSnapshotId()));
                result = new OperationResult("ism.drm.restore.hypervalut.operation", true, false, String.valueOf(1073948712L), new String[0]);
                return result;
            }
            int checkTimes = 240;
            int waitSenond = 15000;
            HyperVaultJob job = null;
            for (int n = 0; n <= checkTimes; ++n) {
                try {
                    job = fileSystemSnapshotManagerProxy.queryJob(this.getDeviceId(), jobId);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"query job error, deviceSN: %s, jobId: %s", new Object[]{this.getDeviceId(), jobId});
                    job = fileSystemSnapshotManagerProxy.queryJob(this.getSrcDeviceId(), jobId);
                }
                if (null == job) {
                    LOGGER.error((Object)("The job is null,sn: " + this.getDeviceId() + "jobId:" + jobId));
                    result = new OperationResult("ism.drm.restore.hypervalut.operation", true, false, String.valueOf(1073948712L), new String[0]);
                    return result;
                }
                if (!job.getRunningState().equals(String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.RUNNING.getValue())) && !job.getRunningState().equals(String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.RUNNING_CLEAN_DATA.getValue())) && !job.getRunningState().equals(String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.RUNNING_SYNC_DATA.getValue()))) break;
                CommonUtil.sleep((long)waitSenond);
            }
            result = this.checkHyperVaultJobProgress(job);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("rollback snapshot failed. DevSN:" + this.getDeviceId() + ",Id:" + this.getSnapshotId()), (Throwable)e, 90160758784001L);
            result = new OperationResult("ism.drm.restore.hypervalut.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)("rollback snapshot failed. DevSN:" + this.getDeviceId() + ",Id:" + this.getSnapshotId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            result = new OperationResult("ism.drm.restore.hypervalut.operation", true, false, String.valueOf(1073948712L), new String[0]);
        }
        return result;
    }

    private OperationResult checkHyperVaultJobProgress(HyperVaultJob job) {
        OperationResult result = null;
        switch (XveEuumDefineParent.RUNNING_STATUS_E.valueOf((int)NumberUtil.convertToInteger((Object)job.getRunningState()))) {
            case RUNNING: 
            case SUSPENDING: {
                result = new OperationResult("ism.drm.restore.hypervalut.operation", true, false, String.valueOf(1073947433L), new String[0]);
                break;
            }
            case CANCELLED: {
                result = new OperationResult("ism.drm.restore.hypervalut.operation", true, false, String.valueOf(1073948712L), new String[0]);
                break;
            }
            default: {
                result = new OperationResult("ism.drm.restore.hypervalut.operation", true, true, new String[]{this.getSnapshotId()});
            }
        }
        return result;
    }
}

