/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.RollbackSnapshotCgSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.RollbackSnapshotSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class RollbackSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6953148605984813426L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        int protectType = ((RecoveryTask)recoveryTasks.stream().findAny().get()).getProtectType();
        context.setAttribute("protectType", (Object)protectType);
        if (protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue() || protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) {
            this.updateCgGroupSubProcessors(recoveryTasks, protectType);
        } else {
            this.updateSubProcessors(recoveryTasks);
        }
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.rollback.snapshot", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        boolean result = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            result = false;
            RecoveryServiceUtil.setProtectGroupsInvalidByPlan((RecoveryPlan)context.getRecoveryPlan(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        }
        return result;
    }

    private void updateSubProcessors(Collection<RecoveryTask> recoveryTasks) {
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return;
        }
        if (this.getChildProc() != null) {
            this.getChildProc().clear();
        }
        HashSet<RollbackSnapshotSubProcessor> subProcessors = new HashSet<RollbackSnapshotSubProcessor>();
        for (RecoveryTask task : recoveryTasks) {
            RollbackSnapshotSubProcessor processor = new RollbackSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(task.getSrcDeviceId());
            if (null == task.getSrcStorageIds()) {
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = task.getSrcStorageIds().iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            processor.setLunId((String)iterator.next());
            processor.setSnapshotId(task.getProtectId());
            processor.setSnapshotName(task.getProtectName());
            subProcessors.add(processor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void updateCgGroupSubProcessors(Collection<RecoveryTask> recoveryTasks, int protectType) {
        HashSet<RollbackSnapshotCgSubProcessor> subProcessors = new HashSet<RollbackSnapshotCgSubProcessor>();
        HashSet<String> dupSet = new HashSet<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String srcDeviceId = recoveryTask.getSrcDeviceId();
            String consistentGroupId = recoveryTask.getConsistentGroupId();
            String dupKey = srcDeviceId + "-" + consistentGroupId;
            if (dupSet.contains(dupKey)) continue;
            RollbackSnapshotCgSubProcessor subProcessor = new RollbackSnapshotCgSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setDeviceId(srcDeviceId);
            subProcessor.setSrcCgGroupID(consistentGroupId);
            subProcessor.setProtectType(protectType);
            subProcessors.add(subProcessor);
            dupSet.add(dupKey);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    public String getStepPosition() {
        return "Rollback";
    }
}

