/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.BaseSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SanHyperVaultSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SwapReplicationProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SanHyperVaultSwapReplicationProcessor
extends SwapReplicationProcessor {
    private static final long serialVersionUID = 250866538991251169L;
    private boolean onlySplit = false;
    private boolean revertRep = false;

    public SanHyperVaultSwapReplicationProcessor() {
    }

    public SanHyperVaultSwapReplicationProcessor(boolean onlySplit, boolean revertRep) {
        this.setIsNeedSave(false);
        this.onlySplit = onlySplit;
        this.revertRep = revertRep;
    }

    @Override
    protected boolean updateSubProcessors(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (VerifyUtil.isEmpty((Object)replica)) {
            throw new LegoCheckedException(1073947393L);
        }
        String disasterSiteId = context.getDisasterSiteId();
        if (replica.isLocalStorageSnapshotReplica()) {
            List recoveryTasks = context.getObjects(this.getRecoveryTasksKey(), RecoveryTask.class);
            context.setDisasterSiteId(((RecoveryTask)CommonUtil.getFirstElement((Collection)recoveryTasks)).getDisasterSite().getSiteId());
        }
        boolean result = super.updateSubProcessors(context);
        context.setDisasterSiteId(disasterSiteId);
        this.filterSubProcessors(context);
        this.getChildProc().stream().filter(recoveryProcessor -> recoveryProcessor instanceof BaseSwapReplicationSubProcessor).map(recoveryProcessor -> (BaseSwapReplicationSubProcessor)((Object)recoveryProcessor)).forEach(this::revertReplicationSubProcessor);
        return result;
    }

    @Override
    public BaseSwapReplicationSubProcessor getSubProcessorInstance() {
        SanHyperVaultSwapReplicationSubProcessor swapReplicationSubProcessor = new SanHyperVaultSwapReplicationSubProcessor();
        swapReplicationSubProcessor.setOnlySplit(this.onlySplit);
        return swapReplicationSubProcessor;
    }

    private void revertReplicationSubProcessor(BaseSwapReplicationSubProcessor baseSwapReplicationSubProcessor) {
        if (!this.revertRep) {
            return;
        }
        String srcDeviceId = baseSwapReplicationSubProcessor.getSrcDeviceId();
        baseSwapReplicationSubProcessor.setSrcDeviceId(baseSwapReplicationSubProcessor.getTgtDeviceId());
        baseSwapReplicationSubProcessor.setTgtDeviceId(srcDeviceId);
    }

    private void filterSubProcessors(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType)) {
            return;
        }
        if (PolicyTemplateType.REP_4DC_CASCADE_POLICYTEMPLATE.contains(templateType) && !ProtectGroupUtil.isReProtected4dcPg((ProtectGroup)protectGroup)) {
            return;
        }
        if (PolicyTemplateType.REP_4DC_CONCURRENT_POLICYTEMPLATE.contains(templateType) && ProtectGroupUtil.isReProtected4dcPg((ProtectGroup)protectGroup)) {
            return;
        }
        String disasterSiteId = context.getDisasterSiteId();
        Set subProcessors = this.getChildProc().stream().filter(subProcessor -> subProcessor instanceof BaseSwapReplicationSubProcessor).map(subProcessor -> (BaseSwapReplicationSubProcessor)((Object)subProcessor)).filter(subProcessor -> disasterSiteId.equals(this.getSiteIdByDeviceSn(subProcessor.getTgtDeviceId())) || disasterSiteId.equals(this.getSiteIdByDeviceSn(subProcessor.getSrcDeviceId()))).collect(Collectors.toSet());
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

