/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;

public class SanHyperVaultSynchronizeReplicationProcessor
extends SynchronizeReplicationProcessor {
    private static final long serialVersionUID = -7425949818118813246L;

    public SanHyperVaultSynchronizeReplicationProcessor() {
        this.setRecoveryTasksKey("remoteRecoveryTasks");
    }

    @Override
    public String getName() {
        return SynchronizeReplicationProcessor.class.getName();
    }

    @Override
    protected void updateSubProcessors(Collection<RecoveryTask> recoveryTasks, RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.REP_4DC_CONCURRENT_POLICYTEMPLATE.contains(templateType) || ProtectGroupUtil.isReProtected4dcPg((ProtectGroup)protectGroup)) {
            super.updateSubProcessors(recoveryTasks, context);
            return;
        }
        String disasterSiteId = context.getDisasterSiteId();
        recoveryTasks.removeIf(recoveryTask -> !disasterSiteId.equals(this.getSiteIdByDeviceSn(recoveryTask.getTgtDevcieId())) && !disasterSiteId.equals(this.getSiteIdByDeviceSn(recoveryTask.getSrcDeviceId())));
        super.updateSubProcessors(recoveryTasks, ((RecoveryTask)CommonUtil.getFirstElement(recoveryTasks)).getDisasterSite().getSiteId());
    }
}

