/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.ProtectGroupExecuteStatusChecker;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationSubProcessor;
import com.huawei.ism.drm.util.RecoveryExtendUtil;
import com.huawei.ism.util.Pair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SynchronizeReplicationProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7425949818118813246L;
    private static final Log logger = LogFactory.getInstance(SynchronizeReplicationProcessor.class);
    private int policyTemplate = -1;
    private boolean hasReversed;
    private RecoveryProcessorContext context;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.initAttribute(context);
        this.context = context;
        boolean result = this.getExecResult(context);
        if (!result) {
            Optional opt = context.getProtectPortTask();
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            opt.ifPresent(task -> portUtil.consumeFailedAirGapTask(task, DrmEnumDefine.ExecTypeEnum.MANUAL.getType()));
        }
        return result;
    }

    private void initAttribute(RecoveryProcessorContext context) {
        this.policyTemplate = this.getPolicyTemplate(context);
        this.hasReversed = context.getHasReversedReplication();
    }

    private boolean getExecResult(RecoveryProcessorContext context) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            ProtectGroup protectGroup = this.getProtectGroup(context);
            ProtectGroupReplica replica = protectGroup.getReplicationReplicaByRecoverySiteId(context.getDisasterSiteId());
            if (replica == null) {
                logger.error((Object)"Test operate failed, cannot find replica related to recoverySite (siteId:%s) from protectGroup (pgName:%s,pgId:%s).", new Object[]{context.getDisasterSiteId(), protectGroup.getName(), protectGroup.getUuid()});
                throw new LegoCheckedException(1073947393L);
            }
            int templateType = protectGroup.getTemplate().getType();
            if (replica.getType() != 1 || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType)) {
                ProtectGroupExecuteStatusChecker checker = new ProtectGroupExecuteStatusChecker(protectGroup, (BaseRecoveryProcessor)this, context.getDisasterSiteId());
                return checker.startProcess();
            }
        }
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
        if (context.getProtectGroupReplica().isLocalStorageSnapshotReplica()) {
            this.updateSubProcessors((Collection<RecoveryTask>)recoveryTasks, context);
        } else {
            this.updateSubProcessors((Collection<RecoveryTask>)RecoveryTaskUtil.getRootRecoveryTasks((Collection)recoveryTasks), context.getDisasterSiteId());
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        return this.checkExecuteResult();
    }

    protected void updateSubProcessors(Collection<RecoveryTask> recoveryTasks, RecoveryProcessorContext context) {
        this.updateSubProcessors((Collection<RecoveryTask>)RecoveryTaskUtil.getRootRecoveryTasks(recoveryTasks), ((RecoveryTask)CommonUtil.getFirstElement(recoveryTasks)).getDisasterSite().getSiteId());
    }

    private boolean checkExecuteResult() {
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private ProtectGroup getProtectGroup(RecoveryProcessorContext context) {
        if (null == context.getRecoveryPlan() || null == context.getRecoveryPlan().getProtectGroups()) {
            logger.error((Object)"recoveryPlan or protectGroups of recoveryPlan is null .");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"protectGroups of recoveryPlan is empty .");
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectGroup)iterator.next();
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        SyncReplicationSubProcessor preProcessor = (SyncReplicationSubProcessor)oldProcess;
        SyncReplicationSubProcessor newProcessor = (SyncReplicationSubProcessor)newProcess;
        return preProcessor.getReplicationId().equals(newProcessor.getReplicationId()) && preProcessor.getSrcDeviceId().equals(newProcessor.getSrcDeviceId()) && preProcessor.getTgtDeviceId().equals(newProcessor.getTgtDeviceId()) && preProcessor.getRelationType().equals(newProcessor.getRelationType());
    }

    protected boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks, String disasterSiteId) {
        HashSet<RecoveryProcessor> syncReplicationSubProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            RecoveryProcessor processor = this.createSubProcessorsByRecoveryTask(recoveryTask, disasterSiteId);
            if (null == processor) continue;
            syncReplicationSubProcessors.add(processor);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(syncReplicationSubProcessors);
        } else {
            this.updateSubProcessors(syncReplicationSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected RecoveryProcessor createSubProcessorsByRecoveryTask(RecoveryTask recoveryTask, String disasterSiteId) {
        RecoveryProcessor recoveryProcessor = null;
        if (VerifyUtil.isEmpty((Object)recoveryTask)) {
            return recoveryProcessor;
        }
        if (recoveryTask.getDisasterSite().getSiteId().equals(disasterSiteId)) {
            Map params = recoveryTask.getParams();
            if (!Objects.isNull(params) && Boolean.TRUE.equals(params.get("standby"))) {
                logger.debug((Object)"standby task do not process,task id: %s, productionSite:%s, disasterSite:%s. ", new Object[]{recoveryTask.getTaskId(), recoveryTask.getProductionSite(), recoveryTask.getDisasterSite()});
                return recoveryProcessor;
            }
            return this.createSyncReplicationSubProcessor(recoveryTask);
        }
        if (!VerifyUtil.isEmpty((Collection)recoveryTask.getCascadeTasks())) {
            for (RecoveryTask cascadeTask : recoveryTask.getCascadeTasks()) {
                logger.debug((Object)"cascadeTask: %s, productionSite:%s, disasterSite:%s. ", new Object[]{cascadeTask.getTaskId(), cascadeTask.getProductionSite(), cascadeTask.getDisasterSite()});
                RecoveryProcessor cascadeProcessor = this.createSubProcessorsByRecoveryTask(cascadeTask, disasterSiteId);
                if (VerifyUtil.isEmpty((Object)cascadeProcessor)) continue;
                SyncReplicationSubProcessor processor = this.createSyncReplicationSubProcessor(recoveryTask);
                processor.setNextCascadeProcessor(cascadeProcessor);
                return processor;
            }
        }
        if (!VerifyUtil.isEmpty((Collection)recoveryTask.getParallelTasks())) {
            for (RecoveryTask parallelTask : recoveryTask.getParallelTasks()) {
                logger.debug((Object)"parallelTask: %s, productionSite:%s, disasterSite:%s. ", new Object[]{parallelTask.getTaskId(), parallelTask.getProductionSite(), parallelTask.getDisasterSite()});
                RecoveryProcessor parallelProcessor = this.createSubProcessorsByRecoveryTask(parallelTask, disasterSiteId);
                if (VerifyUtil.isEmpty((Object)parallelProcessor)) continue;
                return parallelProcessor;
            }
        }
        return null;
    }

    private RecoveryProcessor buildProcessorCascadeRelation(RecoveryTask task, RecoveryProcessor processor, String disasterSiteId) {
        if (null == task.getCascadeTasks()) {
            return processor;
        }
        Iterator iterator = task.getCascadeTasks().iterator();
        if (!iterator.hasNext()) {
            return processor;
        }
        RecoveryTask recoveryTask = (RecoveryTask)iterator.next();
        if (!this.isSuitalbeTask(recoveryTask, task.getCascadeTasks(), disasterSiteId)) {
            return processor;
        }
        SyncReplicationSubProcessor cascadeSyncProcessor = this.createSyncReplicationSubProcessor(recoveryTask);
        processor.setNextCascadeProcessor((RecoveryProcessor)cascadeSyncProcessor);
        if (!VerifyUtil.isEmpty((Collection)recoveryTask.getCascadeTasks())) {
            this.buildProcessorCascadeRelation(recoveryTask, (RecoveryProcessor)cascadeSyncProcessor, disasterSiteId);
        }
        return processor;
    }

    private boolean isSuitalbeTask(RecoveryTask task, Set<RecoveryTask> cascadeTasks, String disasterSiteId) {
        if (task.getDisasterSite().getSiteId().equals(disasterSiteId)) {
            return true;
        }
        for (RecoveryTask tempTask : cascadeTasks) {
            if (!tempTask.getDisasterSite().getSiteId().equals(disasterSiteId)) continue;
            return true;
        }
        return false;
    }

    protected SyncReplicationSubProcessor createSyncReplicationSubProcessor(RecoveryTask recoveryTask) {
        SyncReplicationSubProcessor processor = new SyncReplicationSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setReplicationId(recoveryTask.getProtectId());
        Pair currentSrcAndTgtDeviceSN = RecoveryExtendUtil.getCurrentSrcAndTgtDeviceSN((String)recoveryTask.getSrcDeviceId(), (String)recoveryTask.getTgtDevcieId(), (String)recoveryTask.getProtectId(), (int)recoveryTask.getProtectType(), (RecoveryProcessorContext)this.context);
        processor.setCurrentSrcDeviceSN((String)currentSrcAndTgtDeviceSN.getKey());
        processor.setCurrentTgtDeviceSN((String)currentSrcAndTgtDeviceSN.getValue());
        processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
        processor.setTgtDeviceId(recoveryTask.getTgtDevcieId());
        processor.setRelationType(recoveryTask.getProtectType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return processor;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor.des");
    }

    public int getPolicyTemplate(RecoveryProcessorContext context) {
        return Optional.ofNullable(context.getProtectGroup()).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElse(-1);
    }

    public String getRecoveryTasksKey() {
        if (PolicyTemplateType.isNasAirGapNetworking((int)this.policyTemplate)) {
            return "remoteRecoveryTasks";
        }
        return super.getRecoveryTasksKey();
    }
}

