/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.replication;

import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.replication.ReplicationSubProcessor;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReplicationOperateSubProcessor
extends ReplicationSubProcessor {
    private static final long serialVersionUID = -8288223185792915427L;
    private boolean isSplit;

    public ReplicationOperateSubProcessor() {
        this(null, null, null, false, false);
    }

    public ReplicationOperateSubProcessor(String sourceDeviceSn, String targetDeviceSn, String replication, boolean isConsistentGroup, boolean isSplit) {
        super(sourceDeviceSn, targetDeviceSn, replication, isConsistentGroup);
        this.isSplit = isSplit;
    }

    public static ReplicationOperateSubProcessor createReplicationPairSplitProcessor(String sourceDeviceSn, String targetDeviceSn, String id) {
        return new ReplicationOperateSubProcessor(sourceDeviceSn, targetDeviceSn, id, false, true);
    }

    public static ReplicationOperateSubProcessor createReplicationGroupSplitProcessor(String sourceDeviceSn, String targetDeviceSn, String id) {
        return new ReplicationOperateSubProcessor(sourceDeviceSn, targetDeviceSn, id, true, true);
    }

    public static ReplicationOperateSubProcessor createReplicationPairUnprotectProcessor(String sourceDeviceSn, String targetDeviceSn, String id) {
        return new ReplicationOperateSubProcessor(sourceDeviceSn, targetDeviceSn, id, false, false);
    }

    public static ReplicationOperateSubProcessor createReplicationGroupUnprotectProcessor(String sourceDeviceSn, String targetDeviceSn, String replication) {
        return new ReplicationOperateSubProcessor(sourceDeviceSn, targetDeviceSn, replication, true, false);
    }

    public String getName() {
        return Stream.of(super.getName(), this.getAction(), this.getRecoveryPhase()).filter(Objects::nonNull).collect(Collectors.joining("."));
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getSourceDeviceSn(), this.getTargetDeviceSn(), this.getReplication()});
        return super.execute(context);
    }

    @Override
    protected void executeSubProcessors(RecoveryProcessorContext context) {
        IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        recoveryProcessHandler.forceSwap(this.getReplication(), this.getSourceDeviceSn(), this.getTargetDeviceSn(), this.isConsistentGroup(), this.isSplit);
    }

    @Override
    protected String generateResultKey() {
        if ("unprotect".equals(this.getAction())) {
            return RecoveryProcessResult.getSwapProcessResultKey((String)this.getReplication(), (String)this.getSourceDeviceSn(), (String)this.getTargetDeviceSn(), (int)this.getRelationType());
        }
        return String.format(Locale.ENGLISH, "%s,action=%s", super.generateResultKey(), this.getAction());
    }

    private String getAction() {
        return this.isSplit ? "split" : "unprotect";
    }

    public int getRelationType() {
        return this.isConsistentGroup() ? ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.getValue() : ReplicationConstantDefine.ReplicationDescription.HYPER_MIRROR.getValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ReplicationOperateSubProcessor that = (ReplicationOperateSubProcessor)((Object)obj);
        return this.isSplit == that.isSplit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isSplit);
    }
}

