/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.replication;

import com.huawei.ism.drm.storage.recovery.process.common.CommonRecoveryProcessor;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public abstract class ReplicationSubProcessor
extends CommonRecoveryProcessor {
    private static final long serialVersionUID = 557771063879392904L;
    private String sourceDeviceSn;
    private String targetDeviceSn;
    private String replication;
    private boolean isConsistentGroup;

    public ReplicationSubProcessor(String sourceDeviceSn, String targetDeviceSn, String replication, boolean isConsistentGroup) {
        this.sourceDeviceSn = sourceDeviceSn;
        this.targetDeviceSn = targetDeviceSn;
        this.replication = replication;
        this.isConsistentGroup = isConsistentGroup;
    }

    public String getSourceDeviceSn() {
        return this.sourceDeviceSn;
    }

    public void setSourceDeviceSn(String sourceDeviceSn) {
        this.sourceDeviceSn = sourceDeviceSn;
    }

    public String getTargetDeviceSn() {
        return this.targetDeviceSn;
    }

    public void setTargetDeviceSn(String targetDeviceSn) {
        this.targetDeviceSn = targetDeviceSn;
    }

    public String getReplication() {
        return this.replication;
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public boolean isConsistentGroup() {
        return this.isConsistentGroup;
    }

    public void setConsistentGroup(boolean consistentGroup) {
        this.isConsistentGroup = consistentGroup;
    }

    protected String generateResultKey() {
        return String.format(Locale.ENGLISH, "source-device-sn=%s,target-device-sn=%s,replication=%s,cg=%s", this.getSourceDeviceSn(), this.getTargetDeviceSn(), this.getReplication(), this.isConsistentGroup());
    }

    protected String getRecoveryPhase() {
        return (String)this.getProps().get("recovery-phase");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationSubProcessor that = (ReplicationSubProcessor)((Object)obj);
        return Arrays.equals(this.identifiers(), that.identifiers());
    }

    private Object[] identifiers() {
        return new Object[]{this.getPlanId(), this.sourceDeviceSn, this.targetDeviceSn, this.replication, this.isConsistentGroup, this.getRecoveryPhase()};
    }

    public int hashCode() {
        return Objects.hash(this.identifiers());
    }
}

