/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.topology.ArrayReplicationTopoBuilder;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.storage.topology.ReplicationLinkSkin;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.element.VPanelElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.topo.skin.LinkSkin;
import com.huawei.ism.drm.topo.topology.TopoElement;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.topology.IData;
import com.huawei.topology.IElement;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-48")
public class ArrayAirGapHyperMetroReplicationRingTopoBuilder
extends ArrayReplicationTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(ArrayAirGapHyperMetroReplicationRingTopoBuilder.class);
    private static final double STANDBY_SON_GAP = 30.0;
    private static final double TGT_SON_GAP = 20.0;
    private static final double OUTLINE_ALPHA = 0.0;
    private static final String DR_STAR_SRC_SN = "DR_STAR_SRC_SN";
    private static final String DR_STAR_TGT_SITE_ID = "DR_STAR_TGT_SITE_ID";
    private static final String DR_STAR_SRC_STANDBY_SN = "DR_STAR_SRC_STANDBY_SN";

    @Override
    public void buildTopo(TopoBaseContext context) {
        this.checkRootNode(context);
        ProtectGroup pg = context.getProtectGroup();
        if (pg.getTemplate().getType() != 48) {
            LOGGER.error((Object)"Template is not dr star air gap, pg name=%s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        Set pgReplicas = pg.getReplicaList();
        this.sortRelation(pg);
        List<ReplicaRelation> relations = this.transform(pg, pgReplicas);
        if (relations.size() != 2) {
            LOGGER.error((Object)"Dr star must have 2 replications, pg name=%s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        StringBuilder lunIdList = new StringBuilder();
        Map<String, String> wrapMap = this.initWrapMap(pg);
        this.handleAirGapRelation(relations, wrapMap, context, false, lunIdList);
        this.handleAirGapHyperMetro(context, relations);
        context.setLinkIdList(lunIdList.toString());
        this.updateSitePosition(context);
    }

    protected void handleAirGapRelation(List<ReplicaRelation> relations, Map<String, String> wrapMap, TopoBaseContext context, boolean isParallel, StringBuilder lunIdList) {
        ProtectGroup pg = context.getProtectGroup();
        List<ReplicationRelationBo> standbyBos = this.getReplicationRelationStandbyBos(pg);
        ReplicaRelation tempSrcRelation = ArrayAirGapHyperMetroReplicationRingTopoBuilder.getTempSrcRelation(relations, standbyBos);
        ReplicaRelation tempStandbyRelation = ArrayAirGapHyperMetroReplicationRingTopoBuilder.getTempStandbyRelation(relations, standbyBos);
        String srcSn = tempSrcRelation.getSourceSN();
        String tgtSn = tempSrcRelation.getTargetSN();
        String srcStandbySn = tempStandbyRelation.getSourceSN();
        Node srcStorageNode = this.addAirGapSrcNode(context, tempSrcRelation, srcSn, tgtSn);
        Node srcStandbyStorageNode = this.addAirGapSrcNode(context, tempStandbyRelation, srcStandbySn, tgtSn);
        Site tgtSite = this.setSite(context, tempSrcRelation.getRecoverySite());
        DrStorage tgtDrStorage = this.getResource(tgtSn);
        Node tgtStorageNode = this.addSiteNode(context, tgtDrStorage, tgtSite, wrapMap);
        ArrayAirGapHyperMetroReplicationRingTopoBuilder.cacheSnAndSiteIdInfo(pg, srcSn, tgtSite.getSiteId(), srcStandbySn);
        for (int i = 0; i < 2; ++i) {
            ReplicaRelation relation = i == 1 ? tempStandbyRelation : tempSrcRelation;
            srcStorageNode = i == 1 ? srcStandbyStorageNode : srcStorageNode;
            String srcSN = relation.getSourceSN();
            String tgtSN = relation.getTargetSN();
            this.setWrapMap(wrapMap, isParallel, tgtSite);
            ArrayList<String> srResourceIdList = new ArrayList<String>(relation.getSourceLuns());
            srResourceIdList.sort(Comparator.comparingInt(Integer::parseInt));
            List sources = this.getResourceListFromDB(srcSN, srResourceIdList);
            List tgtLuns = this.getResourceListFromDB(tgtSite, tgtSN, relation.getTargetLuns());
            List targets = this.getTrgLunListFromDB(tgtSN, tgtSN, relation.getTargetLuns());
            String scheduleInfo = ArrayAirGapHyperMetroReplicationRingTopoBuilder.getScheduleInfo(pg, relation);
            Map<String, StorageResource> srcResourceIDMap = this.getResourceIDMap(sources);
            Map<String, StorageResource> tgtResourceIDMap = this.getResourceIDMap(tgtLuns);
            Map<String, ReplicationTargetLun> repLunIDMap = this.getReplicationLunIDMap(targets, false);
            Map<String, ReplicationTargetLun> repLunIDStandyMap = this.getReplicationLunIDMap(targets, true);
            HashMap<String, ReplicationRelation> consistencyIdToGroup = new HashMap<String, ReplicationRelation>();
            for (String srcResourceId : srResourceIdList) {
                StorageResource srcResource = this.getStorageResource(relation, srcResourceIDMap, srcResourceId);
                TopoElement srcNode = this.createTopoElementByResource(srcSN, srcResourceId, srcResource, srcResource, pg);
                String targetResourceId = relation.getTargetLunBySource(srcResourceId);
                StorageResource targetResource = tgtResourceIDMap.get(this.getAirGapResourceId(targetResourceId, pg));
                TopoElement targetNode = this.createTopoElementByResource(tgtSN, targetResourceId, targetResource, srcResource, pg);
                srcNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcNode);
                targetNode = (Node)context.addChild((IData)tgtStorageNode, (IData)targetNode);
                ReplicationTargetLun repLunInfo = ArrayAirGapHyperMetroReplicationRingTopoBuilder.getReplicationTargetLun(standbyBos, srcSN, targetResourceId, repLunIDStandyMap, repLunIDMap);
                String linkId = srcSN + ":" + srcResourceId + ":" + tgtSN + ":" + targetResourceId;
                ReplicationRelation replicationRelation = this.getRepGroupByTarget(repLunInfo, relation, consistencyIdToGroup, targetResourceId).orElse(null);
                this.addLinkIdInfo(lunIdList, repLunInfo, linkId);
                context.linkTos((Node)srcNode, (Node)targetNode, linkId, new Skin[]{new ReplicationLinkSkin(replicationRelation, this.getDeviceType(srcSN), repLunInfo, scheduleInfo)});
            }
        }
    }

    private DrStorage getResource(String tgtSn) {
        DrResource drResource = this.getDrResource(tgtSn);
        DrStorage drStorage = null;
        if (drResource instanceof DrStorage) {
            drStorage = (DrStorage)drResource;
        }
        return drStorage;
    }

    protected void handleAirGapHyperMetro(TopoBaseContext context, List<ReplicaRelation> relations) {
        ReplicaRelation tempSrcRelation = relations.get(0);
        ReplicaRelation tempStandbyRelation = relations.get(1);
        List<String> tgtLunIds = tempSrcRelation.getTargetLuns();
        List pairs = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getReplicationPairsByResourceIds(tempSrcRelation.getTargetSN(), tgtLunIds, false, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        String srcDevSn = tempSrcRelation.getSourceSN();
        String standbyDevSn = tempStandbyRelation.getSourceSN();
        ProtectGroup pg = context.getProtectGroup();
        ProtectGroupReplica anyoneReplicationReplica = pg.getAnyoneReplicationReplica();
        anyoneReplicationReplica.getReplicas().forEach(replica -> {
            for (RelicaStorageInfo relicastorageinfo : replica.getStorageInfos()) {
                ReplicationPair standbyPair = pairs.stream().filter(e -> standbyDevSn.equals(e.getSrcDevSN()) && ((ReplicationTargetLun)e.getRepTgtLuns().get(0)).getTgtLunId().equals(relicastorageinfo.getStorageId())).findFirst().orElseThrow(() -> new LegoCheckedException(201L));
                ReplicationPair srcPair = pairs.stream().filter(e -> srcDevSn.equals(e.getSrcDevSN()) && ((ReplicationTargetLun)e.getRepTgtLuns().get(0)).getTgtLunId().equals(relicastorageinfo.getStorageId())).findFirst().orElseThrow(() -> new LegoCheckedException(201L));
                String srcLunId = srcPair.getSrcLunId();
                String standbyLunId = standbyPair.getSrcLunId();
                LinkSkin linkSkin = new LinkSkin("0x1dcfef");
                Node node1 = (Node)context.getDataByID((Object)(srcDevSn + srcLunId));
                Node node2 = (Node)context.getDataByID((Object)(standbyDevSn + standbyLunId));
                context.linkTo(node1, node2, new Skin[]{linkSkin});
            }
        });
    }

    private void updateSitePosition(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        VerifyUtil.checkObject((Object)protectGroup);
        String standbySn = (String)protectGroup.getProps().get(DR_STAR_SRC_SN);
        IElement standbyEle = context.getElementByID((Object)(standbySn + "---" + "Style:unvisible"));
        Node standyByNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)("preset-location-" + standbyEle.getID()));
        standbyEle.addChild((IData)standyByNode, 0);
        standbyEle.setClient("layout", (Object)"topbottom");
        standbyEle.setClient("sonsGap", (Object)30.0);
        String tgtSn = (String)protectGroup.getProps().get(DR_STAR_TGT_SITE_ID);
        IElement recoveryEle = context.getElementByID((Object)(tgtSn + "---" + "Style:unvisible"));
        Node node = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)("preset-location-" + recoveryEle.getID()));
        recoveryEle.addChild((IData)node, 0);
        recoveryEle.setClient("layout", (Object)"topbottom");
        recoveryEle.setClient("sonsGap", (Object)20.0);
    }

    @Override
    protected String getDeviceType(String srcSN) {
        String storageType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSN);
        if (VerifyUtil.isEmpty((String)storageType)) {
            storageType = "com.huawei.ism.array.sdk.model.HvsUnit";
        }
        return storageType;
    }

    private static ReplicaRelation getTempSrcRelation(List<ReplicaRelation> relations, List<ReplicationRelationBo> standbyBos) {
        return relations.stream().filter(e -> ((ReplicationRelationBo)standbyBos.iterator().next()).getSrcDeviceSn().equals(e.getSourceSN())).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    private static ReplicaRelation getTempStandbyRelation(List<ReplicaRelation> relations, List<ReplicationRelationBo> standbyBos) {
        return relations.stream().filter(e -> !((ReplicationRelationBo)standbyBos.iterator().next()).getSrcDeviceSn().equals(e.getSourceSN())).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    private static void cacheSnAndSiteIdInfo(ProtectGroup pg, String srcSN, String tgtSiteId, String srcStandbySN) {
        pg.getProps().put(DR_STAR_SRC_SN, srcSN);
        pg.getProps().put(DR_STAR_TGT_SITE_ID, tgtSiteId);
        pg.getProps().put(DR_STAR_SRC_STANDBY_SN, srcStandbySN);
    }

    @Override
    protected Node addAirGapSrcNode(TopoBaseContext context, ReplicaRelation replicaRelation, String srcSN, String tgtSN) {
        IResourceService resourceService;
        List timeWindows;
        Optional<ResourceTimeWindow> opt;
        Node root = context.getRootNode();
        String siteStyleNodeId = srcSN + "---" + "Style:unvisible";
        IData dataByID = context.getElementBox().getDataByID((Object)siteStyleNodeId);
        Node siteStyleNode = null;
        if (dataByID instanceof Node) {
            siteStyleNode = (Node)dataByID;
        }
        if (VerifyUtil.isEmpty(siteStyleNode)) {
            siteStyleNode = this.createUnVisibleStyleNode(context, srcSN + "---" + "Style");
            context.addChild((IData)root, (IData)siteStyleNode);
        }
        String srcNodeName = !(opt = (timeWindows = (resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getResourceTimeWindow(tgtSN)).stream().filter(timeWindow -> Objects.equals(srcSN, timeWindow.getEsn())).findAny()).isPresent() ? "--" : opt.get().getRemoteName();
        DrStorage drStorage = new DrStorage();
        drStorage.setIpAddress("--");
        drStorage.setName(srcNodeName);
        drStorage.setDeviceSn(replicaRelation.getSourceSN());
        drStorage.setProductModel("UNKNOWN");
        drStorage.setStatus("0");
        return (Node)context.addChild((IData)siteStyleNode, (IData)new StorageElement(drStorage));
    }

    @Override
    protected Node createSiteNode(TopoBaseContext context, Site site, boolean isWrap, String wrapId) {
        Node root = context.getRootNode();
        String siteId = site.getSiteId();
        String siteStyleNodeId = siteId + "---" + "Style:unvisible";
        IData dataByID = context.getElementBox().getDataByID((Object)siteStyleNodeId);
        Node siteStyleNode = null;
        if (dataByID instanceof Node) {
            siteStyleNode = (Node)dataByID;
        }
        if (VerifyUtil.isEmpty(siteStyleNode)) {
            siteStyleNode = this.createUnVisibleStyleNode(context, siteId + "---" + "Style");
            root = (Node)context.addChild((IData)root, (IData)siteStyleNode);
        }
        SiteElement node = new SiteElement(site);
        IElement elementByID = context.getElementBox().getElementByID(node.getID());
        if (!VerifyUtil.isEmpty((Object)elementByID)) {
            return (Node)Node.class.cast(elementByID);
        }
        VPanelElement container = (VPanelElement)context.find((Object)"Replication-Container");
        if (!VerifyUtil.isEmpty((Object)container)) {
            root = (Node)context.addChild((IData)root, (IData)container);
        }
        if (isWrap) {
            VPanelElement vPanelElement = (VPanelElement)context.find((Object)wrapId);
            vPanelElement = vPanelElement == null ? new VPanelElement((Object)wrapId) : vPanelElement;
            root = (Node)context.addChild((IData)root, (IData)vPanelElement);
        }
        node = (Node)context.addChild((IData)root, (IData)node);
        return node;
    }

    private Node createUnVisibleStyleNode(TopoBaseContext context, String styleNodeId) {
        String nodeID = styleNodeId + ":unvisible";
        IElement elementByID = context.getElementBox().getElementByID((Object)nodeID);
        Node group = null;
        if (elementByID instanceof Node) {
            group = (Node)elementByID;
        }
        if (VerifyUtil.isEmpty(group)) {
            group = this.createGroupStyleNode(nodeID);
            group.setStyle("vector.fill.color", (Object)"0xFAFAFA");
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            group.setStyle("vector.outline.width", 1.0);
            group.setStyle("vector.outline.color", (Object)"0xFAFAFA");
            group.setStyle("vector.outline.alpha", 0.0);
            group.setStyle("vector.fill", false);
            group.setStyle("content.type", (Object)"vector");
        }
        group.setStyle("icons.position", (Object)"right.right");
        group.setClient("iconHeight", 48.0);
        group.setClient("iconWidth", 48.0);
        group.setClient("ISSNAPPO", (Object)"FALSE");
        return group;
    }

    private Node createGroupStyleNode(String id) {
        Node group = new Node((Object)id);
        group.setStyle("vector.roundrect.radius", 7);
        group.setClient("layout", (Object)"leftright");
        group.setClient("TopoModel", (Object)"StyleGroup");
        group.setStyle("content.type", (Object)"vector");
        group.setStyle("vector.shape", (Object)"roundrect");
        return group;
    }

    private static String getScheduleInfo(ProtectGroup pg, ReplicaRelation relation) {
        Set schedules = pg.getTemplate().getSchedules();
        Schedule schedule = TopoServiceUtil.getSchedule((int)relation.getProtectLocation(), (Set)schedules, (ProtectGroup)pg);
        return TooltipUtil.getScheduleInfo((Schedule)schedule);
    }

    private List<ReplicationRelationBo> getReplicationRelationStandbyBos(ProtectGroup pg) {
        List<ProtectGroupReplica> protectGroupReplicaList = pg.getReplicaList().stream().filter(e -> e.getType() == 2).collect(Collectors.toList());
        ArrayList rrbs = new ArrayList();
        protectGroupReplicaList.forEach(e -> rrbs.addAll(pg.getReplicationRelationBos(e.getReplicas())));
        return rrbs.stream().filter(e -> !this.isNormalReplication((ReplicationRelationBo)e)).collect(Collectors.toList());
    }

    private static ReplicationTargetLun getReplicationTargetLun(List<ReplicationRelationBo> standbyBos, String srcSN, String targetResourceId, Map<String, ReplicationTargetLun> repLunIDStandyMap, Map<String, ReplicationTargetLun> repLunIDMap) {
        Optional<ReplicationRelationBo> optionalStandby = standbyBos.stream().filter(e -> e.getSrcDeviceSn().equals(srcSN) && e.getTgtLuns().containsValue(targetResourceId)).findFirst();
        if (optionalStandby.isPresent()) {
            return repLunIDStandyMap.get(targetResourceId);
        }
        return repLunIDMap.get(targetResourceId);
    }

    private boolean isNormalReplication(ReplicationRelationBo bo) {
        IRecoveryProcessBaseHandler recoveryProcessBaseHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (!(recoveryProcessBaseHandler instanceof IRecoveryProcessHandler)) {
            LOGGER.error((Object)"Can not get the recovery process base handler.");
            throw new LegoCheckedException(1073947395L);
        }
        IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)recoveryProcessBaseHandler;
        List targetLuns = recoveryProcessHandler.querySyncStatus(bo.getSrcDeviceSn(), bo.getTgtDeviceSn(), bo.getReplicationId(), bo.isConsistentGroup());
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            if (repTargetLun.getPairStatus().intValue() != XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue()) continue;
            LOGGER.info((Object)"This is the slave replication, replication pair id=%s.", new Object[]{bo.getReplicationId()});
            return false;
        }
        return true;
    }

    private Map<String, ReplicationTargetLun> getReplicationLunIDMap(List<ReplicationTargetLun> targets, boolean isStandBy) {
        if (isStandBy) {
            return this.getStandByReplicationLunIDMap(targets);
        }
        return this.getSrcReplicationLunIDMap(targets);
    }

    private Map<String, ReplicationTargetLun> getStandByReplicationLunIDMap(List<ReplicationTargetLun> targets) {
        List tempTargets = targets.stream().filter(e -> e.getPairStatus().intValue() == XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue()).collect(Collectors.toList());
        HashMap<String, ReplicationTargetLun> repLunIDMap = new HashMap<String, ReplicationTargetLun>();
        for (ReplicationTargetLun repLun : tempTargets) {
            repLunIDMap.put(repLun.getTgtLunId(), repLun);
        }
        return repLunIDMap;
    }

    private Map<String, ReplicationTargetLun> getSrcReplicationLunIDMap(List<ReplicationTargetLun> targets) {
        List tempTargets = targets.stream().filter(e -> e.getPairStatus().intValue() != XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue()).collect(Collectors.toList());
        HashMap<String, ReplicationTargetLun> repLunIDMap = new HashMap<String, ReplicationTargetLun>();
        for (ReplicationTargetLun repLun : tempTargets) {
            repLunIDMap.put(repLun.getTgtLunId(), repLun);
        }
        return repLunIDMap;
    }

    private void checkRootNode(TopoBaseContext context) {
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"TopoBaseContext is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)context.getRootNode())) {
            this.initialize(context);
        }
    }
}

