/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.topo.builder.AbstractTopoBuilder;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class ArrayTopoBuilder
extends AbstractTopoBuilder {
    public static final Log logger = LogFactory.getInstance(ArrayTopoBuilder.class);
    protected static final int RESOURCE_UNKOWN_STATUS = -2;
    private static final String SRC_DEVICE_SN = "srcDeviceSn";

    protected List<ReplicationTargetLun> getTrgLunListFromDB(Site site, String srcSN, String trgSN, List<String> listTrgLunID) {
        return this.getTrgLunListFromDB(srcSN, trgSN, listTrgLunID);
    }

    protected List<ReplicaRelation> transform(ProtectGroup pg, Set<ProtectGroupReplica> replicas) {
        ArrayList<ReplicaRelation> relations = new ArrayList<ReplicaRelation>();
        for (ProtectGroupReplica replica : replicas) {
            ReplicaRelation relation;
            replica.setPg(pg);
            if (!replica.isStorageReplicationReplica() || (relation = new ReplicaRelation(pg, replica)).isEmpty()) continue;
            relations.add(relation);
        }
        Collections.sort(relations);
        return relations;
    }

    protected Map<String, ReplicationTargetLun> getReplicationLunIDMap(List<ReplicationTargetLun> targets) {
        HashMap<String, ReplicationTargetLun> repLunIDMap = new HashMap<String, ReplicationTargetLun>();
        if (null == targets) {
            return repLunIDMap;
        }
        for (ReplicationTargetLun repLun : targets) {
            repLunIDMap.put(repLun.getTgtLunId(), repLun);
        }
        return repLunIDMap;
    }

    protected Map<String, StorageResource> getResourceIDMap(List<StorageResource> resourceList) {
        HashMap<String, StorageResource> resourceIDMap = new HashMap<String, StorageResource>();
        for (StorageResource resource : resourceList) {
            if (resource instanceof Lun) {
                resourceIDMap.put(DrmEnumDefine.ResourceTypeE.LUN.name() + resource.getResourceId(), resource);
                continue;
            }
            if (!(resource instanceof NasFileSystem)) continue;
            resourceIDMap.put(DrmEnumDefine.ResourceTypeE.NAS.name() + resource.getResourceId(), resource);
        }
        return resourceIDMap;
    }

    protected boolean checkSource(List<NasFileSystem> nasFileSystemList, StorageResource source) {
        if (source == null) {
            return true;
        }
        if (source instanceof NasFileSystem) {
            nasFileSystemList.add((NasFileSystem)source);
            return true;
        }
        return false;
    }

    protected ReplicationRelation getReplicationGroup(ReplicationTargetLun repLunInfo, ReplicaRelation relation, Map<String, ReplicationRelation> idToConinstancGroup, Site srcSite, String trgLunID) {
        IRecoveryResourceService recoveryResourceService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        ReplicationRelation repliationRelation = null;
        if (null == repLunInfo) {
            return null;
        }
        String coninstanceId = relation.getIsTgtLunToConinstance().get(repLunInfo.getTgtDevSN() + trgLunID);
        repliationRelation = idToConinstancGroup.get(coninstanceId);
        if (null != repliationRelation && repliationRelation.getReplicationId().equals(coninstanceId)) {
            return repliationRelation;
        }
        if (!VerifyUtil.isEmpty((String)coninstanceId) && !"--".equals(coninstanceId)) {
            repliationRelation = recoveryResourceService.queryReplication(srcSite, repLunInfo.getDevSn(), repLunInfo.getTgtDevSN(), coninstanceId, true);
        }
        if (null != repliationRelation) {
            idToConinstancGroup.put(coninstanceId, repliationRelation);
        }
        return repliationRelation;
    }

    protected Optional<ReplicationRelation> getRepGroupByTarget(ReplicationTargetLun repLunInfo, ReplicaRelation relation, Map<String, ReplicationRelation> idToConsistencyGroup, String tgtLunID) {
        if (VerifyUtil.isEmpty((Object)repLunInfo)) {
            return Optional.empty();
        }
        String consistencyId = relation.getIsTgtLunToConinstance().get(repLunInfo.getTgtDevSN() + tgtLunID);
        ReplicationRelation replicationRelation = idToConsistencyGroup.get(consistencyId);
        if (replicationRelation != null && replicationRelation.getReplicationId().equals(consistencyId)) {
            return Optional.of(replicationRelation);
        }
        IRecoveryResourceService recoveryResourceService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        if (!VerifyUtil.isEmpty((String)consistencyId) && !"--".equals(consistencyId)) {
            replicationRelation = recoveryResourceService.queryReplication(repLunInfo.getTgtDevSN(), consistencyId, true);
        }
        if (VerifyUtil.isEmpty((Object)replicationRelation)) {
            logger.info((Object)"Not find replicationRelation of CG");
            return Optional.empty();
        }
        idToConsistencyGroup.put(consistencyId, replicationRelation);
        return Optional.of(replicationRelation);
    }
}

