/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBaseBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-15##Global-Topology-18##Global-Topology-19##Global-Topology-23##Global-Topology-28##Global-Topology-31")
public class HyperMetroGlobalTopoBuilder
extends AbstractGlobalTopoBuilder {
    private static final String BLANK_IP_CN = "          ";
    private static final String BLANK_IP_EN = "                      ";
    private static final Log logger = LogFactory.getInstance(HyperMetroGlobalTopoBuilder.class);
    private boolean whole = true;

    public boolean isWhole() {
        return this.whole;
    }

    public void setWhole(boolean whole) {
        this.whole = whole;
    }

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        VerifyUtil.checkObject((Object)layout);
        int poType = protectGroup.getPoType();
        if (this.checkPoType(poType)) {
            ITopoBaseBuilder hostBuilder = context.getTopoBuilderManager().getTopoBuilder("Global-Topology-Host");
            hostBuilder.buildTopo(context);
        } else if (poType == 10) {
            ITopoBaseBuilder vsBuilder = context.getTopoBuilderManager().getTopoBuilder("Global-Topology-vSphere");
            vsBuilder.buildTopo(context);
        }
        ProtectObjectStorageInfo poStorageInfo = context.getTopoBaseService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
        List<StorageResource> lunList = this.getStorageResource(context, poStorageInfo);
        ArrayList<Node> storageNodeList = new ArrayList<Node>();
        List<String> siteIdList = this.getSiteIdList(context, lunList);
        for (StorageResource lun : lunList) {
            if (!(lun instanceof Lun) && !(lun instanceof NasFileSystem)) continue;
            String devSn = lun.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, devSn);
            Node storageNode = this.createStorage(context, context.getProtectGroup(), drStorage, layout);
            storageNodeList.add(storageNode);
            List hostNodeList = context.getVmEsxNode();
            for (Node hostNode : hostNodeList) {
                this.setHostNodeClient(context, siteIdList, hostNode);
                this.createHostStorageLink(context, hostNode, storageNode, true);
            }
        }
        this.createHyperMetroLink(context, protectGroup, layout, storageNodeList);
        this.createStorageArray(context, layout);
    }

    private List<StorageResource> getStorageResource(TopoBaseContext context, ProtectObjectStorageInfo poStorageInfo) {
        List srList;
        String wwn = poStorageInfo.getLunWWN();
        if (context.getProtectGroup().isPrimary()) {
            srList = context.getStorageService().getStorageResourceByWwn(new String[]{wwn});
        } else {
            String productSiteId = context.getProtectGroup().getProductSiteId();
            Site productSite = this.getSiteInContext(context, productSiteId);
            srList = context.getStorageService().getResourceByWwnFromRemote(productSite, new ArrayList<String>(Arrays.asList(wwn)));
        }
        if (VerifyUtil.isEmpty((Collection)srList)) {
            ProtectGroup pg = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(context.getProtectGroup().getUuid(), false);
            String devSn = null;
            HashSet<String> resourceIds = new HashSet<String>();
            for (ProtectObject protectObject : pg.getPolist()) {
                for (ProtectObjectStorageInfo storageInfo : protectObject.getUsedStorageResourceSet()) {
                    devSn = storageInfo.getResourceProviderSN();
                    resourceIds.add(storageInfo.getResourceId());
                }
            }
            List hmList = this.getHyperMetroPairList(devSn, new ArrayList(resourceIds));
            String vstorePairId = (String)context.getProtectGroup().getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            srList = StorageResourceServiceRouter.getInstance().getNasHyperMetroStoreageList(devSn, vstorePairId, hmList);
        }
        return srList;
    }

    protected void createHyperMetroLink(TopoBaseContext context, ProtectGroup protectGroup, ElementBox layout, List<Node> storageNodeList) {
        for (Node storageNode : storageNodeList) {
            String srcStorageSn = this.createQuorumNode(context, protectGroup, layout, storageNode);
            this.addStorageLink(context, protectGroup, storageNodeList, storageNode, srcStorageSn);
        }
    }

    protected void setHostNodeClient(TopoBaseContext context, List<String> siteIdList, Node hostNode) {
        String siteId = (String)hostNode.getClient("srcSiteID");
        for (String siteIds : siteIdList) {
            if (siteIds.equalsIgnoreCase(siteId)) continue;
            hostNode.setClient("siteID", (Object)siteIds);
            Site siteInfo = this.getSiteInContext(context, siteIds);
            if (VerifyUtil.isEmpty((Object)siteInfo)) break;
            hostNode.setClient("topoSiteName", (Object)("<![CDATA[" + siteInfo.getName() + "]]>"));
            break;
        }
    }

    protected List<String> getSiteIdList(TopoBaseContext context, List<StorageResource> lunList) {
        ArrayList<String> siteIdList = new ArrayList<String>();
        for (StorageResource lun : lunList) {
            String devSn;
            DrStorage drStorage;
            String siteId;
            if (!(lun instanceof Lun) && !(lun instanceof NasFileSystem) || siteIdList.contains(siteId = (drStorage = (DrStorage)this.getDrResourceInContext(context, devSn = lun.getDevSn())).getSiteId())) continue;
            siteIdList.add(siteId);
        }
        return siteIdList;
    }

    private void addStorageLink(TopoBaseContext context, ProtectGroup protectGroup, List<Node> storageNodeList, Node storageNode, String srcStorageSn) {
        for (Node trgNode : storageNodeList) {
            if (trgNode.getID().equals(storageNode.getID())) continue;
            Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)storageNode, (Node)trgNode);
            if (link == null) {
                String trgStorageSn = this.getNetworkSnFromNodeId((String)trgNode.getID());
                this.createStorageLink(context, srcStorageSn, storageNode, trgStorageSn, trgNode);
                continue;
            }
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    private String createQuorumNode(TopoBaseContext context, ProtectGroup protectGroup, ElementBox layout, Node storageNode) {
        String srcStorageSn = this.getNetworkSnFromNodeId((String)storageNode.getID());
        List hyperMetroDomains = this.getHyperMetroDomainsInContext(context, srcStorageSn);
        if (VerifyUtil.isEmpty((Collection)hyperMetroDomains)) {
            return srcStorageSn;
        }
        List quorumServers = this.getQuorumServersInContext(context, srcStorageSn);
        if (VerifyUtil.isEmpty((Collection)quorumServers)) {
            return srcStorageSn;
        }
        for (QuorumServer quorumServer : quorumServers) {
            HyperMetroDomain hyperMetroDomain = this.getHyperMetroDomainByServer(hyperMetroDomains, quorumServer);
            if (VerifyUtil.isEmpty((Object)hyperMetroDomain)) continue;
            Node quorumServerNode = this.createQuorumServerNode(context, quorumServer, (Node)storageNode.getParent(), layout);
            this.addProtectGroupIDToElement((Element)quorumServerNode, protectGroup.getUuid());
            Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)storageNode, (Node)quorumServerNode);
            if (link == null) {
                String linkID = "quorumlink-" + storageNode.getID() + ":" + quorumServerNode.getID();
                link = new Link((Object)linkID, storageNode, quorumServerNode);
                link.setStyle("link.color", (Object)"0x31bd16");
                link.setStyle("arrow.to.color", (Object)"0x31bd16");
                link.setClient("linkToXOffset", 10.0);
                link.setClient("devSN", (Object)srcStorageSn);
                link.setClient("trgSN", (Object)quorumServer.getId());
                link.setStyle("link.width", 1.0);
                link.setStyle("arrow.to", false);
                link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
                link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
                link.setStyle("arrow.to.shape", (Object)"arrow.delta");
                link.setStyle("select.alpha", 1.0);
                link.setStyle("select.style", (Object)"none");
                TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)link);
                ArrayList quorumServerLinks = context.getStorageResourceService().getQuorumServerLink(srcStorageSn, quorumServer.getId());
                if (null == quorumServerLinks) {
                    quorumServerLinks = new ArrayList();
                }
                int sum = quorumServerLinks.size();
                int breakNum = 0;
                int unknownNum = 0;
                for (QuorumServerLink linkInfo : quorumServerLinks) {
                    int status = this.getIntFromStr(linkInfo.getRunningState());
                    if (11 == status) {
                        ++breakNum;
                        continue;
                    }
                    if (XveEuumDefineParent.RUNNING_STATUS_E.UNKNOWN.getValue() != status) continue;
                    ++unknownNum;
                }
                this.setToolTips(link, sum, breakNum, unknownNum);
            }
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
        logger.debug((Object)("srcStorageSn:" + srcStorageSn));
        return srcStorageSn;
    }

    private HyperMetroDomain getHyperMetroDomainByServer(List<HyperMetroDomain> hyperMetroDomains, QuorumServer quorumServer) {
        String serverId = quorumServer.getId();
        for (HyperMetroDomain hyperMetroDomain : hyperMetroDomains) {
            if (!serverId.equals(hyperMetroDomain.getCpsId())) continue;
            return hyperMetroDomain;
        }
        return null;
    }

    protected void removeLinkFromBox(TopoBaseContext context, Link link) {
        context.getElementBox().remove((IData)link);
    }

    private Node createQuorumServerNode(TopoBaseContext context, QuorumServer quorumServer, Node fatherNode, ElementBox layout) {
        String nodeId = quorumServer.getSn() + "---" + "quorumServer";
        Node quorumServerNode = (Node)context.getElementBox().getElementByID((Object)nodeId);
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        String langInfo = resourceManager.getLangInfo();
        String blankStr = null;
        blankStr = "zh".equals(langInfo) ? BLANK_IP_CN : BLANK_IP_EN;
        if (quorumServerNode != null) {
            this.setStatusAndTooltips(quorumServer, quorumServerNode, resourceManager, blankStr);
            return quorumServerNode;
        }
        quorumServerNode = new Node((Object)nodeId);
        quorumServerNode.setStyle("label.bold", false);
        quorumServerNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        quorumServerNode.setStyle("label.color", 35020);
        this.setImageByStatus(quorumServerNode, quorumServer.getRunningState());
        quorumServerNode.setClient("imageWidth", 48.0);
        quorumServerNode.setClient("imageHeight", 60.0);
        quorumServerNode.setName(TopoServiceUtil.getNodeShowName((String)quorumServer.getServerIpA()));
        quorumServerNode.setToolTip(this.createServerToolTip(quorumServer, blankStr));
        quorumServerNode.setStyle("select.alpha", 1.0);
        quorumServerNode.setStyle("select.style", (Object)"none");
        this.initNodeLocation(quorumServerNode, fatherNode, layout);
        this.addIdtoList(context.getServerNodeIds(), nodeId);
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)quorumServerNode);
        return quorumServerNode;
    }

    private void setStatusAndTooltips(QuorumServer quorumServer, Node quorumServerNode, ITopoResourceManager resourceManager, String blankStr) {
        String statusTitle = resourceManager.getText("ism.drm.topo.quorumserver.status");
        String toolTips = quorumServerNode.getToolTip();
        int index = toolTips.indexOf(statusTitle);
        String ipInfo = toolTips.substring(0, index - 1);
        String statusInfo = toolTips.substring(index);
        String onlineState = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.ONLINE.getValue());
        String imageInfo = quorumServerNode.getImage();
        if (!"/theme/recoverydirector/images/topo/quorumserver.png".equals(imageInfo) && onlineState.equals(quorumServer.getRunningState())) {
            this.setImageByStatus(quorumServerNode, quorumServer.getRunningState());
            statusInfo = statusTitle + " " + resourceManager.getText("ism.drm.host.online");
        }
        String activeip = quorumServer.getServerIpA();
        String standbyip = quorumServer.getServerIpB();
        if (!ipInfo.contains(activeip)) {
            ipInfo = ipInfo + "\n" + blankStr + activeip;
        }
        if (!VerifyUtil.isEmpty((String)standbyip) && !ipInfo.contains(standbyip)) {
            ipInfo = ipInfo + "\n" + blankStr + standbyip;
        }
        quorumServerNode.setToolTip(ipInfo + "\n" + statusInfo);
    }

    private void setImageByStatus(Node hostNode, String status) {
        int iStatus = this.getIntFromStr(status);
        logger.debug((Object)("iStatus:" + iStatus));
        if (iStatus == XveEuumDefineParent.RUNNING_STATUS_E.ONLINE.getValue()) {
            hostNode.setImage("/theme/recoverydirector/images/topo/quorumserver.png");
            hostNode.setStyle("label.color", 35020);
        } else if (iStatus == XveEuumDefineParent.RUNNING_STATUS_E.OFFLINE.getValue()) {
            hostNode.setImage("/theme/recoverydirector/images/topo/quorumserver_offline.png");
            hostNode.setStyle("label.color", 0x999999);
        } else {
            hostNode.setImage("/theme/recoverydirector/images/topo/quorumserver_unknown.png");
            hostNode.setStyle("label.color", 0x999999);
        }
    }

    private String createServerToolTip(QuorumServer quorumServer, String blankStr) {
        String activeip = quorumServer.getServerIpA();
        String standbyip = quorumServer.getServerIpB();
        String status = quorumServer.getRunningState();
        int iStatus = this.getIntFromStr(status);
        StringBuilder tooltipBuilder = new StringBuilder();
        if (!VerifyUtil.isEmpty((String)standbyip)) {
            activeip = activeip + "\n" + blankStr + standbyip;
        }
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.storage.ip", (String)activeip);
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        if (iStatus == XveEuumDefineParent.RUNNING_STATUS_E.ONLINE.getValue()) {
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.quorumserver.status", (String)resourceManager.getText("ism.drm.host.online"));
        } else if (iStatus == XveEuumDefineParent.RUNNING_STATUS_E.OFFLINE.getValue()) {
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.quorumserver.status", (String)resourceManager.getText("ism.drm.host.offline"));
        } else {
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.quorumserver.status", (String)"--");
        }
        return tooltipBuilder.toString();
    }

    private boolean checkPoType(int poType) {
        logger.debug((Object)("poType:" + poType));
        return 0 < poType && poType <= 9 || poType == 13 || poType == 16 || poType == 15;
    }

    public void createStorageArray(TopoBaseContext context, ElementBox layout) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ProtectGroupReplica> replicas = this.queryProtectGroupReplicaByGroup(context);
        for (ProtectGroupReplica replica : replicas) {
            if (replica.getType() != 2 && replica.getType() != 1) continue;
            String productArraySN = replica.getProductArray();
            String recoverArraySN = replica.getRecoveryArray();
            Node productSiteNode = this.getOrCreateProductSiteNode(context, replica, layout);
            if (productSiteNode == null) {
                logger.debug((Object)"productSiteNode is null");
                continue;
            }
            Node recoverSiteNode = this.getOrCreateRecoverSiteNode(context, replica, layout);
            if (recoverSiteNode == null) continue;
            Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)productSiteNode, (Node)recoverSiteNode);
            if (link == null) {
                this.createStorageLink(context, productArraySN, productSiteNode, recoverArraySN, recoverSiteNode);
                continue;
            }
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    protected List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
    }

    public void createStorageLink(TopoBaseContext context, String productArraySN, Node productArrayNode, String recoverArraySN, Node recoverArrayNode) {
        if (productArraySN.equals(recoverArraySN)) {
            return;
        }
        ElementBox topoBox = context.getElementBox();
        ProtectGroup protectGroup = context.getProtectGroup();
        String sLinkID = "storagelink-" + protectGroup.getUuid() + ":" + productArraySN + "->" + recoverArraySN;
        Link link = new Link((Object)sLinkID, productArrayNode, recoverArrayNode);
        link.setClient("linkToXOffset", 10.0);
        link.setClient("devSN", (Object)productArraySN);
        link.setClient("trgSN", (Object)recoverArraySN);
        this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        link.setStyle("link.width", 1.0);
        link.setStyle("arrow.to", true);
        link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
        link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
        link.setStyle("arrow.to.shape", (Object)"arrow.delta");
        StringBuilder storageLinkTips = new StringBuilder();
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.status"));
        storageLinkTips.append(" ");
        int linkStatus = this.getStorageLinkStatus(context, productArraySN, recoverArraySN);
        if (linkStatus == 3 || linkStatus == 4) {
            link.setStyle("link.color", (Object)"0x1dcfef");
            link.setStyle("arrow.to.color", (Object)"0x1dcfef");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.unknown"));
        } else if (linkStatus == 2 || linkStatus == 1) {
            link.setStyle("link.color", (Object)"0xfc4133");
            link.setStyle("arrow.to.color", (Object)"0xfc4133");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.allbreak"));
        } else {
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.normal"));
        }
        link.setToolTip(storageLinkTips.toString());
        link.setStyle("select.alpha", 1.0);
        link.setStyle("select.style", (Object)"none");
        TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
    }
}

