/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class UpdateClusterInfoObserverImpl
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(UpdateClusterInfoObserverImpl.class);
    private static final List<Integer> TYPES = Arrays.asList(2, 3, 1, 15);

    public void before(MessageEvent event) {
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        if (messageType != 0 && messageType != 3) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            this.updateProtectObjectInfo(object);
        }
    }

    private void updateProtectObjectInfo(DRMObject object) {
        ProtectGroup protectGroup = (ProtectGroup)object;
        LOGGER.info((Object)("begin Update ClusterInfo in ObserverImpl, and protectGroup is " + protectGroup.getName() + "and poType is " + protectGroup.getPoType()), 90160758786988L);
        if (!TYPES.contains(protectGroup.getPoType())) {
            return;
        }
        ArrayList poList = new ArrayList(protectGroup.getPolist());
        for (ProtectObject protectObject : poList) {
            if (protectObject.getPoType() == 14) continue;
            LOGGER.info((Object)("begin queryAndUpdateClusterInfo po is " + protectObject.getName() + " and poType is " + protectObject.getPoType()), 90160758786988L);
            DrHostUtil.queryAndUpdateClusterInfo((ProtectObject)protectObject);
        }
    }

    public void after(MessageEvent event) {
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

